#!/usr/bin/env python3
# -*- coding: utf-8 -*-
"""
DashScope API Key 获取指引
"""

import os
import sys

def main():
    print("=" * 80)
    print("DashScope API Key 获取指引")
    print("=" * 80)
    print()
    print("由于 DashScope API Key 管理暂无公开 OpenAPI 接口，请手动获取：")
    print()
    print("方法1: 从百炼控制台复制现有 API Key")
    print("  1. 访问: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key")
    print("  2. 点击任意 API Key 右侧的复制图标")
    print("  3. 复制完整的 API Key（格式: sk-xxxxxxxxxxxx）")
    print()
    print("方法2: 创建新的 API Key")
    print("  1. 访问: https://bailian.console.aliyun.com/cn-beijing/#/efm/api_key")
    print("  2. 点击 \"创建 API Key\" 按钮")
    print("  3. 填写描述（如：CosyVoice 语音合成测试）")
    print("  4. 点击确定，复制生成的 API Key")
    print()
    print("=" * 80)
    print("获取后，使用以下命令设置环境变量：")
    print()
    if sys.platform == 'win32':
        print("  Windows (CMD):")
        print("    set DASHSCOPE_API_KEY=sk-xxxxxxxxxxxx")
        print()
        print("  Windows (PowerShell):")
        print("    $env:DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'")
    else:
        print("  macOS/Linux:")
        print("    export DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'")
    print()
    print("然后运行启动脚本：")
    print()
    print("  ./start.sh       (macOS/Linux)")
    print("  python3 start.py (跨平台)")
    print("  start.bat        (Windows)")
    print()
    print("=" * 80)

if __name__ == "__main__":
    main()
