# 🎙️ CosyVoice Flask WebSocket 语音合成服务

基于 Flask + Socket.IO + WebSocket 的阿里云 CosyVoice 语音合成服务，开箱即用，一键启动。

## 📦 项目特点

- ✅ **一键启动** - 自动检查环境、安装依赖、启动服务
- ✅ **跨平台支持** - Windows、macOS、Linux 全平台兼容
- ✅ **实时合成** - WebSocket 流式音频传输，响应迅速
- ✅ **多音色支持** - 支持阿里云 CosyVoice 全系列音色
- ✅ **友好界面** - 简洁的 Web 操作界面

## 📁 项目结构

```
cosyvoiceFlask/
├── 📜 start.sh                           # Shell 启动脚本
├── 🔧 my_cosyvoice_websocket_server.py  # Flask 服务端主程序
├── 📋 requirements.txt                   # Python 依赖清单
├── 🔑 get_api_key.py                    # API Key 获取指引脚本
└── 📂 templates/
    └── my_cosyvoice_client.html         # 前端 Web 界面
```

## 🚀 快速开始

### 前置要求

- Python 3.7 或更高版本
- 阿里云 DashScope API Key

### 第一步：获取 API Key
根据官方文档获取API Key并配置到环境变量

### 第二步：启动服务

选择以下任一方式启动：

#### macOS/Linux (推荐)

```bash
./start.sh
```

#### 跨平台 Python 脚本

```bash
python3 start.py
```

#### Windows

双击 `start.bat` 或在命令行运行：

```cmd
start.bat
```

### 第三步：使用服务

启动成功后，在浏览器中访问：

```
http://localhost:9000
```

## 🎯 使用方法

### Web 界面使用

1. 打开浏览器访问 `http://localhost:9000`
2. 在文本框输入要合成的文字
3. 选择音色（可选，默认为 longanyang）
4. 点击 "合成语音" 按钮
5. 等待音频生成并自动播放

### 设置环境变量（可选）

如果不想每次都手动输入 API Key，可以设置环境变量：

**macOS/Linux:**

```bash
export DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'
```

**Windows (CMD):**

```cmd
set DASHSCOPE_API_KEY=sk-xxxxxxxxxxxx
```

**Windows (PowerShell):**

```powershell
$env:DASHSCOPE_API_KEY='sk-xxxxxxxxxxxx'
```


## ⚙️ 技术架构

### 核心技术栈

- **Flask** - 轻量级 Web 框架
- **Socket.IO** - 实时双向通信
- **WebSocket** - 与阿里云 DashScope API 通信
- **CosyVoice** - 阿里云语音合成模型

### 工作流程

```
┌─────────┐    Socket.IO    ┌──────────┐    WebSocket    ┌──────────────┐
│ Web前端 │ ◄─────────────► │Flask服务端│ ◄─────────────► │阿里云DashScope│
└─────────┘                 └──────────┘                 └──────────────┘
    │                            │                              │
    │ 1. 发送文本请求            │                              │
    ├──────────────────────────►│                              │
    │                            │ 2. 建立WebSocket连接         │
    │                            ├────────────────────────────►│
    │                            │ 3. 发送文本数据              │
    │                            ├────────────────────────────►│
    │                            │ 4. 流式返回音频数据          │
    │                            │◄────────────────────────────┤
    │ 5. 转发音频流              │                              │
    │◄───────────────────────────┤                              │
    │ 6. 播放音频                │                              │
```


## 🔧 配置说明

### 修改端口

编辑 `my_cosyvoice_websocket_server.py` 最后一行：

```python
if __name__ == '__main__':
    app.run(host='0.0.0.0', port=9000)  # 修改这里的端口号
```

### 修改音色

编辑 `my_cosyvoice_client.html` 第 670和722 行：


## 🛠️ 故障排除

### 问题 1: 端口被占用

**症状：** 启动时提示端口 9000 已被占用

**解决方法：**

```bash
# 查找占用端口的进程
lsof -i :9000        # macOS/Linux
netstat -ano | findstr :9000  # Windows

# 终止进程
kill -9 <PID>        # macOS/Linux
taskkill /PID <PID> /F  # Windows
```

或者修改配置使用其他端口。

### 问题 2: 依赖安装失败

**症状：** pip 安装依赖时报错

**解决方法：**

使用国内镜像源加速：

```bash
pip3 install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
```

或使用阿里云镜像：

```bash
pip3 install -r requirements.txt -i https://mirrors.aliyun.com/pypi/simple
```

### 问题 3: API Key 无效

**症状：** 合成时提示认证失败

**解决方法：**

1. 确认 API Key 格式正确（以 `sk-` 开头）
2. 访问控制台确认 API Key 状态
3. 确认账户有余额或免费额度
4. 重新获取并设置 API Key

### 问题 4: WebSocket 连接失败

**症状：** 控制台显示 WebSocket 错误

**可能原因及解决方法：**

1. **网络问题** - 检查网络连接，确认可以访问阿里云服务
2. **防火墙拦截** - 临时关闭防火墙测试
3. **代理设置** - 如使用代理，确认代理配置正确
4. **API Key 过期** - 重新获取 API Key

### 问题 5: Python 版本过低

**症状：** 启动脚本提示 Python 版本不支持

**解决方法：**

安装 Python 3.7 或更高版本：

- **macOS:** `brew install python@3.11`
- **Ubuntu/Debian:** `sudo apt install python3.11`
- **Windows:** 从 [python.org](https://www.python.org/downloads/) 下载安装

## 📊 性能优化建议

1. **使用本地缓存** - 对于相同文本，可以缓存音频文件
2. **连接复用** - 长时间使用时保持 WebSocket 连接
3. **文本预处理** - 优化文本分段逻辑以提高合成效率
4. **并发控制** - 限制同时进行的合成任务数量

## 🔒 安全建议

1. **不要提交 API Key** - 将 API Key 添加到 `.gitignore`
2. **使用环境变量** - 避免在代码中硬编码敏感信息
3. **限制访问** - 生产环境建议添加认证机制
4. **HTTPS** - 生产环境使用 HTTPS 加密传输

## 📝 开发指南

### 添加新功能

1. 修改 `my_cosyvoice_websocket_server.py` 添加服务端逻辑
2. 修改 `templates/my_cosyvoice_client.html` 添加前端界面

### 日志输出

服务端会在控制台输出详细日志：
- 客户端连接/断开事件
- 合成请求详情（文本、音色、会话ID）
- WebSocket 状态变化
- 错误堆栈信息

### 调试模式

修改 `my_cosyvoice_websocket_server.py` 启用 Flask 调试模式：

```python
if __name__ == '__main__':
    app.run(host='0.0.0.0', port=9000, debug=True)
```
