#import "RootTableViewController.h"
#import "NlsRootTableViewController.h"
#import "DashRootTableViewController.h"
#import "DashNlsRootTableViewController.h"
#import "nuisdk.framework/Headers/NeoNuiUtils.h"

@interface RootTableViewController () {
    IBOutlet UIButton *ServerButtion;
}

@end

@implementation RootTableViewController
#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

- (void) setupLabel:(int)index
              title:(NSString*)title {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat label_width = global_size.width;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 80;
    CGFloat label_x = 0;
    CGFloat label_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;
    
    CGRect label_rect = CGRectMake(label_x, label_y, label_width, label_height);
    UILabel* label = [[UILabel alloc] initWithFrame:label_rect];
    label.text = title;
    label.numberOfLines = 0;
    label.lineBreakMode = NSLineBreakByWordWrapping;
    label.textColor = [UIColor whiteColor];
//    label.backgroundColor = [UIColor whiteColor];
    label.font = [UIFont boldSystemFontOfSize:18];
    [self.view addSubview:label];
}

-(void) setupButton:(UIButton*)button
                    index:(int)index
                    title:(NSString*)title
                    action:(SEL)action {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    
    
    CGFloat button_x = 0;
    CGFloat button_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;

    button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(button_x, button_y, button_width, button_height);
    UIImage *button_image = [UIImage imageNamed:@"button_start"];
    [button setBackgroundImage:button_image forState:UIControlStateNormal];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:18];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

-(void) viewDidLoad {
    [super viewDidLoad];
    NSLog(@"tableView enter self.navigationController %@", self.navigationController);

    int idx = 0;
    
    NeoNuiUtils* nui_utils = [NeoNuiUtils get_instance];
    NSString *version = [NSString stringWithUTF8String:[nui_utils nui_uitls_get_version]];
    NSString *show_version = [NSString stringWithFormat:@"SDK版本号: %@", version];
    [self setupLabel:idx title:show_version];

    [self setupLabel:++idx title:@"实际开发切不可将账号信息存储在端侧"];
    
    idx += 2;
    [self setupButton:ServerButtion index:idx title:@"百炼(DASHSCOPE)" action:@selector(startDashScopeServer:)];
    [self setupLabel:++idx title:@"大模型服务平台百炼(DashScope)提供Paraformer/Gummy/Fun-ASR实时语音识别、实时语音翻译、录音文件识别、语音合成CosyVoice/Sambert等服务。"];

    idx += 3;
    [self setupButton:ServerButtion index:idx title:@"智能语音交互(NLS)" action:@selector(startNlsServer:)];
    [self setupLabel:++idx title:@"智能语音交互(NLS)提供语音合成、长文本语音合成、流式语音合成、离线语音合成、离线唤醒、一句话识别、实时语音识别、录音文件识别、听悟等服务。"];
    
    idx += 3;
    [self setupButton:ServerButtion index:idx title:@"NLS+DASHSCOPE混合" action:@selector(startDashNlsServer:)];
    [self setupLabel:++idx title:@"智能语音交互(NLS)和大模型服务平台百炼(DashScope)混合使用。例如使用离线唤醒后搭配百炼语音识别等服务。"];
}


- (IBAction)startDashScopeServer:(UIButton *)sender {
    UIViewController * controller = nil;
    controller = [[DashRootTableViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startNlsServer:(UIButton *)sender {
    UIViewController * controller = nil;
    controller = [[NlsRootTableViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
}

- (IBAction)startDashNlsServer:(UIButton *)sender {
    UIViewController * controller = nil;
    controller = [[DashNlsRootTableViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
}

@end
