#import "NlsRootTableViewController.h"
#import "TTSViewController.h"
#import "LocalTTSViewController.h"
#import "StreamInputTtsViewController.h"
#import "SpeechRecognizerViewController.h"
#import "WakeupAndSpeechRecognizerViewController.h"
#import "OnlyWakeupViewController.h"
#import "SpeechTranscriberViewController.h"
#import "RealtimeMeetingViewController.h"
#import "FileTranscriberViewController.h"
#import "NuiCfg.h"

@interface NlsRootTableViewController () {
    IBOutlet UIButton *ASRButtion;
}

@end

@implementation NlsRootTableViewController
#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

-(void) setupButton:(UIButton*)button
                    index:(int)index
                    title:(NSString*)title
                    action:(SEL)action {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    
    
    CGFloat button_x = 0;
    CGFloat button_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;

    button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(button_x, button_y, button_width, button_height);
    UIImage *button_image = [UIImage imageNamed:@"button_start"];
    [button setBackgroundImage:button_image forState:UIControlStateNormal];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:18];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

-(void) viewDidLoad {
    [super viewDidLoad];
    NSLog(@"tableView enter self.navigationController %@", self.navigationController);
    
    int idx = 1;
#ifdef SDK_NUI
    [self setupButton:ASRButtion index:idx++ title:@"一句话识别" action:@selector(startSpeechRecognizer:)];
    [self setupButton:ASRButtion index:idx++ title:@"实时转写/实时识别" action:@selector(startSpeechTranscriber:)];
    [self setupButton:ASRButtion index:idx++ title:@"实时记录/实时推流(听悟)" action:@selector(startRealtimeMeeting:)];
#endif
#ifdef SDK_TTS
    [self setupButton:ASRButtion index:idx++ title:@"语音合成(流式输出)" action:@selector(startTts:)];
    [self setupButton:ASRButtion index:idx++ title:@"离线语音合成(离线功能-部分版本支持)" action:@selector(startLocalTts:)];
#endif
#ifdef SDK_STREAM_INPUT_TTS
    [self setupButton:ASRButtion index:idx++ title:@"流式语音合成(流式输入流式输出)/CosyVoice大模型" action:@selector(startStreamInputTts:)];
#endif
#ifdef SDK_FILE_TRANS
    [self setupButton:ASRButtion index:idx++ title:@"文件转写极速版" action:@selector(startFileTranscriber:)];
#endif
#ifdef SDK_NUI
    [self setupButton:ASRButtion index:idx++ title:@"唤醒(离线功能-部分版本支持)" action:@selector(startOnlyWakeup:)];
    [self setupButton:ASRButtion index:idx++ title:@"唤醒识别(离线功能-部分版本支持)" action:@selector(startWakeupAndSpeechRecognizer:)];
#endif

}

- (IBAction)startSpeechRecognizer:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[SpeechRecognizerViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startSpeechTranscriber:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[SpeechTranscriberViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startRealtimeMeeting:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[RealtimeMeetingViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startFileTranscriber:(UIButton *)sender {
#ifdef SDK_FILE_TRANS
    UIViewController * controller = nil;
    controller = [[FileTranscriberViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}


- (IBAction)startTts:(UIButton *)sender {
#ifdef SDK_TTS
    UIViewController * controller = nil;
    controller = [[TTSViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}
- (IBAction)startLocalTts:(UIButton *)sender {
#ifdef SDK_TTS
    UIViewController * controller = nil;
    controller = [[LocalTTSViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}
- (IBAction)startStreamInputTts:(UIButton *)sender {
#ifdef SDK_STREAM_INPUT_TTS
    UIViewController * controller = nil;
    controller = [[StreamInputTtsViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startOnlyWakeup:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[OnlyWakeupViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

- (IBAction)startWakeupAndSpeechRecognizer:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[WakeupAndSpeechRecognizerViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

//- (IBAction)startLocalSpeechRecognizer:(UIButton *)sender {
//#ifdef SDK_LOCAL_ASR
//    UIViewController * controller = nil;
//    controller = [[LocalSpeechRecognizerViewController alloc] init];
//    [self.navigationController pushViewController:controller animated:YES];
//#endif
//}

//- (IBAction)startMonkey:(UIButton *)sender {
//    UIViewController * controller = nil;
//    controller = [[MonkeyViewController alloc] init];
//    [self.navigationController pushViewController:controller animated:YES];
//}
@end
