//
//  FileTranscriberViewController.m
//  NUIdemo
//
//  Created by zhouguangdong on 2020/8/22.
//  Copyright © 2020 Alibaba idst. All rights reserved.
//

#import <Foundation/Foundation.h>
#define DEBUG_MODE
#import "nuisdk.framework/Headers/NeoNui.h"
#import "FileTranscriberViewController.h"
#import "AppDelegate.h"
#import "NuiSdkUtils.h"

#include <sys/time.h>
#include <time.h>

#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

static bool save_wav = false;
static bool save_log = false;
static dispatch_queue_t ft_work_queue;

@interface FileTranscriberViewController ()<NeoNuiSdkDelegate>  {
    IBOutlet UIButton *StartButton;
    IBOutlet UIButton *StopButton;

    IBOutlet UITextView *textViewKws;
    IBOutlet UITextView *textViewAsr;
    IBOutlet UITextView *textViewDialog;

    IBOutlet UISwitch *switchLog;

    IBOutlet UITextField *textfield;
    IBOutlet UITextField *textVersion;
    
    IBOutlet UILabel *SaveWavLabel;
}
@property(nonatomic,strong) NeoNui* nui;
@property(nonatomic,strong) NuiSdkUtils *utils;
@property(nonatomic,strong) NSMutableArray *task_list;

- (IBAction)showStart;
- (IBAction)showStop;
@end

@implementation FileTranscriberViewController

#pragma mark - View Callback Action
- (void)viewDidLoad {
    [super viewDidLoad];
    TLog(@"DialogViewController did load");
    
    [self InitView];

    _utils = [NuiSdkUtils alloc];

    _task_list = [[NSMutableArray alloc]init];

    ft_work_queue = dispatch_queue_create("NuiFTController", DISPATCH_QUEUE_CONCURRENT);

    [self initNui];
    NSString *version = [NSString stringWithUTF8String:[_nui nui_get_version]];
    self->textVersion.text = version;
}

-(void)viewWillDisappear:(BOOL)animated {
    NSLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    if (_nui != nil) {
        [_nui nui_release];
        _nui.delegate = nil;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - UI action
- (IBAction)StartButHandler:(UIButton *)sender{
    TLog(@"click START BUTTON");
    [self showStart];
}

- (IBAction)StopButHandler:(id)sender {
    TLog(@"click STOP BUTTON");
    [self showStop];
}

-(IBAction)showStart {
    dispatch_async(dispatch_get_main_queue(), ^{
        // UI更新代码
        [self->StartButton setEnabled:NO];
        [self->StartButton setAlpha:0.4];
        [self->StopButton setEnabled:YES];
        [self->StopButton setAlpha:1.0];
    });
    
    dispatch_async(ft_work_queue, ^{
        int max_tasks = 1;
        if (_nui != nil) {
            for (int i=0; i<max_tasks; i++) {
                NSString *params = [self genStartParams];
                char task_id[33] = {0};
                int ret = [_nui nui_file_trans_start:[params UTF8String] taskId:task_id];
                if (ret == SUCCESS) {
                    NSLog(@"start trans task %s", task_id);
                    [_task_list addObject:[NSString stringWithUTF8String:task_id]];
                }
            }
        } else {
            TLog(@"in StartButHandler no nui alloc");
        }
    });
}

-(IBAction)showStop {
    
    if (_nui != nil) {
        NSArray* array = [NSArray arrayWithArray: _task_list];
        for (id task in array) {
            [_nui nui_file_trans_cancel:[task UTF8String]];
            [_task_list removeObject:task];
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [self->StartButton setEnabled:YES];
            [self->StartButton setAlpha:1.0];
            [self->StopButton setEnabled:NO];
            [self->StopButton setAlpha:0.4];
        });
    } else {
        TLog(@"in StopButHandler no nui alloc");
    }
}

-(IBAction)switchLogAction:(id)sender
{
    UISwitch *switchButton = (UISwitch*)sender;
    BOOL isButtonOn = [switchButton isOn];

    TLog(@"set save wav to %d from %d",
              isButtonOn, save_wav);
    save_wav = isButtonOn;
    save_log = isButtonOn;
    [self terminateNui];
    usleep(200*1000);
    [self initNui];
    [self showStop];
    [self showStart];
}


- (void)terminateNui {
    TLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    [_nui nui_release];
}

-(void)dealloc{
    NSLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    if (_nui != nil) {
        [_nui nui_release];
        _nui.delegate = nil;
    }
}

#pragma mark - Nui Listener
-(void)onFileTransEventCallback:(NuiCallbackEvent)nuiEvent
                asrResult:(const char *)asr_result
                   taskId:(const char *)task_id
                 ifFinish:(bool)finish
                  retCode:(int)code {
    TLog(@"onFileTransEventCallback event %d finish %d task_id %s", nuiEvent, finish, task_id);
    if (nuiEvent == EVENT_FILE_TRANS_CONNECTED) {
        [self showAsrResult:@"连接成功，正在上传..."];
    } else if (nuiEvent == EVENT_FILE_TRANS_UPLOADED) {
        [self showAsrResult:@"完成上传，正在转写..."];
    } else if (nuiEvent == EVENT_FILE_TRANS_RESULT) {
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [self showAsrResult:result];
    } else if (nuiEvent == EVENT_ASR_ERROR) {
        TLog(@"EVENT_ASR_ERROR error[%d]", code);
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [self showAsrResult:result];
    }
    
    if (finish) {
        [_task_list removeObject:[NSString stringWithUTF8String:task_id]];
        if ([_task_list count] == 0) {
            dispatch_async(dispatch_get_main_queue(), ^{
                // UI更新代码
                [self->StartButton setEnabled:YES];
                [self->StartButton setAlpha:1.0];
                [self->StopButton setEnabled:NO];
                [self->StopButton setAlpha:0.4];
            });
        }
    }
    
    return;
}

-(void)onFileTransLogTrackCallback:(NuiSdkLogLevel)level
                        logMessage:(const char *)log {
    TLog(@"onFileTransLogTrackCallback log level:%d, message -> %s", level, log);
}

#pragma mark - Private methods

-(void) showAsrResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        self->textViewAsr.text = result;
    });
}

-(NSString*) genInitParams {
//    NSString *strResourcesBundle = [[NSBundle mainBundle] pathForResource:@"Resources" ofType:@"bundle"];
//    NSString *bundlePath = [[NSBundle bundleWithPath:strResourcesBundle] resourcePath]; // 注意: V2.6.2版本开始纯云端功能可不需要资源文件
    NSString *debug_path = [_utils createDir];
    
    NSMutableDictionary *ticketJsonDict = [NSMutableDictionary dictionary];
    //获取账号访问凭证：
    [_utils getTicket:ticketJsonDict Type:get_token_from_server_for_online_features];
    if ([ticketJsonDict objectForKey:@"token"] != nil) {
        NSString *tokenValue = [ticketJsonDict objectForKey:@"token"];
        if ([tokenValue length] == 0) {
            TLog(@"The 'token' key exists but the value is empty.");
        }
    } else {
        TLog(@"The 'token' key does not exist.");
    }

    //工作目录路径，SDK从该路径读取配置文件
//    [ticketJsonDict setObject:bundlePath forKey:@"workspace"]; // V2.6.2版本开始纯云端功能可不设置workspace
    //debug目录。当初始化SDK时的save_log参数取值为true时，该目录用于保存中间音频文件
    [ticketJsonDict setObject:debug_path forKey:@"debug_path"];
    [ticketJsonDict setObject:@"https://nls-gateway.cn-shanghai.aliyuncs.com/stream/v1/FlashRecognizer" forKey:@"url"]; // 必填

    //过滤SDK内部日志通过回调送回到用户层
    [ticketJsonDict setObject:[NSString stringWithFormat:@"%d", NUI_LOG_LEVEL_INFO] forKey:@"log_track_level"];
    //设置本地存储日志文件的最大字节数, 最大将会在本地存储2个设置字节大小的日志文件
    [ticketJsonDict setObject:@(50 * 1024 * 1024) forKey:@"max_log_file_size"];

    //FullMix = 0   // 选用此模式开启本地功能并需要进行鉴权注册
    //FullCloud = 1 // 在线实时语音识别可以选这个
    //FullLocal = 2 // 选用此模式开启本地功能并需要进行鉴权注册
    //AsrMix = 3    // 选用此模式开启本地功能并需要进行鉴权注册
    //AsrCloud = 4  // 在线一句话识别可以选这个
    //AsrLocal = 5  // 选用此模式开启本地功能并需要进行鉴权注册
    [ticketJsonDict setObject:@"1" forKey:@"service_mode"]; // 必填，不可改

    [ticketJsonDict setObject:@"empty_device_id" forKey:@"device_id"]; // 必填, 推荐填入具有唯一性的id, 方便定位问题

    NSData *data = [NSJSONSerialization dataWithJSONObject:ticketJsonDict options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}
-(NSString*) genParams {
    NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];
    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    [dictM setObject:nls_config forKey:@"nls_config"];

//    如果有HttpDns则可进行设置
//    [dictM setObject:[_utils getDirectIp] forKey:@"direct_ip"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}

-(NSString*) genStartParams {
    /**
     * 参数详见
     * 接口说明：
     *  https://help.aliyun.com/zh/isi/developer-reference/sdk-reference-9
     * 移动端SDK说明：
     *  https://help.aliyun.com/zh/isi/developer-reference/sdks-for-mobile-clients
     */

    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];

    //若想在运行时切换app_key
//    [dictM setObject:@"xxx" forKey:@"app_key"];

    // 如想识别test.wav文件
    NSString *file = [[NSBundle mainBundle] pathForResource:@"thirdparty/asr_example" ofType:@"wav"];
    [dictM setObject:file forKey:@"file_path"];

    /*音频编码格式。支持格式：MP4、AAC、MP3、OPUS、WAV。*/
    [nls_config setObject:@"wav" forKey:@"format"];

    /*
     * 表示语音识别模型的采样率，上传的音频如果不符合其取值会被自动升/降采样率至8000或16000。
     * 取值：16000（非电话）/8000（电话）。默认：16000。
     */
//    [nls_config setObject:@(16000) forKey:@"sample_rate"];
    
    /*添加热词表ID。默认：不添加。*/
//    [nls_config setObject:@"xxx" forKey:@"vocabulary_id"];

    /*添加自学习模型ID。默认：不添加。*/
//    [nls_config setObject:@"xxx" forKey:@"customization_id"];

    /*
     * ITN（逆文本inverse text normalization）中文数字转换阿拉伯数字。
     * 设置为True时，中文数字将转为阿拉伯数字输出，默认值：False。
     */
//    [nls_config setObject:@(YES) forKey:@"enable_inverse_text_normalization"];

    /*是否返回词级别信息。取值：true或false。默认：false（不开启）。*/
//    [nls_config setObject:@(YES) forKey:@"enable_word_level_result"];
    
    /*是否启用时间戳校准功能，取值：true或false，默认：false（不开启）。*/
//    [nls_config setObject:@(YES) forKey:@"enable_timestamp_alignment"];

    /*
     * 是否只识别首个声道，取值：true/false。（如果录音识别结果重复，您可以开启此参数。）
     * 默认为空：8k处理双声道，16k处理单声道。
     *  false：8k处理双声道，16k处理双声道。
     *  true：8k处理单声道，16k处理单声道。
     */
//    [nls_config setObject:@(YES) forKey:@"first_channel_only"];
    
    /*
     * 噪音参数阈值，取值范围：[-1, 1]。取值说明如下：
     * 取值越趋于-1，噪音被判定为语音的概率越大。
     * 取值越趋于+1，语音被判定为噪音的概率越大。
     */
//    [nls_config setObject:@(-0.1) forKey:@"speech_noise_threshold"];
    
    /*
     * 敏感词过滤功能，支持开启或关闭，支持自定义敏感词。该参数可实现：
     * 不处理（默认，即展示原文）、过滤、替换为*。
     * */
    // 以实时转写为例
//    NSMutableDictionary *filter_root = [NSMutableDictionary dictionary];
//    [nls_config setObject:@(YES) forKey:@"system_reserved_filter"];
//    // 将以下词语替换成空
//    NSMutableDictionary *filter_root1 = [NSMutableDictionary dictionary];
//    NSMutableArray *filter_array1 = [NSMutableArray array];
//    [filter_array1 addObject:@"开始"];
//    [filter_array1 addObject:@"发生"];
//    [filter_root1 setObject:filter_array1 forKey:@"word_list"];
//    // 将以下词语替换成*
//    NSMutableDictionary *filter_root2 = [NSMutableDictionary dictionary];
//    NSMutableArray *filter_array2 = [NSMutableArray array];
//    [filter_array2 addObject:@"测试"];
//    [filter_root2 setObject:filter_array2 forKey:@"word_list"];
//    // 可以全部设置，也可以部分设置
//    [filter_root setObject:filter_root1 forKey:@"filter_with_empty"];
//    [filter_root setObject:filter_root2 forKey:@"filter_with_signed"];
//    NSError *error;
//    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:filter_root options:0 error:&error];
//    if (!jsonData) {
//        NSLog(@"Error converting to JSON: %@", error);
//    } else {
//        NSString *jsonString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
//        [nls_config setObject:jsonString forKey:@"special_word_filter"];
//    }

    /*
     * 每句最多展示字数，取值范围：[4，50]。默认不启用该功能。启用后如不填写字数，则按照长句断句。
     * 该参数可用于字幕生成场景，控制单行字幕最大字数。
     */
//    [nls_config setObject:@(10) forKey:@"sentence_max_length"];

    /*若文档中不包含某些参数，但是此功能支持这个参数，可以用如下万能接口设置参数*/
//    NSMutableDictionary *extend_config = [NSMutableDictionary dictionary];
//    [extend_config setValue:@YES forKey:@"custom_test"];
//    [dictM setObject:extend_config forKey:@"extend_config"];
    
    [dictM setObject:nls_config forKey:@"nls_config"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    NSLog(@"start params %@", jsonStr);
    return jsonStr;
}


- (void) initNui {
    if (_nui == NULL) {
        _nui = [NeoNui get_instance];
        _nui.delegate = self;
    }
    //请注意此处的参数配置，其中账号相关需要按照genInitParams的说明填入后才可访问服务
    NSString * initParam = [self genInitParams];

    [_nui nui_initialize:[initParam UTF8String] logLevel:NUI_LOG_LEVEL_VERBOSE saveLog:save_log];
    NSString * parameters = [self genParams];
    [_nui nui_set_params:[parameters UTF8String]];
}



#pragma mark - View
-(void)InitView {
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.title = @"文件转写";
/*---------------------------------Button---------------------------------------------*/
    //Start Button
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width/SCREEN_WIDTH_BASE * 70;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    
    CGFloat x = global_size.width/SCREEN_WIDTH_BASE * 27.5;
    CGFloat y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StartButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StartButton.frame = CGRectMake(x, y, button_width, button_height);
    UIImage *image = [UIImage imageNamed:@"button_start"];
    [StartButton setBackgroundImage:image forState:UIControlStateNormal];
    [StartButton setTitle:@"开始" forState:UIControlStateNormal];
    [StartButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StartButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StartButton addTarget:self action:@selector(StartButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StartButton];
    
    //stop Button
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5+90*2);
    y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    
    StopButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StopButton.frame = CGRectMake(x, y, button_width, button_height);
    image = [UIImage imageNamed:@"button_start"];
    [StopButton setBackgroundImage:image forState:UIControlStateNormal];
    [StopButton setTitle:@"结束" forState:UIControlStateNormal];
    [StopButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StopButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StopButton addTarget:self action:@selector(StopButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StopButton];
    
    
/*---------------------------------UITextView---------------------------------------------*/
    //kws text view
    CGFloat kws_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat kws_view_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110;
    
    CGRect textViewContent_rect = CGRectMake(x, y, kws_view_width, kws_view_height);
    if (!textViewKws) {
        textViewKws = [[UITextView alloc] initWithFrame:textViewContent_rect];
    }
    textViewKws.layer.borderWidth = 0.6;
    textViewKws.layer.borderColor = [UIColor blackColor].CGColor;
    textViewKws.layer.cornerRadius = 10;
    [textViewKws setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewKws.scrollEnabled = YES;
    
    textViewKws.textColor = [UIColor darkGrayColor];
    textViewKws.font = [UIFont systemFontOfSize:10];
//    [self.view addSubview:textViewKws];
    
    //wakeup text view
    CGFloat asr_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat asr_view_height = global_size.height/SCREEN_HEIGHT_BASE * 60;
    x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10;
    
    CGRect asr_rect = CGRectMake(x, y, asr_view_width, asr_view_height);
    if (!textViewAsr) {
        textViewAsr = [[UITextView alloc] initWithFrame:asr_rect];
    }
    textViewAsr.layer.borderWidth = 0.6;
    textViewAsr.layer.borderColor = [UIColor blackColor].CGColor;
    textViewAsr.layer.cornerRadius = 10;
    [textViewAsr setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewAsr.scrollEnabled = YES;
    
    textViewAsr.textColor = [UIColor darkGrayColor];
    textViewAsr.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewAsr];
    
    //dialog text view
    CGFloat dialog_view_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat dialog_view_height = global_size.height/SCREEN_HEIGHT_BASE * 120;
    CGFloat dialog_x = global_size.width/SCREEN_WIDTH_BASE * (27.5);
    CGFloat dialog_y = global_size.height/SCREEN_HEIGHT_BASE * 110 + kws_view_height + 10 + asr_view_height + 10;
    
    CGRect dialog_rect = CGRectMake(dialog_x, dialog_y, dialog_view_width, dialog_view_height);
    if (!textViewDialog) {
        textViewDialog = [[UITextView alloc] initWithFrame:dialog_rect];
    }
    textViewDialog.layer.borderWidth = 0.6;
    textViewDialog.layer.borderColor = [UIColor blackColor].CGColor;
    textViewDialog.layer.cornerRadius = 10;
    [textViewDialog setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewDialog.scrollEnabled = YES;
    
    textViewDialog.textColor = [UIColor darkGrayColor];
    textViewDialog.font = [UIFont systemFontOfSize:10];
//    [self.view addSubview:textViewDialog];
    
    /*---------------------------------Switch---------------------------------------------*/
    
    CGFloat switch_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat switch_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    CGFloat label_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    //switch save wav
    CGFloat save_wav_label_x = dialog_x;
    CGFloat save_wav_label_y = dialog_y + dialog_view_height + label_height;

    CGRect save_wav_label_rect = CGRectMake(save_wav_label_x, save_wav_label_y, label_width, label_height);
    if (!SaveWavLabel) {
        SaveWavLabel = [[UILabel alloc] initWithFrame:save_wav_label_rect];
    }
    SaveWavLabel.text = @"音频保存";
//    [self.view addSubview:SaveWavLabel];

    CGFloat save_wav_switch_x = save_wav_label_x + label_width;
    CGFloat save_wav_switch_y = save_wav_label_y;
    CGRect save_wav_switch_rect = CGRectMake(save_wav_switch_x, save_wav_switch_y, switch_width, switch_height);
    switchLog = [[UISwitch alloc] initWithFrame:save_wav_switch_rect];
    [switchLog addTarget:self action:@selector(switchLogAction:) forControlEvents:UIControlEventTouchUpInside];
//    [self.view addSubview:switchLog];
    
    /*---------------------------------------TextField----------------------------------*/
    
    CGFloat text_field_width = global_size.width/SCREEN_WIDTH_BASE * 340;
    CGFloat text_field_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    //text field
    CGFloat text_field_x = save_wav_label_x;
    CGFloat text_field_y = save_wav_switch_y + label_height + label_height;
    
    CGRect text_field_rect = CGRectMake(text_field_x, text_field_y, text_field_width, text_field_height);
    textfield = [[UITextField alloc] initWithFrame:text_field_rect];
    textfield.layer.borderWidth = 0.6;
    textfield.layer.borderColor = [UIColor blackColor].CGColor;
    textfield.layer.cornerRadius = 10;
    [textfield setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textfield.textColor = [UIColor darkGrayColor];
    textfield.font = [UIFont systemFontOfSize:15];
//    [self.view addSubview:textfield];
    
    //text sdk version
    CGFloat text_version_x = text_field_x;
    CGFloat text_version_y = text_field_y + text_field_height + 2;
    
    CGRect text_version_rect = CGRectMake(text_version_x, text_version_y, text_field_width, text_field_height);
    textVersion = [[UITextField alloc] initWithFrame:text_version_rect];

    textVersion.layer.borderWidth = 0.6;
    textVersion.layer.borderColor = [UIColor blackColor].CGColor;
    textVersion.layer.cornerRadius = 10;
    [textVersion setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    
    textVersion.textColor = [UIColor darkGrayColor];
    textVersion.font = [UIFont systemFontOfSize:15];
    [self.view addSubview:textVersion];
    
    
    [self->StartButton setEnabled:YES];
    [self->StartButton setAlpha:1.0];
    [self->StopButton setEnabled:NO];
    [self->StopButton setAlpha:0.4];
    
    textViewKws.scrollEnabled = YES;
    textViewAsr.scrollEnabled = YES;
    textViewDialog.scrollEnabled = YES;
    
    textViewKws.editable = NO;
    textViewAsr.editable = NO;
    textViewDialog.editable = NO;
    
    self->textVersion.minimumFontSize = 10;
    self->textfield.minimumFontSize = 10;
}


@end
