//
//  DashParaformerFileTranscriberViewController.m
//  NUIdemo
//
//  Created by shichen.fsc on 2025/9/15.
//  Copyright © 2025 Alibaba idst. All rights reserved.
//

#import <Foundation/Foundation.h>
#define DEBUG_MODE
#import "nuisdk.framework/Headers/NeoNui.h"
#import "DashParaformerFileTranscriberViewController.h"
#import "AppDelegate.h"
#import "NuiSdkUtils.h"
#import "HWOptionButton.h"

#include <sys/time.h>
#include <time.h>

#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

static dispatch_queue_t ft_work_queue;
static NSString *default_wav_address = @"https://gw.alipayobjects.com/os/bmw-prod/0574ee2e-f494-45a5-820f-63aee583045a.wav";
static NSString *default_mp3_address = @"https://dashscope.oss-cn-beijing.aliyuncs.com/samples/audio/sensevoice/long_audio_demo_cn.mp3";
static NSString *default_mp4_address = @"https://dashscope.oss-cn-beijing.aliyuncs.com/samples/audio/sensevoice/sample_video_poetry.mp4";

// iOS SDK: https://help.aliyun.com/zh/model-studio/paraformer-recorded-speech-recognition-ios-sdk
@interface DashParaformerFileTranscriberViewController ()<HWOptionButtonDelegate, NeoNuiSdkDelegate>  {
    IBOutlet UIButton *StartButton;
    IBOutlet UIButton *QueryButton;
    IBOutlet UIButton *StopButton;

    IBOutlet UILabel *SyncLabel;
    IBOutlet UISwitch *switchSync;

    IBOutlet UILabel *ContenLabel;
    IBOutlet UITextView *textViewContent;
    
    IBOutlet UITextView *textViewEvent;
}

@property(nonatomic, weak) HWOptionButton *modelHW;

@property(nonatomic,strong) NeoNui* nui;
@property(nonatomic,strong) NuiSdkUtils *utils;
@property(nonatomic,strong) NSMutableArray *task_list;

- (IBAction)showStart;
- (IBAction)showQuery;
- (IBAction)showStop;
@end

@implementation DashParaformerFileTranscriberViewController

#pragma mark - View Callback Action
- (void)viewDidLoad {
    [super viewDidLoad];
    TLog(@"DashParaformerFileTranscriberViewController did load");

    TLog(@"Get API Key: %@", self.apikey);
    TLog(@"Get URL: %@", self.url);

    [self InitView];

    _utils = [NuiSdkUtils alloc];

    _task_list = [[NSMutableArray alloc]init];

    ft_work_queue = dispatch_queue_create("NuiParaformerFTController", DISPATCH_QUEUE_CONCURRENT);

    [self initNui];
}

-(void)viewWillDisappear:(BOOL)animated {
    NSLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    if (_nui != nil) {
        [_nui nui_release];
        _nui.delegate = nil;
    }
}

- (void)didReceiveMemoryWarning {
    [super didReceiveMemoryWarning];
}

#pragma mark - UI action
- (IBAction)StartButHandler:(UIButton *)sender{
    TLog(@"click START BUTTON");
    [self showStart];
}

- (IBAction)QueryButHandler:(UIButton *)sender{
    TLog(@"click QUERY BUTTON");
    [self showQuery];
}

- (IBAction)StopButHandler:(id)sender {
    TLog(@"click STOP BUTTON");
    [self showStop];
}

-(IBAction)showStart {
    dispatch_async(dispatch_get_main_queue(), ^{
        // UI更新代码
        [self->StartButton setEnabled:NO];
        [self->StartButton setAlpha:0.4];
        [self->StopButton setEnabled:YES];
        [self->StopButton setAlpha:1.0];
        if (switchSync.on) {
            [self->QueryButton setEnabled:YES];
            [self->QueryButton setAlpha:1.0];
        } else {
            [self->QueryButton setEnabled:NO];
            [self->QueryButton setAlpha:0.4];
        }
    });
    
    dispatch_async(ft_work_queue, ^{
        int max_tasks = 1;
        if (_nui != nil) {
            for (int i = 0; i < max_tasks; i++) {
                NSString *params = [self genStartParams];
                char task_id[33] = {0};
                int ret = [_nui nui_file_trans_start:[params UTF8String] taskId:task_id];
                if (ret == SUCCESS) {
                    NSLog(@"start trans task %s", task_id);
                    [_task_list addObject:[NSString stringWithUTF8String:task_id]];
                }
            }
        } else {
            TLog(@"in StartButHandler no nui alloc");
        }
    });
}

-(IBAction)showQuery {
    if (_nui != nil) {
        NSArray* array = [NSArray arrayWithArray: _task_list];
        for (id task in array) {
            [_nui nui_file_trans_query:[task UTF8String]];
        }
    } else {
        TLog(@"in StartButHandler no nui alloc");
    }
}

-(IBAction)showStop {
    if (_nui != nil) {
        NSArray* array = [NSArray arrayWithArray: _task_list];
        for (id task in array) {
            [_nui nui_file_trans_cancel:[task UTF8String]];
            [_task_list removeObject:task];
        }
        
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [self->StartButton setEnabled:YES];
            [self->StartButton setAlpha:1.0];
            [self->StopButton setEnabled:NO];
            [self->StopButton setAlpha:0.4];
            [self->QueryButton setEnabled:NO];
            [self->QueryButton setAlpha:0.4];
        });
    } else {
        TLog(@"in StopButHandler no nui alloc");
    }
}

-(IBAction)switchSyncAction:(id)sender
{
    UISwitch *switchButton = (UISwitch*)sender;
    BOOL isButtonOn = [switchButton isOn];
    TLog(@"Set sync query to %@", isButtonOn ? @"YES" : @"NO");
    dispatch_async(dispatch_get_main_queue(), ^{
        if (isButtonOn) {
            SyncLabel.text = @"异步请求，手动查询结果";
            [self->QueryButton setEnabled:YES];
            [self->QueryButton setAlpha:1.0];
        } else {
            SyncLabel.text = @"同步请求，直到返回结果";
            [self->QueryButton setEnabled:NO];
            [self->QueryButton setAlpha:0.4];
        }
    });
}


- (void)terminateNui {
    NSLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    if (_nui != nil) {
        [_nui nui_release];
        _nui.delegate = nil;
    }
}

-(void)dealloc{
    NSLog(@"%s", __FUNCTION__);
    // 若_nui未进行释放, 下次进入此view使用的_nui处于已初始化,
    // 则再调用nui_initialize无法覆盖已经设置的参数.
    if (_nui != nil) {
        [_nui nui_release];
        _nui.delegate = nil;
    }
}

#pragma mark - Nui Listener
-(void)onFileTransEventCallback:(NuiCallbackEvent)nuiEvent
                asrResult:(const char *)asr_result
                   taskId:(const char *)task_id
                 ifFinish:(bool)finish
                  retCode:(int)code {
    TLog(@"onFileTransEventCallback event %d finish %d task_id %s", nuiEvent, finish, task_id);
    if (nuiEvent == EVENT_FILE_TRANS_CONNECTED) {
        [self showEventResult:@"成功链接服务..."];
    } else if (nuiEvent == EVENT_FILE_TRANS_UPLOADED) {
        NSString *content = [NSString stringWithFormat:@"完成上传，正在转写... task_id:%s", task_id];
        [self showEventResult:content];
    } else if (nuiEvent == EVENT_FILE_TRANS_QUERY_RESULT) {
        NSString *content = [NSString stringWithFormat:@"正在识别... task_id:%s\n\n%s", task_id, asr_result];
        [self showEventResult:content];
    } else if (nuiEvent == EVENT_FILE_TRANS_RESULT) {
        TLog(@"EVENT_FILE_TRANS_RESULT task_id:%s, result:%s", task_id, asr_result);
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [self->StartButton setEnabled:YES];
            [self->StartButton setAlpha:1.0];
            [self->StopButton setEnabled:NO];
            [self->StopButton setAlpha:0.4];
            [self->QueryButton setEnabled:NO];
            [self->QueryButton setAlpha:0.4];
        });

        NSError *error;
        NSString *jsonString = [NSString stringWithUTF8String:asr_result];
        NSData *jsonData = [jsonString dataUsingEncoding:NSUTF8StringEncoding];
        NSDictionary *jsonObject = [NSJSONSerialization JSONObjectWithData:jsonData options:0 error:&error];
        NSDictionary *output = jsonObject[@"output"];
        if (!output || ![output isKindOfClass:[NSDictionary class]]) {
            [self showEventResult:@"缺少 'output' 字段"];
            return;
        }
        NSDictionary *task_metrics = output[@"task_metrics"];
        if (!task_metrics || ![task_metrics isKindOfClass:[NSDictionary class]]) {
            [self showEventResult:@"缺少 'task_metrics' 字段"];
            return;
        }
        
        NSError *serializeError;
        NSData *taskMetricsData = [NSJSONSerialization dataWithJSONObject:task_metrics options:0 error:&serializeError];
        NSString *task_metrics_str = nil;
        if (serializeError) {
            TLog(@"序列化 task_metrics 失败: %@", serializeError.localizedDescription);
            NSString *content = [NSString stringWithFormat:@"序列化 task_metrics 失败: %@", serializeError.localizedDescription];
            [self showEventResult:content];
        } else {
            task_metrics_str = [[NSString alloc] initWithData:taskMetricsData encoding:NSUTF8StringEncoding];
            NSString *content = [NSString stringWithFormat:@"识别完成！ \ntask_id:%s\n%@\n\n识别结果请关注transcription_url", task_id, task_metrics_str];
            [self showEventResult:content];
        }
    } else if (nuiEvent == EVENT_ASR_ERROR) {
        dispatch_async(dispatch_get_main_queue(), ^{
            // UI更新代码
            [self->StartButton setEnabled:YES];
            [self->StartButton setAlpha:1.0];
            [self->StopButton setEnabled:NO];
            [self->StopButton setAlpha:0.4];
            [self->QueryButton setEnabled:NO];
            [self->QueryButton setAlpha:0.4];
        });

        TLog(@"EVENT_ASR_ERROR error[%d]", code);
        NSString *result = [NSString stringWithUTF8String:asr_result];
        [self showEventResult:result];
    }
    
    return;
}

-(void)onFileTransLogTrackCallback:(NuiSdkLogLevel)level
                        logMessage:(const char *)log {
    TLog(@"onFileTransLogTrackCallback log level:%d, message -> %s", level, log);
}

#pragma mark - Private methods

-(void) showEventResult:(NSString *) result {
    dispatch_async(dispatch_get_main_queue(), ^{
        self->textViewEvent.text = result;
    });
}

-(NSString*) genInitParams {
    NSString *debug_path = [_utils createDir];
    
    NSMutableDictionary *ticketJsonDict = [NSMutableDictionary dictionary];
    // 若此处设置长效apikey, 则不需要每次nui_dialog_start都设置
    // 注意！不推荐在这里设置apikey。推荐每次在nui_dialog_start时设置临时鉴权token。
//    [ticketJsonDict setObject:_apikey forKey:@"apikey"];

    [ticketJsonDict setObject:@"https://dashscope.aliyuncs.com/api/v1/services/audio/asr/transcription" forKey:@"url"];

    [ticketJsonDict setObject:@"empty_device_id" forKey:@"device_id"]; // 必填, 推荐填入具有唯一性的id, 方便定位问题

    //debug目录。当初始化SDK时的save_log参数取值为true时，该目录用于保存中间音频文件
    [ticketJsonDict setObject:debug_path forKey:@"debug_path"];

    //过滤SDK内部日志通过回调送回到用户层
    [ticketJsonDict setObject:[NSString stringWithFormat:@"%d", NUI_LOG_LEVEL_NONE] forKey:@"log_track_level"];
    //设置本地存储日志文件的最大字节数, 最大将会在本地存储2个设置字节大小的日志文件
    [ticketJsonDict setObject:@(50 * 1024 * 1024) forKey:@"max_log_file_size"];

    //FullMix = 0   // 选用此模式开启本地功能并需要进行鉴权注册
    //FullCloud = 1 // 在线实时语音识别可以选这个
    //FullLocal = 2 // 选用此模式开启本地功能并需要进行鉴权注册
    //AsrMix = 3    // 选用此模式开启本地功能并需要进行鉴权注册
    //AsrCloud = 4  // 在线一句话识别可以选这个
    //AsrLocal = 5  // 选用此模式开启本地功能并需要进行鉴权注册
    [ticketJsonDict setObject:@"1" forKey:@"service_mode"]; // 必填，不可改

    NSData *data = [NSJSONSerialization dataWithJSONObject:ticketJsonDict options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}
-(NSString*) genParams {
    NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];
    NSMutableDictionary *dictM = [NSMutableDictionary dictionary];
    [dictM setObject:nls_config forKey:@"nls_config"];
    NSData *data = [NSJSONSerialization dataWithJSONObject:dictM options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    return jsonStr;
}

-(NSString*) genStartParams {
    /**
     * 参数详见
     * 接口说明：
     *
     * 移动端SDK说明：
     *
     */

    NSMutableDictionary *dialog_params = [NSMutableDictionary dictionary];

    // 注意！！！不要在端侧使用长效API Key！！！
    // 注意！！！不要在端侧使用长效API Key！！！
    // 注意！！！不要在端侧使用长效API Key！！！
    // 将长效API Key硬编码在端侧代码中，会导致安全风险！！！
    // 请在自建服务端获得临时鉴权Token（有效期60s，最长可设置1800s），再下发到端侧进行使用。
    // 临时鉴权Token: https://help.aliyun.com/zh/model-studio/obtain-temporary-authentication-token
    //
    // 服务只需要在临时Token(API Key)快过期前刷新一次。各端侧在Token(API Key)快过期前从服务获得新的
    // 临时Token(API Key)。
    [dialog_params setValue:_apikey forKey:@"apikey"];

    // 音视频文件转写的URL列表，支持HTTP / HTTPS协议，单次请求最多支持100个URL。
    NSString *content = textViewContent.text;
    NSArray *lines = [content componentsSeparatedByString:@"\n"];
    NSMutableArray *urls = [NSMutableArray array];
    for (NSString *line in lines) {
        NSString *trimmed = [line stringByTrimmingCharactersInSet:[NSCharacterSet whitespaceAndNewlineCharacterSet]];
        if (trimmed.length > 0) {
            [urls addObject:trimmed];
        }
    }
    if (urls.count > 0) {
        [dialog_params setValue:urls forKey:@"file_urls"];
    } else {
        [self showEventResult:@"请输入音频链接"];
        return @"";
    }

    [dialog_params setObject:switchSync.on ? @YES : @NO forKey:@"async_request"];

    NSMutableDictionary *nls_config = [NSMutableDictionary dictionary];
    // 模型选择, 注意模型对应的采样率要求。
    [nls_config setValue:_modelHW.title forKey:@"model"];

    // 设置热词ID，若未设置则不生效。v2及更高版本模型设置热词ID时使用该字段。
    // 在本次语音识别中，将应用与该热词ID对应的热词信息。
//    [nls_config setObject:@"1234567890" forKey:@"vocabulary_id"];

    // 热词ID，此次语音识别中生效此热词ID对应的热词信息。默认不启用。
//    NSMutableArray *resources = [NSMutableArray array];
//    NSMutableDictionary *resource = [NSMutableDictionary dictionary];
//    resource[@"resource_id"] = @"111";
//    resource[@"resource_type"] = @"asr_phrase";
//    [resources addObject:resource];
//    NSData *jsonData = [NSJSONSerialization dataWithJSONObject:resources options:0 error:&error];
//    if (!error) {
//        NSString *resourcesString = [[NSString alloc] initWithData:jsonData encoding:NSUTF8StringEncoding];
//        [nls_config setObject:resourcesString forKey:@"resources"];
//    }

    // 指定在多音轨文件中需要进行语音识别的音轨索引，以List的形式给出，
    // 例如[0]表示仅识别第一条音轨，[0, 1]表示同时识别前两条音轨。
//    [nls_config setObject:@[@0] forKey:@"channel_id"];

    // 过滤语气词，默认关闭。
//    [nls_config setObject:@YES forKey:@"disfluency_removal_enabled"];

    // 是否启用时间戳校准功能，默认关闭。
//    [nls_config setObject:@YES forKey:@"timestamp_alignment_enabled"];

    // 指定在语音识别过程中需要处理的敏感词，并支持对不同敏感词设置不同的处理方式。
    // 若未传入该参数，系统将启用系统内置的敏感词过滤逻辑
//    NSMutableDictionary *special_word_filter = [NSMutableDictionary dictionary];
//    NSMutableDictionary *filter_with_signed = [NSMutableDictionary dictionary];
//    NSMutableArray *filter_with_signed_array = [NSMutableArray array];
//    [filter_with_signed_array addObject:@"测试"];
//    [filter_with_signed setObject:filter_with_signed_array forKey:@"word_list"];
//    [special_word_filter setObject:filter_with_signed forKey:@"filter_with_signed"];
//    NSMutableDictionary *filter_with_empty = [NSMutableDictionary dictionary];
//    NSMutableArray *filter_with_empty_array = [NSMutableArray array];
//    [filter_with_empty_array addObject:@"开始"];
//    [filter_with_empty_array addObject:@"发送"];
//    [filter_with_empty setObject:filter_with_empty_array forKey:@"word_list"];
//    [special_word_filter setObject:filter_with_empty forKey:@"filter_with_empty"];
//    [special_word_filter setObject:@YES forKey:@"system_reserved_filter"];
//    [nls_config setObject:special_word_filter forKey:@"special_word_filter"];

    // 设置待识别语言代码。如果无法提前确定语种，可不设置，模型会自动识别语种。
//    [nls_config setObject:@[@"zh", @"en"] forKey:@"language_hints"];
    
    // 自动说话人分离，默认关闭。
    // 仅适用于单声道音频，多声道音频不支持说话人分离。
    // 启用该功能后，识别结果中将显示speaker_id字段，用于区分不同说话人。
//    [nls_config setObject:@YES forKey:@"diarization_enabled"];

    // 说话人数量参考值。取值范围为2至100的整数（包含2和100）。
    // 开启说话人分离功能后（diarization_enabled设置为true）生效。
    // 默认自动判断说话人数量，如果配置此项，只能辅助算法尽量输出指定人数，无法保证一定会输出此人数。
//    [nls_config setObject:@(2) forKey:@"speaker_count"];

    /*若文档中不包含某些参数，但是录音文件极速转写功能支持这个参数，可以用如下万能接口设置参数*/
//    NSMutableDictionary *extend_config = [NSMutableDictionary dictionary];
//    [extend_config setValue:@YES forKey:@"custom_test"];
//    [nls_config setObject:extend_config forKey:@"extend_config"];
    
    [dialog_params setObject:nls_config forKey:@"nls_config"];
    
    NSData *data = [NSJSONSerialization dataWithJSONObject:dialog_params options:NSJSONWritingPrettyPrinted error:nil];
    NSString * jsonStr = [[NSString alloc]initWithData:data encoding:NSUTF8StringEncoding];
    NSLog(@"start params %@", jsonStr);
    return jsonStr;
}


- (void) initNui {
    if (_nui == NULL) {
        _nui = [NeoNui get_instance];
        _nui.delegate = self;
    }
    //请注意此处的参数配置，其中账号相关需要按照genInitParams的说明填入后才可访问服务
    NSString * initParam = [self genInitParams];

    [_nui nui_initialize:[initParam UTF8String] logLevel:NUI_LOG_LEVEL_VERBOSE saveLog:@(YES)];
    NSString * parameters = [self genParams];
    [_nui nui_set_params:[parameters UTF8String]];
}



#pragma mark - View
-(CGFloat)InitButtonView:(CGFloat)border startY:(CGFloat)startY {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    
    //Start Button
    CGFloat button_width = global_size.width/SCREEN_WIDTH_BASE * 70;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    
    CGFloat start_x = border;
    CGFloat start_y = startY;
    
    StartButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StartButton.frame = CGRectMake(start_x, start_y, button_width, button_height);
    UIImage *image = [UIImage imageNamed:@"button_start"];
    [StartButton setBackgroundImage:image forState:UIControlStateNormal];
    [StartButton setTitle:@"开始" forState:UIControlStateNormal];
    [StartButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StartButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StartButton addTarget:self action:@selector(StartButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StartButton];
    
    [StartButton setEnabled:YES];
    [StartButton setAlpha:1.0];
    
    //Query Button
    CGFloat query_x = global_size.width / 2 - button_width / 2;
    CGFloat query_y = startY;

    QueryButton = [UIButton buttonWithType:UIButtonTypeCustom];
    QueryButton.frame = CGRectMake(query_x, query_y, button_width, button_height);
    image = [UIImage imageNamed:@"button_start"];
    [QueryButton setBackgroundImage:image forState:UIControlStateNormal];
    [QueryButton setTitle:@"查询结果" forState:UIControlStateNormal];
    [QueryButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    QueryButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [QueryButton addTarget:self action:@selector(QueryButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:QueryButton];
    
    [QueryButton setEnabled:NO];
    [QueryButton setAlpha:0.4];
    
    //Stop Button
    CGFloat stop_x = global_size.width - border - button_width;
    CGFloat stop_y = startY;
    
    StopButton = [UIButton buttonWithType:UIButtonTypeCustom];
    StopButton.frame = CGRectMake(stop_x, stop_y, button_width, button_height);
    image = [UIImage imageNamed:@"button_start"];
    [StopButton setBackgroundImage:image forState:UIControlStateNormal];
    [StopButton setTitle:@"结束" forState:UIControlStateNormal];
    [StopButton setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    StopButton.titleLabel.font = [UIFont systemFontOfSize:18];
    [StopButton addTarget:self action:@selector(StopButHandler:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:StopButton];
    
    [StopButton setEnabled:NO];
    [StopButton setAlpha:0.4];
    
    return stop_y + button_height;
}

-(CGFloat)InitSwitchView:(CGFloat)border startY:(CGFloat)startY {
    CGSize global_size = [UIScreen mainScreen].bounds.size;

    CGFloat label_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat label_height = global_size.height/SCREEN_HEIGHT_BASE * 30;
    CGFloat switch_width = global_size.width/SCREEN_WIDTH_BASE * 80;
    CGFloat switch_height = global_size.height/SCREEN_HEIGHT_BASE * 30;

    CGFloat interval_width = global_size.width/SCREEN_WIDTH_BASE * 10;
    CGFloat interval_height = global_size.height/SCREEN_HEIGHT_BASE * 10;
    
    CGFloat start_x = border;
    CGFloat start_y = startY;
    
    //sync mode label
    CGFloat sync_label_width = global_size.width/SCREEN_WIDTH_BASE * 200;
    CGFloat sync_label_x = start_x;
    CGFloat sync_label_y = start_y;

    CGRect sync_label_rect = CGRectMake(sync_label_x, sync_label_y, sync_label_width, label_height);
    if (!SyncLabel) {
        SyncLabel = [[UILabel alloc] initWithFrame:sync_label_rect];
    }
    SyncLabel.text = @"同步请求，直到返回结果";
    SyncLabel.textColor = UIColor.blackColor;
    SyncLabel.backgroundColor = UIColor.whiteColor;
    SyncLabel.layer.cornerRadius = 5.0;
    SyncLabel.layer.masksToBounds = true;
    [self.view addSubview:SyncLabel];

    //sync mode switch
    CGFloat sync_switch_x = sync_label_x + sync_label_width + interval_width;
    CGFloat sync_switch_y = start_y;

    CGRect sync_switch_rect = CGRectMake(sync_switch_x, sync_switch_y, switch_width, switch_height);
    switchSync = [[UISwitch alloc] initWithFrame:sync_switch_rect];
    [switchSync setOn:NO animated:NO];
    [switchSync addTarget:self action:@selector(switchSyncAction:) forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:switchSync];
    
    return sync_switch_y + switch_height;
}

-(CGFloat)InitHWOptionsView:(CGFloat)border startY:(CGFloat)startY {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    
    CGFloat modelHW_width = global_size.width/SCREEN_WIDTH_BASE * 220;
    CGFloat modelHW_height = global_size.height/SCREEN_HEIGHT_BASE * 32;
    CGFloat modelHW_x = border;
    CGFloat modelHW_y = startY;
    HWOptionButton *modelHW = [[HWOptionButton alloc] initWithFrame:CGRectMake(modelHW_x, modelHW_y, modelHW_width, modelHW_height)];
    modelHW.backgroundColor = [UIColor lightGrayColor];
    modelHW.array = @[@"paraformer-v2", @"paraformer-v1", @"paraformer-8k-v2", @"paraformer-8k-v1", @"paraformer-mtl-v1"];
    modelHW.selectIndex = 0;
    modelHW.showPlaceholder = NO;
    modelHW.dropdownTitle = @" - 模型名称 - ";
    modelHW.delegate = self;
    [self.view addSubview:modelHW];
    self.modelHW = modelHW;

    return modelHW_y + modelHW_height;
}

-(CGFloat)InitTextView:(CGFloat)border startY:(CGFloat)startY {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    //content label
    CGFloat content_label_width = global_size.width - border * 2;
    CGFloat content_label_height = global_size.height/SCREEN_HEIGHT_BASE * 32;
    CGFloat content_label_x = border;
    CGFloat content_label_y = startY;

    CGRect content_label_rect = CGRectMake(content_label_x, content_label_y, content_label_width, content_label_height);
    if (!ContenLabel) {
        ContenLabel = [[UILabel alloc] initWithFrame:content_label_rect];
    }
    ContenLabel.text = @"音频链接：";
    ContenLabel.textColor = UIColor.blackColor;
    ContenLabel.backgroundColor = UIColor.whiteColor;
    ContenLabel.layer.cornerRadius = 5.0;
    ContenLabel.layer.masksToBounds = true;
    [self.view addSubview:ContenLabel];
    
    //content text
    CGFloat content_view_width = global_size.width - border * 2;
    CGFloat content_view_height = global_size.height/SCREEN_HEIGHT_BASE * 160;
    CGFloat content_x = border;
    CGFloat content_y = content_label_y + content_label_height + border;
    
    CGRect content_rect = CGRectMake(content_x, content_y, content_view_width, content_view_height);
    if (!textViewContent) {
        textViewContent = [[UITextView alloc] initWithFrame:content_rect];
    }
    textViewContent.layer.borderWidth = 0.6;
    textViewContent.layer.borderColor = [UIColor blackColor].CGColor;
    textViewContent.layer.cornerRadius = 10;
    [textViewContent setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewContent.scrollEnabled = YES;
    
    NSString *content = [NSString stringWithFormat:@"%@\n%@\n%@", default_wav_address, default_mp3_address, default_mp4_address];
    textViewContent.text = content;
    textViewContent.textColor = [UIColor darkGrayColor];
    textViewContent.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewContent];

    textViewContent.scrollEnabled = YES;
    textViewContent.editable = YES;
    
    //event text view
    CGFloat event_view_width = global_size.width - border * 2;
    CGFloat event_view_height = global_size.height/SCREEN_HEIGHT_BASE * 200;
    CGFloat event_x = border;
    CGFloat event_y = content_y + content_view_height + border;
    
    CGRect event_rect = CGRectMake(event_x, event_y, event_view_width, event_view_height);
    if (!textViewEvent) {
        textViewEvent = [[UITextView alloc] initWithFrame:event_rect];
    }
    textViewEvent.layer.borderWidth = 0.6;
    textViewEvent.layer.borderColor = [UIColor blackColor].CGColor;
    textViewEvent.layer.cornerRadius = 10;
    [textViewEvent setBackgroundColor: [UIColor colorWithRed:0/255.0f green:0/255.0f blue:0/255.0f alpha:0.1]];
    textViewEvent.scrollEnabled = YES;
    
    textViewEvent.text = @"服务不支持本地音视频文件直传（也不支持base64格式音频），输入源需为可通过公网访问的文件URL（支持HTTP/HTTPS协议，示例：https://your-domain.com/file.mp3）。\n\n此处演示同时识别多个录音文件。\n\n多个url请用回车符分割。";
    textViewEvent.textColor = [UIColor darkGrayColor];
    textViewEvent.font = [UIFont systemFontOfSize:10];
    [self.view addSubview:textViewEvent];

    textViewEvent.scrollEnabled = YES;
    textViewEvent.editable = NO;

    return event_y + event_view_height;
}

-(void)InitView {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    self.view.backgroundColor = [UIColor whiteColor];
    self.navigationItem.title = @"Paraformer文件转写";
    CGFloat border = global_size.width/SCREEN_WIDTH_BASE * 13;
    CGFloat division = global_size.height/SCREEN_HEIGHT_BASE * 10;
    CGFloat end_y = 0;
    
    CGFloat button_border = global_size.width/SCREEN_WIDTH_BASE * 27.5;
    CGFloat button_start_y = global_size.height/SCREEN_HEIGHT_BASE * 70;
    end_y = [self InitButtonView:button_border startY:button_start_y];
    
    CGFloat switch_start_y = end_y + division;
    end_y = [self InitSwitchView:border startY:switch_start_y];

    CGFloat hwoptions_start_y = end_y + division;
    end_y = [self InitHWOptionsView:border startY:hwoptions_start_y];
    
    CGFloat view_start_y = end_y;
    end_y = [self InitTextView:border startY:view_start_y];
}


@end
