#import "DashNlsRootTableViewController.h"
#import "WakeupAndFunAsrViewController.h"
#import "NuiCfg.h"

@interface DashNlsRootTableViewController () {
    IBOutlet UIButton *ASRButtion;
}

@end

@implementation DashNlsRootTableViewController
#define SCREEN_WIDTH_BASE 375
#define SCREEN_HEIGHT_BASE 667

-(void) setupButton:(UIButton*)button
                    index:(int)index
                    title:(NSString*)title
                    action:(SEL)action {
    CGSize global_size = [UIScreen mainScreen].bounds.size;
    CGFloat button_width = global_size.width;
    CGFloat button_height = global_size.height/SCREEN_HEIGHT_BASE * 40;
    
    
    CGFloat button_x = 0;
    CGFloat button_y = global_size.height/SCREEN_HEIGHT_BASE * 40 * index;

    button = [UIButton buttonWithType:UIButtonTypeCustom];
    button.frame = CGRectMake(button_x, button_y, button_width, button_height);
    UIImage *button_image = [UIImage imageNamed:@"button_start"];
    [button setBackgroundImage:button_image forState:UIControlStateNormal];
    [button setTitle:title forState:UIControlStateNormal];
    [button setTitleColor:UIColor.blackColor forState:UIControlStateNormal];
    button.titleLabel.font = [UIFont systemFontOfSize:18];
    [button addTarget:self action:action forControlEvents:UIControlEventTouchUpInside];
    [self.view addSubview:button];
}

-(void) viewDidLoad {
    [super viewDidLoad];
    NSLog(@"tableView enter self.navigationController %@", self.navigationController);
    
    int idx = 2;

#ifdef SDK_NUI
    [self setupButton:ASRButtion index:idx++ title:@"唤醒并Fun-ASR识别(离线功能-部分版本支持)" action:@selector(startWakeupAndFunAsr:)];
#endif

}

- (IBAction)startWakeupAndFunAsr:(UIButton *)sender {
#ifdef SDK_NUI
    UIViewController * controller = nil;
    controller = [[WakeupAndFunAsrViewController alloc] init];
    [self.navigationController pushViewController:controller animated:YES];
#endif
}

@end
