# 使用

完成部署后，如何将 AgentScope Runtime 暴露给终端用户、业务系统或调试工具，是智能体落地的最后一步。本章将概述常见的调用方式，并衔接后续子章节（Call API、Web UI、Tracing、Protocol、DemoHouse、测试用例），帮助你选择合适的接入路径与配套工具。

## 使用形态概览

Runtime 支持多种消费方式，满足不同角色需求：

1. **Call API**：面向后端系统的 HTTP/gRPC 调用接口，适合与业务服务集成。
2. **Web UI**：提供可视化的聊天或控制面板，方便运营、体验与调试。
3. **Tracing/Protocol**：供开发者排查问题、还原上下文与协议细节。
4. **DemoHouse/UT**：展示和验证场景，帮助团队快速评估。


## 准备工作

- 确认已启动的 `Agent App` 以及服务所暴露的端口、鉴权策略。
- 配置必要的 API Key、或自定义认证模块，确保外部访问安全。
- 规划可 observability 的组件（Tracing、日志、Metrics），以便在调用链路中排查问题。
- 准备示例请求、环境变量和脚本，便于团队复制使用。

## 子章节导读

### API 调用

介绍如何通过 REST/gRPC 等接口与智能体交互，包括：

- 标准请求/响应格式与状态码说明。
- 流式输出、工具调用回调等进阶功能。
- 鉴权、限流与幂等性实践。

适合希望与业务系统或自动化任务集成的开发者。
更多细节参考 {doc}`call`。

### Web UI

展示如何快速搭建 Web 前端以与智能体对话或监控状态，内容包含：

- WebSocket/HTTP 长连接的配置方法。
- 聊天记录、工具调用可视化以及调试面板。
- 与部署环境（Nginx、反向代理、单点登录）的集成方案。

完整指引见 {doc}`webui`。

### Tracing

聚焦可观测性：如何记录每一步调用、工具执行和上下文切换。你将了解：

- 如何开启 Runtime 内置的 trace pipeline。
- 与外部系统（如 Jaeger、OpenTelemetry、APM）的对接方式。
- 通过 trace 分析性能瓶颈或工具失败原因。

实现细节详见 {doc}`tracing`。

### Protocol

详细描述 Runtime 与 Agent、工具之间的消息协议，适合需要深度定制或调试底层交互的开发者。章节将说明：

- 会话结构、轮次信息与内容序列化格式。
- 工具调用、事件推送等扩展约定。
- 如何在多语言环境中实现兼容的客户端。

标准定义参见 {doc}`protocol`。

### DemoHouse

提供一组可运行的示例应用/场景，便于团队演示、培训或快速验证部署效果。内容包括：

- 典型业务场景的配置文件及运行方式。
- 如何在 DemoHouse 中自定义角色、插件与前端展示。

更多示例见 {doc}`demohouse`。

### A2A Registry - 服务注册与发现

介绍 A2A（Agent-to-Agent）协议的服务注册与发现机制。章节涵盖：

- AgentApp 扩展字段 a2a_config
- Registry 架构
- Registry 配置方式
- Nacos Registry 使用指南
- 自定义 Registry 的实现方法

适合需要将智能体服务注册到中心化的智能体注册中心（如 Nacos）的开发者。完整文档见 {doc}`a2a_registry`。

### 测试用例

介绍本仓库中的测试样例。章节覆盖：

- 单元测试
- 集成测试

操作指南参见 {doc}`ut`。

## 推荐路径

1. 先根据目标受众选择调用形态（API 或 Web UI）。
2. 在集成过程中开启 Tracing/Protocol 以便快速诊断。
3. 利用 DemoHouse 和单元测试验证关键流程与回归场景。
4. 将常用调用示例和脚本整理进团队文档，方便复用。

通过上述步骤，你可以让部署好的智能体顺利融入业务生态，并在遇到问题时具备清晰的定位与排障手段。