# 沙箱与工具

在 AgentScope Runtime 中，工具是智能体落地业务能力的关键组成部分。无论是直接调用模型服务、执行浏览器自动化，还是集成企业内部 API，工具体系需要安全、可控、易于扩展。本章将给出整体思路，并串联后续子章节（即用型工具、沙箱基础/进阶、训练沙箱、沙箱故障排查），帮助你根据场景选择合适的路径。

## 工具接入模式

Runtime 支持两种种常见方式接入工具：

1. **即用型工具**：由服务商或 Runtime 直接提供，如 RAG 检索等，零部署即可调用。
2. **沙箱工具**：通过 Browser/FileSystem 等沙箱环境，以受控方式运行。


## 子章节导读

### 即用型工具

展示如何在 Runtime 中直接使用的工具集合，包括检索增强、网络搜索、支付等能力。适合希望快速复用阿里云生态的场景，章节提供配置示例和最佳实践。

更多案例见 {doc}`tools/tools`。

### 沙箱

介绍工具沙箱的概念、生命周期与常见类型（浏览器、文件系统、Python 执行等）。你将学习如何：

- 通过 `Sandbox` SDK 创建、连接、释放沙箱。
- 在多会话场景下复用与隔离资源。

操作细节见 {doc}`sandbox/sandbox`。

#### 沙箱进阶

深入探讨多后端、远程沙箱服务等高级特性。适合需要大规模稳定运行或满足企业安全要求的团队，内容包括：

- 更多沙箱设置。
- Kubernetes、远程容器集群的集成方式。
- 自定义沙箱类型的扩展接口。

完整指南参见 {doc}``sandbox/advanced`。

#### 训练沙箱

聚焦于用于评测、训练或自博弈场景的特殊沙箱能力：

更多内容参考 {doc}``sandbox/training_sandbox`。

#### 沙箱故障排查

提供常见问题的定位与修复建议，如沙箱无法启动、工具超时、权限不足等，并给出检查清单（日志、健康检查、资源占用）与常见错误码说明。

排障步骤详见 {doc}`sandbox/troubleshooting`。

## 推荐路径

1. 从即用型工具出发，确定需要的调用方式。
2. 根据副作用与安全需求，选择是否启用沙箱及其级别。
3. 参照进阶章节完成批量验证与生产化部署。
4. 遇到稳定性问题时，快速查阅故障排查章节定位根因。

通过以上步骤，可构建既安全可靠又具备高扩展性的工具体系，让智能体具备持续演化的能力。
