# 部署

本章节聚焦于如何在 AgentScope Runtime 上部署智能体。在完成概念与快速上手之后，部署是让实验性原型进入稳定运行的关键一步。我们将首先给出部署思路与整体流程，然后串联后续的服务、简单部署、进阶部署以及 React Agent样例 子章节，帮助你快速定位适合的路径。

## 为什么需要部署

- **连接真实业务场景**：将智能体从 Notebook 或本地脚本迁移到可持续运行的环境，才能接入真实用户、工具与数据。
- **获得稳定的运维能力**：Runtime 提供标准化的服务生命周期、健康检查与扩展能力，简化监控与回滚。
- **复用生态能力**：通过统一的部署方式，可以复用记忆、沙箱、状态等基础服务，避免重复造轮子。

## 部署路径概览

部署过程通常包含以下几个阶段：

1. **准备工作**：安装 Runtime、准备模型与工具、配置环境变量与凭证。
2. **基础服务启动**：根据业务需要选择记忆、会话、沙箱等服务实现。
3. **Agent App 定义**：基于 `AgentApp` 模块编排智能体、工具与工作流逻辑，形成可部署的应用入口。
4. **运行与监控**：在本地、容器或云原生环境中启动 Runtime，利用健康探针、日志与 tracing 追踪执行。
5. **升级与扩展**：使用高级部署与 React Agent 能力实现多区域部署、混合编排或 UI 交互。

## 前置准备清单

- Python 环境（建议 3.10+）及必要依赖。
- 至少一个可用的大模型接入（例如 DashScope、OpenAI 或自建推理服务）。
- 目标部署平台（本地、Docker、Kubernetes 等）的访问与权限。
- 对应的工具/沙箱权限，如浏览器自动化、文件系统或自定义工具服务。
- （可选）如果在访问默认 PyPI 受限或速度较慢的区域（如中国或企业网络）部署，可配置自定义 PyPI 镜像源 URL，这可以显著加速 Docker 镜像构建。

## 子章节导读

### 服务

`Service` 章节介绍了 Runtime 内建的会话历史、记忆、沙箱、状态等基础服务，以及统一的生命周期接口。阅读该章节可以了解如何选择合适的实现（内存、Redis、Tablestore 等），以及如何通过 `start()`、`stop()`、`health()` 管理服务，确保部署环境具备稳定的支撑能力。
详细文档见 {doc}`service/service`。

### 简单部署

Runtime包含一个简单的部署工具`agent_app` 。它是将多个智能体、工具与上下文串联的应用形态。子章节会说明：

- 如何定义 `AgentApp` 配置、路由和会话管理。
- 如何在部署阶段绑定服务、注入沙箱，并暴露 HTTP/gRPC/CLI 等接口。
- 如何编写自定义 handler 与插件，满足不同业务流。

在实际部署中，Agent App 通常作为主要入口进程，与基础服务共同组成运行时。
完整示例可参考 {doc}`agent_app`。

### 高级部署

当需要满足更高的可用性与可观测性要求时，可参考高级部署章节，内容包括：

- 使用容器编排（如 Docker Compose、Kubernetes）运行多服务拓扑。
- 配置多地区/多模型冗余、灰度发布与扩缩策略。
- 接入集中式日志、Tracing、监控告警系统。

该章节适合有生产场景或需要多团队协作的读者。
更多方案见 {doc}`advanced_deployment`。

### 参考: 完整部署样例

完整部署样例章节介绍了一个完整包含沙箱服务的Agent部署的例子，内容包括：

- 引入浏览器沙箱
- 构建AgentApp
- 服务启动

如果想完整回顾部署的所有环节，该章节是重要参考。
请参考 {doc}`react_agent` 获取具体步骤。

## 下一步

阅读本章节后，可按照以下顺序深入：

1. 进入 `服务` 章节，确认需要的基础设施与实现。
2. 在 `简答部署` 中完成业务逻辑编排与本地验证。
3. 根据规模需求选择 `高级部署` 指南，完成生产化配置。
4. 若需要 Web 交互层，继续阅读 `完整部署样例` 章节并完成前端部署。

通过上述步骤，你可以渐进式地把智能体从实验环境部署到可观测、可维护、可扩展的生产系统。