# Sandbox 模块

Sandbox模块提供了隔离环境以安全地运行代码。

## 公共接口

用户通常直接从`agentscope_runtime.sandbox`包导入的主要类：

### BaseSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.BaseSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### BrowserSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.BrowserSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### FilesystemSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.FilesystemSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### GuiSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.GuiSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### MobileSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.MobileSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### TrainingSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.TrainingSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### CloudSandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.CloudSandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

### AgentbaySandbox
```{eval-rst}
.. autoclass:: agentscope_runtime.sandbox.AgentbaySandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

## 自定义与示例
```{eval-rst}
.. automodule:: agentscope_runtime.sandbox.custom.custom_sandbox
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.custom.example
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

## 管理端
```{eval-rst}
.. automodule:: agentscope_runtime.sandbox.manager.sandbox_manager
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.server.app
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.server.config
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.server.models
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.storage.data_storage
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.storage.local_storage
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.manager.storage.oss_storage
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

## 客户端
```{eval-rst}
.. automodule:: agentscope_runtime.sandbox.client.http_client
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.client.training_client
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

## 模型与注册
```{eval-rst}
.. automodule:: agentscope_runtime.sandbox.model.api
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.model.container
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.model.manager_config
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.registry
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```

## 构建与工具
```{eval-rst}
.. automodule:: agentscope_runtime.sandbox.build
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.utils
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.constant
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.enums
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:

.. automodule:: agentscope_runtime.sandbox.mcp_server
   :members:
   :undoc-members:
   :show-inheritance:
   :no-index:
```