/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.analyticdb.adb4pgclient;

import com.alibaba.cloud.analyticdb.adb4pgclient.DatabaseConfig;
import com.alibaba.druid.pool.DruidDataSource;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.postgresql.Driver;

public final class ClientDataSource {
    private static ClientDataSource instance = new ClientDataSource();
    private Map<String, DruidDataSource> dataSourceMap = new ConcurrentHashMap<String, DruidDataSource>();

    private ClientDataSource() {
    }

    public static ClientDataSource getInstance() {
        return instance;
    }

    public synchronized DruidDataSource getDataSource(DatabaseConfig databaseConfig) {
        if (this.dataSourceMap.get(databaseConfig.getDatabase()) != null) {
            return this.dataSourceMap.get(databaseConfig.getDatabase());
        }
        DruidDataSource dataSource = this.newDataSource(databaseConfig);
        this.dataSourceMap.put(databaseConfig.getDatabase(), dataSource);
        return dataSource;
    }

    public DruidDataSource newDataSource(DatabaseConfig databaseConfig) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setDriverClassName(Driver.class.getName());
        dataSource.setUsername(databaseConfig.getUser());
        dataSource.setPassword(databaseConfig.getPassword());
        dataSource.setUrl("jdbc:postgresql://" + databaseConfig.getHost() + ":" + databaseConfig.getPort() + "/" + databaseConfig.getDatabase());
        dataSource.setInitialSize(1);
        dataSource.setMinIdle(1);
        dataSource.setMaxActive(128);
        dataSource.setPoolPreparedStatements(false);
        dataSource.setValidationQuery("select 'x'");
        dataSource.setValidationQueryTimeout(1000);
        dataSource.setTimeBetweenEvictionRunsMillis(60000L);
        dataSource.setTestWhileIdle(true);
        dataSource.setTestOnBorrow(false);
        dataSource.setTestOnReturn(false);
        dataSource.setKeepAlive(true);
        dataSource.setPhyMaxUseCount(100000L);
        return dataSource;
    }
}

