/*
 * 测试demo入口
 */

package mit.alibaba.nuidemo;

import android.app.Activity;
import android.content.Intent;
import android.os.Bundle;
import android.util.Log;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.ListView;
import android.widget.SimpleAdapter;
import android.widget.Spinner;
import android.widget.TextView;
import android.widget.Toast;

import androidx.core.content.ContextCompat;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.idst.nui.Constants;
import com.alibaba.idst.nui.NativeNui;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;


public class CompoundMainActivity extends Activity implements AdapterView.OnItemClickListener {
    private static final String TAG = "CompoundMain";

    private final NativeNui nui_utils_instance = new NativeNui(Constants.ModeType.MODE_UTILS);
    private final String app_code = nui_utils_instance.getAppCode();

    // 推荐终端用户使用就近地域接入域名
    private final String[] url_array = {
            "wss://dashscope.aliyuncs.com/api-ws/v1/inference",
    };
    private static Integer url_select = 0;
    private static String url = "";

    // 注意！百炼账号apikey不要存储在端侧，仅为方便Demo运行展示
    private static String apikey = "";
    // 注意！阿里云账号appkey、accessKey、accessKeySecret均不要存储在端侧
    // 此处仅为方便Demo运行展示
    private static Integer access_select = 0;
    private static String appkey = "";
    private static String accessKey = "";
    private static String accessKeySecret = "";
    // 只有使用离线功能才需要填写
    // 精品版为 software_nls_tts_offline， 标准版为 software_nls_tts_offline_standard
    private final static String defaultSdkCode = "只有使用离线功能才需要填写";
    private static String sdkCode = defaultSdkCode;
    private static String stsToken = "";
    private final String[] access_array = {
            "Appkey+AK+SK+APIKEY",
            "Appkey+STS_AK+STS_SK+STS_Token+APIKEY",
    };

    // 注意！为方便Demo运行展示，用户设置的账号信息会存储到app的cache目录中的文件中，请注意账号安全
    private static String accessFilePath = "";

    private EditText appkeyText;
    private EditText stsTokenText;
    private EditText akText;
    private EditText skText;
    private EditText sdkCodeText;
    private EditText apikeyText;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.activity_compound_main);
        ListView listView = (ListView) findViewById(R.id.activity_list);
        ArrayList<HashMap<String, Object>> listItems = new ArrayList<HashMap<String, Object>>();
        HashMap<String, Object> item = new HashMap<String, Object>();
        TextView versionView = (TextView)findViewById(R.id.versionView);

        final String demoVersion = "Demo Version: " + getGitRevision();
        Log.i(TAG, demoVersion);

        Log.i(TAG, "Current APP Code:" + app_code);

        Toast.makeText(
                CompoundMainActivity.this,
                "注意! 实际产品请不要在端侧保存任何账号相关的信息！",
                Toast.LENGTH_SHORT).show();

        String debug_path = getExternalCacheDir().getAbsolutePath();
        Utils.createDir(debug_path);
        parseAccessFromFile(debug_path, ".nui_access");

        TextView serverView = (TextView)findViewById(R.id.textView2);
        serverView.setText("\n服务地址：");

        Spinner urlSelectSpinner = (Spinner) findViewById(R.id.spinner);
        ArrayAdapter<String> arrayAdapter = new ArrayAdapter<>(this,
                android.R.layout.simple_spinner_item, url_array);
        arrayAdapter.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        urlSelectSpinner.setAdapter(arrayAdapter);
        urlSelectSpinner.setBackgroundColor(ContextCompat.getColor(this, android.R.color.holo_blue_light));
        urlSelectSpinner.setSelection(url_select);
        urlSelectSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                url = parent.getItemAtPosition(position).toString();
                url_select = position;
            }
            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // Do nothing
            }
        });

        TextView appkeyView = (TextView)findViewById(R.id.textView5);
        appkeyView.setText("AppKey：");
        appkeyView.setVisibility(View.VISIBLE);
        appkeyText = (EditText)findViewById(R.id.editView);
        appkeyText.setText(appkey);
        appkeyText.setVisibility(View.VISIBLE);

        TextView stsTokenView = (TextView)findViewById(R.id.textView3);
        stsTokenView.setText("STS_Token：");
        stsTokenView.setVisibility(View.VISIBLE);
        stsTokenText = (EditText)findViewById(R.id.editView5);
        stsTokenText.setText(stsToken);
        stsTokenText.setVisibility(View.VISIBLE);

        TextView akView = (TextView)findViewById(R.id.textView6);
        akView.setText("AccessKey：");
        akView.setVisibility(View.VISIBLE);
        akText = (EditText)findViewById(R.id.editView2);
        akText.setText(accessKey);
        akText.setVisibility(View.VISIBLE);

        TextView skView = (TextView)findViewById(R.id.textView7);
        skView.setText("AccessKeySecret：");
        skView.setVisibility(View.VISIBLE);
        skText = (EditText)findViewById(R.id.editView3);
        skText.setText(accessKeySecret);
        skText.setVisibility(View.VISIBLE);

        TextView sdkCodeView = (TextView)findViewById(R.id.textView9);
        sdkCodeView.setText("SDK_CODE：");
        sdkCodeView.setVisibility(View.VISIBLE);
        sdkCodeText = (EditText)findViewById(R.id.editView6);
        sdkCodeText.setText(sdkCode);
        sdkCodeText.setVisibility(View.VISIBLE);

        TextView apikeyView = (TextView)findViewById(R.id.textView24);
        apikeyView.setText("API_KEY：");
        apikeyView.setVisibility(View.VISIBLE);
        apikeyText = (EditText)findViewById(R.id.editView9);
        apikeyText.setText(apikey);
        apikeyText.setVisibility(View.VISIBLE);

        TextView accessView = (TextView)findViewById(R.id.textView4);
        accessView.setText("账号方式：");

        Spinner accessSelectSpinner = (Spinner) findViewById(R.id.spinner2);
        ArrayAdapter<String> arrayAdapter2 = new ArrayAdapter<>(this,
                android.R.layout.simple_spinner_item, access_array);
        arrayAdapter2.setDropDownViewResource(android.R.layout.simple_spinner_dropdown_item);
        accessSelectSpinner.setAdapter(arrayAdapter2);
        accessSelectSpinner.setBackgroundColor(ContextCompat.getColor(this, android.R.color.holo_blue_light));
        accessSelectSpinner.setSelection(access_select);
        accessSelectSpinner.setOnItemSelectedListener(new AdapterView.OnItemSelectedListener() {
            @Override
            public void onItemSelected(AdapterView<?> parent, View view, int position, long id) {
                access_select = position;
                if (access_select == 0) {
                    appkeyView.setVisibility(View.VISIBLE);
                    appkeyText.setVisibility(View.VISIBLE);
                    appkeyText.setText(appkey);
                    akView.setText("AccessKey：");
                    akView.setVisibility(View.VISIBLE);
                    akText.setVisibility(View.VISIBLE);
                    akText.setText(accessKey);
                    skView.setText("AccessKeySecret：");
                    skView.setVisibility(View.VISIBLE);
                    skText.setVisibility(View.VISIBLE);
                    skText.setText(accessKeySecret);
                    sdkCodeView.setVisibility(View.VISIBLE);
                    sdkCodeText.setVisibility(View.VISIBLE);
                    sdkCodeText.setText(sdkCode);

                    stsTokenView.setVisibility(View.GONE);
                    stsTokenText.setVisibility(View.GONE);
                    stsTokenText.setText("");
                    Toast.makeText(
                            CompoundMainActivity.this,
                            "填入AppKey、AccessKey和AccessKeySecret和APIKey，此方法仅用于Demo试用",
                            Toast.LENGTH_SHORT).show();
                } else if (access_select == 2) {
                    appkeyView.setVisibility(View.VISIBLE);
                    appkeyText.setVisibility(View.VISIBLE);
                    appkeyText.setText(appkey);
                    akView.setText("STS_AccessKey：");
                    akView.setVisibility(View.VISIBLE);
                    akText.setVisibility(View.VISIBLE);
                    akText.setText(accessKey);
                    skView.setText("STS_AccessKeySecret：");
                    skView.setVisibility(View.VISIBLE);
                    skText.setVisibility(View.VISIBLE);
                    skText.setText(accessKeySecret);
                    stsTokenView.setVisibility(View.VISIBLE);
                    stsTokenText.setVisibility(View.VISIBLE);
                    stsTokenText.setText(stsToken);
                    sdkCodeView.setVisibility(View.VISIBLE);
                    sdkCodeText.setVisibility(View.VISIBLE);
                    sdkCodeText.setText(sdkCode);

                    Toast.makeText(
                            CompoundMainActivity.this,
                            "填入AppKey、STS_AccessKey和STS_AccessKeySecret和APIKey，此方法仅用于Demo试用",
                            Toast.LENGTH_SHORT).show();
                }
            }
            @Override
            public void onNothingSelected(AdapterView<?> parent) {
                // Do nothing
            }
        });

        if (app_code.equals("039")) {
            item = new HashMap<String, Object>();
            item.put("activity_name", " => 唤醒并Fun-ASR一句话识别");
            item.put("activity_class", WakeupAndFunAsrActivity.class);
            listItems.add(item);
        }

        SimpleAdapter adapter = new SimpleAdapter(this, listItems, R.layout.list_item,
                new String[] { "activity_name" }, new int[] { R.id.text_item });

        listView.setAdapter(adapter);
        listView.setDividerHeight(2);
        listView.setOnItemClickListener(this);

        versionView.setText("进入具体示例后，有弹窗提示内部SDK版本号\n实际开发切不可将账号信息存储在端侧");
    }

    @Override
    public void onItemClick(AdapterView<?> parent, View view, int position, long id) {
        Map<?, ?> map = (HashMap<?, ?>) parent.getAdapter().getItem(position);
        Class<?> clazz = (Class<?>) map.get("activity_class");

        appkey = appkeyText.getText().toString();
        stsToken = stsTokenText.getText().toString();
        accessKey = akText.getText().toString();
        accessKeySecret = skText.getText().toString();
        sdkCode = sdkCodeText.getText().toString();
        apikey = apikeyText.getText().toString();

        saveAccessFromFile(accessFilePath);

        Intent it = new Intent(this, clazz);

        it.putExtra("url", url); // 传递第一个参数
        it.putExtra("appkey", appkeyText.getText().toString()); // 传递第二个参数
        it.putExtra("apikey", apikeyText.getText().toString()); // 传递第三个参数
        it.putExtra("accessKey", akText.getText().toString()); // 传递第四个参数
        it.putExtra("accessKeySecret", skText.getText().toString()); // 传递第五个参数
        it.putExtra("stsToken", stsTokenText.getText().toString()); // 传递第六个参数
        it.putExtra("sdkCode", sdkCodeText.getText().toString()); // 传递第七个参数
        it.putExtra("accessFile", accessFilePath); // 传递第八个参数

        this.startActivity(it);
    }

    @Override
    public void onBackPressed() {
        finish();
        super.onBackPressed();
    }
    @Override
    public void onDestroy() {
        super.onDestroy();
    }

    private String getGitRevision(){
        return BuildConfig.gitVersionId;
    }

    private void parseAccessFromFile(String dir, String fileName) {
        Log.i(TAG, "ready to open " + fileName + " from " + dir);
        accessFilePath = dir + "/" + fileName;
        File directory = new File(dir);
        File[] files = directory.listFiles();
        if (files != null) {
            for (File file : files) {
                if (file.getName().equals(fileName)) {
                    try {
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                        StringBuilder stringBuilder = new StringBuilder();
                        String line;
                        while ((line = bufferedReader.readLine()) != null) {
                            stringBuilder.append(line);
                        }
                        bufferedReader.close();

                        // 读取JSON内容并获取String和int对象
                        String jsonContent = stringBuilder.toString();
                        JSONObject jsonObject = JSON.parseObject(jsonContent);
                        if (jsonObject.getString("compound_url") != null &&
                                !jsonObject.getString("compound_url").isEmpty()) {
                            url = jsonObject.getString("compound_url");
                            Log.i(TAG, "Get url: " + url);
                        }
                        if (jsonObject.containsKey("compound_server_control")) {
                            url_select = jsonObject.getIntValue("compound_server_control");
                            Log.i(TAG, "Get url select: " + url_select);
                        }
                        if (appkey.isEmpty() && jsonObject.getString("compound_appkey") != null &&
                                !jsonObject.getString("compound_appkey").isEmpty()) {
                            appkey = jsonObject.getString("compound_appkey");
                            Log.i(TAG, "Get appkey: " + appkey);
                        }
                        if (stsToken.isEmpty() && jsonObject.getString("compound_sts_token") != null &&
                                !jsonObject.getString("compound_sts_token").isEmpty()) {
                            stsToken = jsonObject.getString("compound_sts_token");
                            Log.i(TAG, "Get sts_token: " + stsToken);
                        }
                        if (accessKey.isEmpty() && jsonObject.getString("compound_ak") != null &&
                                !jsonObject.getString("compound_ak").isEmpty()) {
                            accessKey = jsonObject.getString("compound_ak");
                            Log.i(TAG, "Get accessKey: " + accessKey);
                        }
                        if (accessKeySecret.isEmpty() && jsonObject.getString("compound_sk") != null
                                && !jsonObject.getString("compound_sk").isEmpty()) {
                            accessKeySecret = jsonObject.getString("compound_sk");
                            Log.i(TAG, "Get accessKeySecret: " + accessKeySecret);
                        }
                        if (jsonObject.containsKey("compound_access_select")) {
                            access_select = jsonObject.getIntValue("compound_access_select");
                            Log.i(TAG, "Get url select: " + access_select);
                        }
                        if (sdkCode.equals(defaultSdkCode) &&
                                jsonObject.getString("compound_sdk_code") != null &&
                                !jsonObject.getString("compound_sdk_code").isEmpty()) {
                            String oldSdkCode = jsonObject.getString("compound_sdk_code");
                            if (!oldSdkCode.equals(defaultSdkCode)) {
                                sdkCode = jsonObject.getString("compound_sdk_code");
                            }
                            Log.i(TAG, "Get sdk_code: " + sdkCode);
                        }
                        if (apikey.isEmpty() && jsonObject.getString("compound_apikey") != null &&
                                !jsonObject.getString("compound_apikey").isEmpty()) {
                            apikey = jsonObject.getString("compound_apikey");
                            Log.i(TAG, "Get apikey: " + apikey);
                        }
                    } catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
        } else {
            Log.e(TAG, "dir " + dir + " is invalid.");
        }
    }

    private void saveAccessFromFile(String fileName) {
        JSONObject object = new JSONObject();
        object.put("compound_url", url);
        object.put("compound_appkey", appkey);
        object.put("compound_sts_token", stsToken);
        object.put("compound_ak", accessKey);
        object.put("compound_sk", accessKeySecret);
        object.put("compound_server_control", url_select);
        object.put("compound_access_select", access_select);
        object.put("compound_sdk_code", sdkCode);
        object.put("compound_apikey", apikey);
        object.put("compound_access_file", fileName);

        Log.i(TAG, "Save info: " + object.toString() + " to " + fileName);

        try {
            FileWriter fileWriter = new FileWriter(fileName);
            BufferedWriter bufferedWriter = new BufferedWriter(fileWriter);
            bufferedWriter.write(object.toString());
            bufferedWriter.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }
}
