#ifndef NUI_ANDROID_NUI_ABS_LAYER_H
#define NUI_ANDROID_NUI_ABS_LAYER_H

#include <stdint.h>

#include <map>
#include <string>

#include "nui.h"
#include "nuisdk.h"
#include "nuittssdk.h"
#if defined(DO_AUTHENTICATION) || defined(ACCESS_TOKEN)
#include "auth.h"
#endif
#include "dialog_engine.h"
#include "handler_thread.h"
#include "internal/utils.h"
#include "looper.h"
#ifdef NUI_INCLUDE_TTS
#include "ttssdk_itf.h"
#endif
#ifdef NUI_INCLUDE_FILE_TRANS
#include "file_trans_manager.h"
#endif

namespace nuisdk {

#define SYNC_CALL_ABORT_TIMEOUT 20000

#define PARAM_ENV "env"
#define PARAM_WORKSPACE "workspace"
#define PARAM_IGNORE_WORKSPACE "ignore_workspace"
#define PARAM_DEBUG_PATH "debug_path"
#define PARAM_KEEP_ALIVE "keep_alive"
#define kApiKeyUrl "url"
#define kApiKeyKey "app_key"
#define kApiKeyToken "token"
#define kApiSecurityToken "sts_token"
#define PARAM_CUSTOM_HEADER "custom_header_param"
#define PARAM_CUSTOM_HEADER_KEY "custom_header_key"
#define PARAM_DEVICE_ID "device_id"
#define PARAM_AK_ID "ak_id"
#define PARAM_Ak_SECRET "ak_secret"
#define PARAM_SDK_CODE "sdk_code"
#define PARAM_RECORDER_FROM_USER "enable_recorder_by_user"
#define PARAM_AUTH_URL "auth_url"
#define PARAM_AUTH_HOST "auth_host"
#define PARAM_HARDWARE_INFO "hardware_info"

#define PARAM_AUDIO_UPDATE_MANUALLY "audio_update_manually"
#define PARAM_ENABLE_WWV "enable_wwv"
#define PARAM_CONNECTION_TIMEOUT "connection_timeout"
#define PARAM_PARTIAL_ASR_TIMEOUT "partial_asr_timeout"
#define PARAM_ASR_TIMEOUT "asr_timeout"
#define PARAM_DIALOG_TIMEOUT "dialog_timeout"
#define PARAM_STOP_WAIT_TIME "stop_wait_time_ms"
#define PARAM_ENABLE_DIALOG "enable_dialog"

#define PARAM_LOG_LEVEL "log_level"
#define PARAM_MAX_LOG_FILE_SIZE "max_log_file_size"
#define PARAM_LOG_TRACK_LEVEL "log_track_level"
#define PARAM_DEBUG "debug"
#define PARAM_SAVE_WAV "save_wav"

#define PARAM_NEW_DIALOG_ID "new_dialog_id"
// Context
#define PARAM_CONTEXT "context"
#define PARAM_FINISH "finish"

// TEXT2ACTION
#define PARAM_TEXT "text"
#define PARAM_SERVICE_MODE "service_mode"

#define PARAM_DEBUG_WWV "debug_wwv"

#define PARAM_WANT_ORIG_RESULT "want_orig_result"

#define PARAM_STASH_PARTIAL_RESULT "stash_partial_result"

#define PARAM_SET_KEY "param_set_key"
#define PARAM_SET_VALUE "param_set_value"
#define PARAM_SET_PARAMS "param_set_params"
#define PARAM_DIALOG_PARAMS "dialog_params"
#define PARAM_VAD_MODE "vad_mode"
#define VPR_SERVICE_ID "service_id"
#define VPR_GROUP_ID "group_id"
#define VPR_USER_ID "user_id"
#define VPR_OP "vpr_op"

// #define kApiKeyDevice "device_id"
// #define kApiKeyUser "kApiKeyUser"
// #define kApiKeyPhoneType "kApiKeyPhoneType"
// #define kApiKeyLogLevel "kApiKeyLogLevel"
// #define kApiKeySaveWave "kApiKeySaveWave"
// #define kApiKeyVadMode "kApiKeyVadMode"
// #define kApiKeyCity "kApiKeyCity"
// #define kApiKeyNetworkState "kApiKeyNetworkState"

#define kApiKeyTtsText "kApiKeyTtsText"
#define kApiKeyTtsTaskId "kApiKeyTtsTaskId"
#define kApiKeyTtsCancelTaskId "kApiKeyTtsCancelTaskId"
#define kApiKeyTtsPriority "kApiKeyTtsPriority"
#define kApiKeyTtsParam "kApiKeyTtsParam"
#define kApiKeyTtsParamValue "kApiKeyTtsParamValue"

#define KLOG_WITH_FILTER(KEY)                                        \
  do {                                                               \
    std::string _key = root[#KEY].asString();                        \
    if (!strcmp(#KEY, kApiKeyToken) || !strcmp(#KEY, PARAM_AK_ID) || \
        !strcmp(#KEY, PARAM_Ak_SECRET)) {                            \
      KLOGI(TAG, "add KEY[" #KEY "] as VALUE[no print]");            \
    } else {                                                         \
      KLOGI(TAG, "add KEY[" #KEY "] as VALUE[%s]", _key.c_str());    \
    }                                                                \
  } while (0)

#define CHECK_STRING_PARAMS(TAG, KEY, FROM, MAP, OPT) \
  do {                                                \
    if (!root[#KEY].isNull()) {                       \
      if (!root[#KEY].isString()) {                   \
        KLOGE(TAG, #KEY " should be a string");       \
        if (OPT) {                                    \
          return false;                               \
        }                                             \
      } else {                                        \
        std::string _key = root[#KEY].asString();     \
        if (_key.empty()) {                           \
          KLOGE(TAG, #KEY " is empty");               \
          if (OPT) {                                  \
            return false;                             \
          }                                           \
        } else {                                      \
          KLOG_WITH_FILTER(KEY);                      \
          MAP[#KEY] = _key;                           \
        }                                             \
      }                                               \
    } else {                                          \
      KLOGW(TAG, "cannot find " #KEY " in params");   \
      if (OPT) {                                      \
        return false;                                 \
      }                                               \
    }                                                 \
  } while (0)

#define CHECK_INT_PARAMS(TAG, KEY, FROM, MAP, OPT)                         \
  do {                                                                     \
    if (!root[#KEY].isNull()) {                                            \
      if (!root[#KEY].isInt()) {                                           \
        KLOGE(TAG, #KEY " should be an int");                              \
        if (OPT) {                                                         \
          return false;                                                    \
        }                                                                  \
      }                                                                    \
      int key = root[#KEY].asInt();                                        \
      std::string skey = nui::TextUtils::to_string(key); \
      KLOGI(TAG, "add KEY[" #KEY "] as VALUE[%s]", skey.c_str());          \
      MAP[#KEY] = skey;                                                    \
    } else {                                                               \
      KLOGE(TAG, "cannot find " #KEY " in params");                        \
      if (OPT) {                                                           \
        return false;                                                      \
      }                                                                    \
    }                                                                      \
  } while (0)

struct ApiParameters {
  ApiParameters &operator=(const ApiParameters &rhs);
  ApiParameters()
      : callid(0), ret_value_b(SUCCESS), async_call(false), is_done(false) {}

  std::map<std::string, std::string> string_map;
  NuiAsyncCallback async_callback;
  NuiSdkListener nui_listener;
  int callid;
  NuiResultCode ret_value_b;
  bool async_call;
  std::mutex cond_lock;
  std::condition_variable condition;
  bool is_done;
};

#ifndef TTS_ONLY
class NuiAbsLayerHandler;
class NuiAbsLayer {
 public:
  friend NuiAbsLayerHandler;
  NuiAbsLayer(void *relation);
  ~NuiAbsLayer();
  // static NuiAbsLayer& GetInstance() {
  //   static NuiAbsLayer abs_layer;
  //   return abs_layer;
  // }

  NuiResultCode ApiInitialize(struct ApiParameters *parameters);
  NuiResultCode ApiRelease(struct ApiParameters *parameters);
  NuiResultCode ApiSetParam(struct ApiParameters *parameters);
  NuiResultCode ApiSetParams(struct ApiParameters *parameters);
  NuiResultCode ApiStart(struct ApiParameters *parameters);
  NuiResultCode ApiCancel(struct ApiParameters *parameters);
  NuiResultCode ApiDialogResume(struct ApiParameters *parameters);
  NuiResultCode ApiDialogText2Action(struct ApiParameters *parameters);
  NuiResultCode ApiDialogText2ActionCancel(struct ApiParameters *parameters);
  NuiResultCode ApiStop(struct ApiParameters *parameters);
  NuiResultCode CancelDialog();
  NuiResultCode RestartDialog();
  NuiResultCode ApiCheckAsset(const char *file);
  const char *ApiGetVersion(const char *module);
  NuiResultCode ApiFileTransStart(const char *params, char *task_id);
  NuiResultCode ApiFileTransCancel(const char *task_id);
  NuiResultCode ApiUpdateAudioData(const char *data, int len_in_byte,
                                   bool first_pack);

  NuiResultCode ApiVprOperation(struct ApiParameters *para);

#ifdef NUI_INCLUDE_LOCAL_KWS
  nui::Wuw get_wuw_from_group_id(const char *group_id);
#endif
  bool GetAsrTextFromDialogResult(const std::string &result,
                                  std::string &dialog_text);
  bool GetAsrTextFromAsrResult(const std::string &result,
                               std::string &asr_text);
  int GetErrorResult(std::string &err_text);
  int GetTranscriberResult(std::string &asr_text);
  bool GetAsrResult(std::string &asr_text);
  bool GetDialogResult(std::string &dialog_text);
  bool GetText2ActionDialogResult(std::string &dialog_text);
  bool GetWuwTextFromDialogResult(const std::string &result,
                                  std::string &wuw_text);
  bool GetTextFromAttrResult(const std::string &result, std::string &attr_text);
  bool GetWuwText(std::string &wuw_text);
  bool GetAllResponse(std::string &response_text);

  NuiAbsLayer(const NuiAbsLayer &) = delete;
  NuiAbsLayer &operator=(const NuiAbsLayer &) = delete;
  nui::Nui nui_instance;
#ifdef NUI_INCLUDE_FILE_TRANS
  nui::FileTransManager file_manager;
#endif
  NuiSdkListener s_listener;
  bool want_orig_result;
  std::string sr_model = "";
  bool s_nui_init;
  bool s_has_stopped_or_canncelled;
  bool s_single_round;
  bool g_vpr_enable;
  ApiParameters last_api_param;
  int g_service_type;
  bool first_provide_data;

  void *nui_sdk;  // only mark

 private:
  class NuiAbsLayerHandler : public nui::EasyHandler {
   public:
    enum {
      MSG_INIT,
      MSG_RELEASE,

      MSG_API_INIT,
      MSG_API_RELEASE,
      MSG_API_START,
      MSG_API_CANCEL,
      MSG_API_RESUME,
      MSG_API_STOP,
      MSG_API_SET_PARAM,
      MSG_API_SET_PARAMS,
      MSG_API_VPR_OPERATION,
      MSG_API_TEXT2ACTION,
      MSG_API_TEXT2ACTION_CANCEL,
    };

    NuiAbsLayerHandler(NuiAbsLayer *abs_layer_) : abs_layer(abs_layer_) {}
    virtual ~NuiAbsLayerHandler() {}

    NuiResultCode HandleApiInit(struct ApiParameters *para);
    NuiResultCode HandleApiRelease(struct ApiParameters *para);
    NuiResultCode HandleApiSetParam(struct ApiParameters *para);
    NuiResultCode HandleApiSetParams(struct ApiParameters *para);
    NuiResultCode HandleApiStart(struct ApiParameters *para);
    NuiResultCode HandleApiCancel(struct ApiParameters *para);
    NuiResultCode HandleApiStop(struct ApiParameters *para);
    NuiResultCode HandleApiResume(struct ApiParameters *para);
    NuiResultCode HandleApiVprOperation(struct ApiParameters *para);
    NuiResultCode HandleApiText2Action(struct ApiParameters *para);
    NuiResultCode HandleApiText2ActionCancel(struct ApiParameters *para);
    virtual void HandleMessage(
        nui::EasyMessage &msg) override;

    std::string GetNuiAbsLayerHandlerString(int what);

   private:
    NuiAbsLayer *abs_layer;
  };

  NuiResultCode SendMessage(const nui::EasyMessage &message,
                            struct ApiParameters *parameters, bool async);
  bool testIllegalReentrant(struct ApiParameters *parameters);
  std::string PackTicket(std::map<std::string, std::string> &string_map);
  std::string PackTicketWithFilter(
      std::map<std::string, std::string> &string_map);
  std::string GetParamOrDefault(std::map<std::string, std::string> &params,
                                const std::string &key,
                                const std::string &default_value = "");
  int GetParamOrDefaultToI(std::map<std::string, std::string> &params,
                           const std::string &key,
                           const std::string &default_value = "");

  std::shared_ptr<nui::EasyLooper> looper;
  std::shared_ptr<NuiAbsLayerHandler> handler;

  std::shared_ptr<nui::HandlerThread> handler_thread;
  std::atomic<std::thread::id> async_thread_id;
  std::string last_dialog_id;

#if defined(DO_AUTHENTICATION) || defined(ACCESS_TOKEN)
  auth::AuthManager auth_instance;
#endif
#if defined(DO_AUTHENTICATION)
  bool worked_auth_flag = false;
#endif
  bool NUI_ABS_EXIT = false;
};
#endif

#ifdef NUI_INCLUDE_TTS

// TTS PART
struct ApiTtsParameters {
  std::map<std::string, std::string> string_map;
  NuiAsyncCallback async_callback;
  NuiTtsSdkListener tts_listener;
  int callid;
  int ret_value_b;
  bool async_call;
  std::mutex cond_lock;
  std::condition_variable condition;
};

#endif

}  // namespace nuisdk

#endif
