/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.jdbc;

import com.aliyun.polardb2.util.PGobject;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;

public class PostgresStructConverter {
    public static String objectArrayToPostgresStruct(Object[] attributes) {
        if (attributes == null) {
            return "NULL";
        }
        StringBuilder sb = new StringBuilder("(");
        for (int i = 0; i < attributes.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            PostgresStructConverter.appendPostgresValue(sb, attributes[i]);
        }
        sb.append(")");
        return sb.toString();
    }

    private static void appendPostgresValue(StringBuilder sb, Object value) {
        if (value == null) {
            sb.append("NULL");
            return;
        }
        if (value instanceof String) {
            PostgresStructConverter.appendString(sb, (String)value);
        } else if (value instanceof Integer || value instanceof Long || value instanceof Short || value instanceof Byte) {
            sb.append(value.toString());
        } else if (value instanceof Float || value instanceof Double || value instanceof BigDecimal) {
            sb.append(value.toString());
        } else if (value instanceof Boolean) {
            sb.append((Boolean)value != false ? "true" : "false");
        } else if (value instanceof java.sql.Date) {
            PostgresStructConverter.appendDate(sb, (java.sql.Date)value);
        } else if (value instanceof Time) {
            PostgresStructConverter.appendTime(sb, (Time)value);
        } else if (value instanceof Timestamp) {
            PostgresStructConverter.appendTimestamp(sb, (Timestamp)value);
        } else if (value instanceof Date) {
            PostgresStructConverter.appendTimestamp(sb, new Timestamp(((Date)value).getTime()));
        } else if (value instanceof byte[]) {
            PostgresStructConverter.appendBinary(sb, (byte[])value);
        } else if (value instanceof UUID) {
            PostgresStructConverter.appendUUID(sb, (UUID)value);
        } else if (value instanceof PGobject) {
            PostgresStructConverter.appendPGobject(sb, (PGobject)value);
        } else {
            PostgresStructConverter.appendString(sb, value.toString());
        }
    }

    private static void appendString(StringBuilder sb, String value) {
        sb.append("\"");
        sb.append(value.replace("\"", "\"\""));
        sb.append("\"");
    }

    private static void appendDate(StringBuilder sb, java.sql.Date value) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        sb.append("'").append(dateFormat.format(value)).append("'");
    }

    private static void appendTime(StringBuilder sb, Time value) {
        SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm:ss.SSS");
        sb.append("'").append(timeFormat.format(value)).append("'");
    }

    private static void appendTimestamp(StringBuilder sb, Timestamp value) {
        SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        sb.append("'").append(timestampFormat.format(value)).append("'");
    }

    private static void appendBinary(StringBuilder sb, byte[] value) {
        sb.append("'\\x");
        for (byte b : value) {
            sb.append(String.format("%02x", b));
        }
        sb.append("'");
    }

    private static void appendUUID(StringBuilder sb, UUID value) {
        sb.append("'").append(value.toString()).append("'");
    }

    private static void appendPGobject(StringBuilder sb, PGobject value) {
        if (value.getValue() == null) {
            sb.append("NULL");
        } else if ("json".equals(value.getType()) || "jsonb".equals(value.getType())) {
            sb.append("'").append(value.getValue().replace("'", "''")).append("'");
        } else {
            sb.append("'").append(value.getValue().replace("'", "''")).append("'");
        }
    }
}

