/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.polardb2.core.v3;

import com.aliyun.polardb2.copy.CopyOperation;
import com.aliyun.polardb2.core.v3.QueryExecutorImpl;
import com.aliyun.polardb2.util.GT;
import com.aliyun.polardb2.util.PSQLException;
import com.aliyun.polardb2.util.PSQLState;
import com.aliyun.polardb2.util.internal.Nullness;
import java.sql.SQLException;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class CopyOperationImpl
implements CopyOperation {
    @Nullable QueryExecutorImpl queryExecutor;
    int rowFormat;
    int @Nullable [] fieldFormats;
    long handledRowCount = -1L;

    void init(QueryExecutorImpl q, int fmt, int[] fmts) {
        this.queryExecutor = q;
        this.rowFormat = fmt;
        this.fieldFormats = fmts;
    }

    protected QueryExecutorImpl getQueryExecutor() {
        return Nullness.castNonNull(this.queryExecutor);
    }

    @Override
    public void cancelCopy() throws SQLException {
        Nullness.castNonNull(this.queryExecutor).cancelCopy(this);
    }

    @Override
    public int getFieldCount() {
        return Nullness.castNonNull(this.fieldFormats).length;
    }

    @Override
    public int getFieldFormat(int field) {
        return Nullness.castNonNull(this.fieldFormats)[field];
    }

    @Override
    public int getFormat() {
        return this.rowFormat;
    }

    @Override
    public boolean isActive() {
        return Nullness.castNonNull(this.queryExecutor).hasLockOn(this);
    }

    public void handleCommandStatus(String status) throws PSQLException {
        if (!status.startsWith("COPY")) {
            throw new PSQLException(GT.tr("CommandComplete expected COPY but got: " + status, new Object[0]), PSQLState.COMMUNICATION_ERROR);
        }
        int i = status.lastIndexOf(32);
        this.handledRowCount = i > 3 ? Long.parseLong(status.substring(i + 1)) : -1L;
    }

    protected abstract void handleCopydata(byte[] var1) throws PSQLException;

    @Override
    public long getHandledRowCount() {
        return this.handledRowCount;
    }
}

