/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.util;

import java.util.HashMap;
import java.util.Map;

public class AuthUtil {
    public static boolean isNeedMaskValue(String key) {
        return "fs.oss.accessKeySecret".equalsIgnoreCase(key) || "fs.oss.securityToken".equalsIgnoreCase(key);
    }

    public static String maskValue(String key, String value) {
        if (AuthUtil.isNeedMaskValue(key)) {
            return "******";
        }
        return value;
    }

    public static Map<String, String> maskMap(Map<String, String> map) {
        HashMap<String, String> maskMap = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : map.entrySet()) {
            maskMap.put(entry.getKey(), AuthUtil.maskValue(entry.getKey(), entry.getValue()));
        }
        return maskMap;
    }
}

