/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest.jindo;

import com.aliyun.jindodata.common.JindoHadoopSystem;
import com.aliyun.jindodata.oss.JindoOssFileSystem;
import com.aliyun.jindodata.s3.JindoS3FileSystem;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UncheckedIOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.RemoteIterator;
import org.apache.iceberg.exceptions.AlreadyExistsException;
import org.apache.iceberg.exceptions.NotFoundException;
import org.apache.iceberg.exceptions.RuntimeIOException;
import org.apache.iceberg.hadoop.HadoopFileIO;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.io.StorageCredential;
import org.apache.iceberg.rest.jindo.DlfInnerFileIO;
import org.apache.iceberg.rest.util.AuthUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.apache.iceberg.util.Tasks;
import org.apache.iceberg.util.ThreadPools;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JindoFileIO
implements DlfInnerFileIO {
    private static final Logger LOG = LoggerFactory.getLogger(JindoFileIO.class);
    private static final String DELETE_FILE_PARALLELISM = "iceberg.hadoop.delete-file-parallelism";
    private static final String DELETE_FILE_POOL_NAME = "iceberg-hadoopfileio-delete";
    private static final int DELETE_RETRY_ATTEMPTS = 3;
    private static final int DEFAULT_DELETE_CORE_MULTIPLE = 4;
    private static volatile ExecutorService executorService;
    private volatile SerializableSupplier<Configuration> hadoopConf;
    private SerializableMap<String, String> properties = SerializableMap.copyOf((Map)ImmutableMap.of());
    private List<StorageCredential> storageCredentials = ImmutableList.of();
    private static final String[] CONFIG_PREFIXES;
    private static final Map<String, String> CASE_SENSITIVE_KEYS;
    private static final Map<CacheKey, Pair<JindoHadoopSystem, String>> CACHE;
    private final Map<String, String> hadoopOptions;
    private volatile transient Map<String, Pair<JindoHadoopSystem, String>> fsMap;

    public JindoFileIO() {
        this((SerializableSupplier<Configuration>)((SerializableSupplier)null));
    }

    public JindoFileIO(Configuration hadoopConf) {
        this((SerializableSupplier<Configuration>)((SerializableSupplier & Serializable)() -> ((SerializableConfiguration)new SerializableConfiguration(hadoopConf)).get()));
    }

    public JindoFileIO(SerializableSupplier<Configuration> hadoopConf) {
        this.hadoopConf = hadoopConf;
        this.hadoopOptions = new ConcurrentHashMap<String, String>();
        this.hadoopOptions.put("fs.oss.impl", "com.aliyun.jindodata.oss.JindoOssFileSystem");
        this.hadoopOptions.put("fs.AbstractFileSystem.oss.impl", "com.aliyun.jindodata.oss.OSS");
        this.hadoopOptions.put("fs.oss.read.position.buffer.size", "8388608");
        this.hadoopOptions.put("fs.oss.credentials.provider", "com.aliyun.jindodata.oss.auth.SimpleCredentialsProvider");
    }

    public Configuration conf() {
        return this.getConf();
    }

    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
        this.properties().forEach((arg_0, arg_1) -> ((Configuration)this.getConf()).set(arg_0, arg_1));
        this.buildStorageHadoopOptions();
    }

    public InputFile newInputFile(String path) {
        JindoHadoopSystem fs = this.getFileSystem(this.path(path));
        return HadoopInputFile.fromLocation((CharSequence)path, (FileSystem)fs);
    }

    public InputFile newInputFile(String path, long length) {
        JindoHadoopSystem fs = this.getFileSystem(this.path(path));
        return HadoopInputFile.fromLocation((CharSequence)path, (long)length, (FileSystem)fs);
    }

    public OutputFile newOutputFile(String path) {
        JindoHadoopSystem fs = this.getFileSystem(this.path(path));
        return HadoopOutputFile.fromPath((Path)new Path(path), (FileSystem)fs);
    }

    public void deleteFile(String path) {
        Path toDelete = new Path(path);
        JindoHadoopSystem fs = this.getFileSystem(this.path(path));
        try {
            fs.delete(toDelete, false);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to delete file: %s", new Object[]{path});
        }
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = () -> ((SerializableConfiguration)new SerializableConfiguration(conf)).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf() {
        if (this.hadoopConf == null) {
            JindoFileIO jindoFileIO = this;
            synchronized (jindoFileIO) {
                if (this.hadoopConf == null) {
                    this.hadoopConf = () -> ((SerializableConfiguration)new SerializableConfiguration(new Configuration())).get();
                }
            }
        }
        return (Configuration)this.hadoopConf.get();
    }

    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        Path prefixToList = new Path(prefix);
        JindoHadoopSystem fs = this.getFileSystem(this.path(prefix));
        return () -> {
            try {
                return Streams.stream(new AdaptingIterator(fs.listFiles(prefixToList, true))).map(fileStatus -> new FileInfo(fileStatus.getPath().toString(), fileStatus.getLen(), fileStatus.getModificationTime())).iterator();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
    }

    public void deletePrefix(String prefix) {
        Path prefixToDelete = new Path(prefix);
        JindoHadoopSystem fs = this.getFileSystem(this.path(prefix));
        try {
            fs.delete(prefixToDelete, true);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        AtomicInteger failureCount = new AtomicInteger(0);
        Tasks.foreach(pathsToDelete).executeWith(this.executorService()).retry(3).stopRetryOn(new Class[]{FileNotFoundException.class}).suppressFailureWhenFinished().onFailure((f, e) -> {
            LOG.error("Failure during bulk delete on file: {} ", f, (Object)e);
            failureCount.incrementAndGet();
        }).run(this::deleteFile);
        if (failureCount.get() != 0) {
            throw new BulkDeletionFailureException(failureCount.get());
        }
    }

    private void buildStorageHadoopOptions() {
        Map<String, String> storageProps = this.storageCredentialConfig();
        for (String key : storageProps.keySet()) {
            for (String prefix : CONFIG_PREFIXES) {
                if (!key.startsWith(prefix)) continue;
                String value = storageProps.get(key);
                if (CASE_SENSITIVE_KEYS.containsKey(key.toLowerCase())) {
                    key = CASE_SENSITIVE_KEYS.get(key.toLowerCase());
                }
                if (this.getConf().get(key) == null || this.isNeedOverwrite(key)) {
                    this.hadoopOptions.put(key, value);
                } else {
                    LOG.info("Ignoring storage property entry for {} as it is already set to {}", (Object)key, (Object)AuthUtil.maskValue(key, this.getConf().get(key)));
                    this.hadoopOptions.put(key, this.getConf().get(key));
                }
                LOG.info("Adding config entry for {} as {} to Hadoop config", (Object)key, (Object)AuthUtil.maskValue(key, this.hadoopOptions.get(key)));
            }
        }
    }

    private boolean isNeedOverwrite(String key) {
        return "fs.oss.accessKeyId".equalsIgnoreCase(key) || "fs.oss.accessKeySecret".equalsIgnoreCase(key) || "fs.oss.securityToken".equalsIgnoreCase(key);
    }

    private int deleteThreads() {
        int defaultValue = Runtime.getRuntime().availableProcessors() * 4;
        return this.conf().getInt(DELETE_FILE_PARALLELISM, defaultValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ExecutorService executorService() {
        if (executorService != null) return executorService;
        Class<HadoopFileIO> clazz = HadoopFileIO.class;
        synchronized (HadoopFileIO.class) {
            if (executorService != null) return executorService;
            executorService = ThreadPools.newExitingWorkerPool((String)DELETE_FILE_POOL_NAME, (int)this.deleteThreads());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return executorService;
        }
    }

    public void setCredentials(List<StorageCredential> credentials) {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"Invalid storage credentials: null");
        this.storageCredentials = Lists.newArrayList(credentials);
    }

    public List<StorageCredential> credentials() {
        return ImmutableList.copyOf(this.storageCredentials);
    }

    private Map<String, String> storageCredentialConfig() {
        if (this.storageCredentials == null) {
            return ImmutableMap.of();
        }
        return this.storageCredentials.stream().map(StorageCredential::config).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> replacement));
    }

    @Override
    public SeekableInputStream newInStream(String file) {
        Path path = new Path(file);
        try {
            return new DlfSeekableInputStream(this.getFileSystem(path).open(path));
        }
        catch (FileNotFoundException e) {
            throw new NotFoundException((Throwable)e, "Failed to open input stream for file: %s", new Object[]{path});
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to open input stream for file: %s", new Object[]{path});
        }
    }

    @Override
    public PositionOutputStream newOutStream(String file, boolean overwrite) {
        Path path = new Path(file);
        try {
            return new DlfPositionOutputStream(this.getFileSystem(path).create(path, overwrite));
        }
        catch (FileAlreadyExistsException e) {
            throw new AlreadyExistsException((Throwable)e, "Path already exists: %s", new Object[]{path});
        }
        catch (IOException e) {
            throw new RuntimeIOException(e, "Failed to create file: %s", new Object[]{path});
        }
    }

    public JindoHadoopSystem getFileSystem(Path path) {
        return (JindoHadoopSystem)this.getFileSystemPair(path).first();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pair<JindoHadoopSystem, String> getFileSystemPair(Path path) {
        if (this.fsMap == null) {
            JindoFileIO jindoFileIO = this;
            synchronized (jindoFileIO) {
                if (this.fsMap == null) {
                    this.fsMap = new ConcurrentHashMap<String, Pair<JindoHadoopSystem, String>>();
                }
            }
        }
        Map<String, Pair<JindoHadoopSystem, String>> map = this.fsMap;
        String authority = path.toUri().getAuthority();
        if (authority == null) {
            authority = "DEFAULT";
        }
        return map.computeIfAbsent(authority, k -> this.createFileSystem(path));
    }

    private Pair<JindoHadoopSystem, String> createFileSystem(Path path) {
        String scheme = path.toUri().getScheme();
        String authority = path.toUri().getAuthority();
        Supplier<Pair> supplier = () -> {
            JindoOssFileSystem fs;
            URI defaultUri;
            Configuration conf = new Configuration(this.conf());
            this.hadoopOptions.forEach((arg_0, arg_1) -> ((Configuration)conf).set(arg_0, arg_1));
            URI fsUri = path.toUri();
            if (scheme == null && authority == null) {
                fsUri = FileSystem.getDefaultUri((Configuration)conf);
            } else if (scheme != null && authority == null && scheme.equals((defaultUri = FileSystem.getDefaultUri((Configuration)conf)).getScheme()) && defaultUri.getAuthority() != null) {
                fsUri = defaultUri;
            }
            if ("oss".equals(scheme)) {
                fs = new JindoOssFileSystem();
            } else if ("s3".equals(scheme)) {
                fs = new JindoS3FileSystem();
            } else {
                throw new RuntimeException("Unsupported scheme for Jindo FileSystem: " + scheme);
            }
            try {
                fs.initialize(fsUri, conf);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
            return Pair.of((Object)fs, (Object)fs.getSysType(path).getSysType());
        };
        return CACHE.computeIfAbsent(new CacheKey(this.hadoopOptions, scheme, authority), key -> (Pair)supplier.get());
    }

    protected Path path(String pathString) {
        Path path = new Path(pathString);
        URI uri = path.toUri();
        String scheme = uri.getScheme();
        if ("oss".equals(scheme) && uri.getUserInfo() != null) {
            path = new Path("oss:/" + uri.getPath());
        }
        if ("s3".equals(scheme) && uri.getUserInfo() != null) {
            path = new Path("s3:/" + uri.getPath());
        }
        return new Path(path.toUri());
    }

    static {
        CONFIG_PREFIXES = new String[]{"fs."};
        CASE_SENSITIVE_KEYS = new HashMap<String, String>(){
            {
                this.put("fs.oss.accessKeyId".toLowerCase(), "fs.oss.accessKeyId");
                this.put("fs.oss.accessKeySecret".toLowerCase(), "fs.oss.accessKeySecret");
                this.put("fs.oss.securityToken".toLowerCase(), "fs.oss.securityToken");
            }
        };
        CACHE = new ConcurrentHashMap<CacheKey, Pair<JindoHadoopSystem, String>>();
    }

    private static class DlfPositionOutputStream
    extends PositionOutputStream {
        private final FSDataOutputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        DlfPositionOutputStream(FSDataOutputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void write(int b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b) throws IOException {
            this.stream.write(b);
        }

        public void write(byte[] b, int off, int len) throws IOException {
            this.stream.write(b, off, len);
        }

        public void flush() throws IOException {
            this.stream.flush();
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
            }
        }
    }

    private static class DlfSeekableInputStream
    extends SeekableInputStream {
        private final FSDataInputStream stream;
        private final StackTraceElement[] createStack;
        private boolean closed;

        DlfSeekableInputStream(FSDataInputStream stream) {
            this.stream = stream;
            this.createStack = Thread.currentThread().getStackTrace();
            this.closed = false;
        }

        public void close() throws IOException {
            this.stream.close();
            this.closed = true;
        }

        public long getPos() throws IOException {
            return this.stream.getPos();
        }

        public void seek(long newPos) throws IOException {
            this.stream.seek(newPos);
        }

        public int read() throws IOException {
            return this.stream.read();
        }

        public int read(byte[] b, int off, int len) throws IOException {
            return this.stream.read(b, off, len);
        }

        protected void finalize() throws Throwable {
            super.finalize();
            if (!this.closed) {
                this.close();
            }
        }
    }

    private static class CacheKey {
        private final Map<String, String> options;
        private final String scheme;
        private final String authority;

        private CacheKey(Map<String, String> options, String scheme, String authority) {
            this.options = options;
            this.scheme = scheme;
            this.authority = authority;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return Objects.equals(this.options, cacheKey.options) && Objects.equals(this.scheme, cacheKey.scheme) && Objects.equals(this.authority, cacheKey.authority);
        }

        public int hashCode() {
            return Objects.hash(this.options, this.scheme, this.authority);
        }
    }

    private static class AdaptingIterator<E>
    implements Iterator<E>,
    RemoteIterator<E> {
        private final RemoteIterator<E> delegate;

        AdaptingIterator(RemoteIterator<E> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            try {
                return this.delegate.hasNext();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        @Override
        public E next() {
            try {
                return (E)this.delegate.next();
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

