/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.rest;

import com.google.common.base.Preconditions;
import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.catalog.Namespace;
import org.apache.iceberg.catalog.TableIdentifier;
import org.apache.iceberg.exceptions.NoSuchTableException;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.hadoop.SerializableConfiguration;
import org.apache.iceberg.io.BulkDeletionFailureException;
import org.apache.iceberg.io.DelegateFileIO;
import org.apache.iceberg.io.FileInfo;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.io.PositionOutputStream;
import org.apache.iceberg.io.SeekableInputStream;
import org.apache.iceberg.io.StorageCredential;
import org.apache.iceberg.io.SupportsStorageCredentials;
import org.apache.iceberg.rest.ErrorHandlers;
import org.apache.iceberg.rest.HTTPClient;
import org.apache.iceberg.rest.HTTPRequest;
import org.apache.iceberg.rest.RESTClient;
import org.apache.iceberg.rest.ResourcePaths;
import org.apache.iceberg.rest.auth.AuthManager;
import org.apache.iceberg.rest.auth.AuthManagers;
import org.apache.iceberg.rest.auth.AuthSession;
import org.apache.iceberg.rest.jindo.DlfInnerFileIO;
import org.apache.iceberg.rest.jindo.JindoFileIO;
import org.apache.iceberg.rest.responses.LoadTableResponse;
import org.apache.iceberg.rest.util.AuthUtil;
import org.apache.iceberg.util.SerializableMap;
import org.apache.iceberg.util.SerializableSupplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import software.amazon.awssdk.utils.StringUtils;

public class DlfFileIO
implements HadoopConfigurable,
DelegateFileIO,
SupportsStorageCredentials {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = LoggerFactory.getLogger(DlfFileIO.class);
    private static final Cache<Map<String, String>, DelegateFileIO> FILE_IO_CACHE = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.MINUTES).maximumSize(1000L).removalListener(notification -> {
        if (notification.wasEvicted()) {
            LOG.info("DlfFileIO cache entry evicted: key = {}", AuthUtil.maskMap((Map)notification.getKey()));
            DelegateFileIO fileIO = (DelegateFileIO)notification.getValue();
            if (fileIO != null) {
                try {
                    fileIO.close();
                }
                catch (IOException e) {
                    LOG.warn("Failed to close cached FileIO", (Throwable)e);
                }
            }
        }
    }).build();
    private SerializableMap<String, String> properties = SerializableMap.copyOf(new HashMap());
    private SerializableMap<String, String> storageCredentialsMap = SerializableMap.copyOf(new HashMap());
    private List<StorageCredential> storageCredentials = new ArrayList<StorageCredential>();
    private volatile transient HTTPClient client = null;
    private volatile SerializableSupplier<Configuration> hadoopConf;

    public DlfFileIO() {
        this((SerializableSupplier<Configuration>)((SerializableSupplier)null));
    }

    public DlfFileIO(Configuration hadoopConf) {
        this((SerializableSupplier<Configuration>)((SerializableSupplier & Serializable)() -> ((SerializableConfiguration)new SerializableConfiguration(hadoopConf)).get()));
    }

    public DlfFileIO(SerializableSupplier<Configuration> hadoopConf) {
        this.hadoopConf = hadoopConf;
    }

    public void initialize(Map<String, String> props) {
        this.properties = SerializableMap.copyOf(props);
    }

    public InputFile newInputFile(String path) {
        return new DlfInputFile(this, path);
    }

    public InputFile newInputFile(String path, long length) {
        return new DlfInputFile(this, path, length);
    }

    public Map<String, String> properties() {
        return this.properties.immutableMap();
    }

    public OutputFile newOutputFile(String path) {
        return new DlfOutputFile(this, path);
    }

    public void deleteFile(String path) {
        this.fileIO().deleteFile(path);
    }

    public void deleteFiles(Iterable<String> pathsToDelete) throws BulkDeletionFailureException {
        this.fileIO().deleteFiles(pathsToDelete);
    }

    public Iterable<FileInfo> listPrefix(String prefix) {
        return this.fileIO().listPrefix(prefix);
    }

    public void deletePrefix(String prefix) {
        this.fileIO().deletePrefix(prefix);
    }

    public void setCredentials(List<StorageCredential> credentials) {
        Preconditions.checkArgument((credentials != null ? 1 : 0) != 0, (Object)"Invalid storage credentials: null");
        this.storageCredentials = Lists.newArrayList(credentials);
        this.storageCredentialsMap = this.storageCredentialConfig(credentials);
    }

    public List<StorageCredential> credentials() {
        return this.storageCredentials;
    }

    public void serializeConfWith(Function<Configuration, SerializableSupplier<Configuration>> confSerializer) {
        this.hadoopConf = confSerializer.apply(this.getConf());
    }

    public void setConf(Configuration conf) {
        this.hadoopConf = () -> ((SerializableConfiguration)new SerializableConfiguration(conf)).get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Configuration getConf() {
        if (this.hadoopConf == null) {
            DlfFileIO dlfFileIO = this;
            synchronized (dlfFileIO) {
                if (this.hadoopConf == null) {
                    this.hadoopConf = () -> ((SerializableConfiguration)new SerializableConfiguration(new Configuration())).get();
                }
            }
        }
        return (Configuration)this.hadoopConf.get();
    }

    public List<StorageCredential> validToken() {
        this.tryToRefreshToken();
        return this.storageCredentials;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DelegateFileIO fileIO() {
        this.tryToRefreshToken();
        DelegateFileIO fileIO = (DelegateFileIO)FILE_IO_CACHE.getIfPresent(this.storageCredentialsMap);
        if (fileIO != null) {
            return fileIO;
        }
        Cache<Map<String, String>, DelegateFileIO> cache = FILE_IO_CACHE;
        synchronized (cache) {
            fileIO = (DelegateFileIO)FILE_IO_CACHE.getIfPresent(this.storageCredentialsMap);
            if (fileIO != null) {
                return fileIO;
            }
            LOG.debug("Getting new FileIO for storage credentials with accessKeyId: {}", this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId") == null ? "unknown" : this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId"));
            fileIO = new JindoFileIO(this.getConf());
            if (fileIO instanceof SupportsStorageCredentials) {
                ((SupportsStorageCredentials)fileIO).setCredentials(this.storageCredentials);
            }
            fileIO.initialize(this.properties);
            FILE_IO_CACHE.put(this.storageCredentialsMap, (Object)fileIO);
            LOG.debug("Created new FileIO for storage credentials with accessKeyId: {}", this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId") == null ? "unknown" : this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId"));
            return fileIO;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryToRefreshToken() {
        if (this.shouldRefresh()) {
            DlfFileIO dlfFileIO = this;
            synchronized (dlfFileIO) {
                if (this.shouldRefresh()) {
                    this.refreshStorageCredentials();
                }
            }
        }
    }

    private boolean shouldRefresh() {
        String expirationString = (String)this.storageCredentialsMap.get((Object)"fs.oss.token.expiration");
        if (expirationString == null) {
            LOG.info("token expiration is null, should refresh storage credentials");
            return true;
        }
        long expiration = Long.parseLong(expirationString);
        if (expiration - System.currentTimeMillis() < 3600000L) {
            LOG.info("token expiration is less than {} milliseconds, should refresh storage credentials {}", (Object)3600000L, this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId") == null ? "unknown" : this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId"));
            return true;
        }
        return false;
    }

    private void refreshStorageCredentials() {
        String tableNamespace = (String)this.storageCredentialsMap.get((Object)"fs.oss.token.table.namespace");
        String tableName = (String)this.storageCredentialsMap.get((Object)"fs.oss.token.table.name");
        if (StringUtils.isBlank((CharSequence)tableNamespace) || StringUtils.isBlank((CharSequence)tableName)) {
            LOG.warn("namespace or tableName is blank, skip refresh storage credentials");
            return;
        }
        Namespace namespace = Namespace.of((String[])new String[]{tableNamespace});
        TableIdentifier identifier = TableIdentifier.of((Namespace)namespace, (String)tableName);
        LOG.info("start to refresh storage credential for table: {}", (Object)identifier);
        LoadTableResponse response = null;
        try {
            response = this.getTable(identifier);
        }
        catch (NoSuchTableException original) {
            MetadataTableType metadataType = MetadataTableType.from((String)identifier.name());
            if (metadataType != null) {
                TableIdentifier baseIdent = TableIdentifier.of((String[])identifier.namespace().levels());
                try {
                    response = this.getTable(baseIdent);
                }
                catch (NoSuchTableException ignored) {
                    throw original;
                }
            }
            LOG.warn("refresh storage credentials for table: {} failed, the table does not exist.", (Object)identifier);
        }
        catch (Exception e) {
            LOG.warn("refresh storage credentials for table: {} failed with error message: {} ", (Object)identifier, (Object)e.getMessage());
        }
        if (null == response || null == response.credentials()) {
            LOG.warn("refresh storage credentials for table: {} failed, response is null", (Object)identifier);
            return;
        }
        List credentials = response.credentials();
        this.storageCredentials = credentials.stream().map(c -> StorageCredential.create((String)c.prefix(), (Map)c.config())).collect(Collectors.toList());
        this.storageCredentialsMap = this.storageCredentialConfig(this.storageCredentials);
        LOG.info("successfully refreshed storage credential for table: {}, accessKeyId: {}", (Object)identifier, this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId") == null ? "unknown" : this.storageCredentialsMap.get((Object)"fs.oss.accessKeyId"));
    }

    private LoadTableResponse getTable(TableIdentifier identifier) {
        long startTime = System.nanoTime();
        ResourcePaths paths = ResourcePaths.forCatalogProperties(this.properties);
        HashMap headers = new HashMap();
        String uri = (String)this.properties.get((Object)"uri");
        HTTPClient httpClient = this.httpClient(uri);
        String path = paths.table(identifier);
        HTTPRequest request = httpClient.buildRequest(HTTPRequest.HTTPMethod.GET, path, (Map)ImmutableMap.of(), headers, null);
        Consumer<Map> responseHeaders = map -> {
            long durationMs = (System.nanoTime() - startTime) / 1000000L;
            String requestId = (String)map.get("x-request-id");
            if (requestId == null || requestId.isEmpty()) {
                requestId = "unknown";
            }
            LOG.info("[iceberg rest] requestId: {}, method: {}, url: {}, duration: {}ms", new Object[]{requestId, request.method(), uri == null ? path : uri + path, durationMs});
        };
        LoadTableResponse response = (LoadTableResponse)httpClient.execute(request, LoadTableResponse.class, ErrorHandlers.tableErrorHandler(), responseHeaders);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HTTPClient httpClient(String uri) {
        if (null == this.client) {
            DlfFileIO dlfFileIO = this;
            synchronized (dlfFileIO) {
                if (null == this.client) {
                    long startTime = System.nanoTime();
                    LOG.debug("Getting new HTTPClient for uri: {}", (Object)uri);
                    AuthManager authManager = AuthManagers.loadAuthManager((String)"dlf-credentials-refresh", this.properties);
                    HTTPClient httpClient = HTTPClient.builder(this.properties).uri(uri).build();
                    AuthSession authSession = authManager.catalogSession((RESTClient)httpClient, this.properties);
                    this.client = httpClient.withAuthSession(authSession);
                    long durationMs = (System.nanoTime() - startTime) / 1000000L;
                    LOG.debug("Get new HTTPClient for uri: {} success, duration: {}ms", (Object)uri, (Object)durationMs);
                }
            }
        }
        return this.client;
    }

    private SerializableMap<String, String> storageCredentialConfig(List<StorageCredential> credentials) {
        if (credentials == null) {
            return SerializableMap.copyOf(new HashMap());
        }
        Map<String, String> credentialsMap = credentials.stream().map(StorageCredential::config).flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (existing, replacement) -> replacement));
        return SerializableMap.copyOf(credentialsMap);
    }

    private static class DlfOutputFile
    implements OutputFile {
        private final DlfFileIO fileIO;
        private final String path;

        public DlfOutputFile(DlfFileIO fileIO, String path) {
            this.fileIO = fileIO;
            this.path = path;
        }

        public PositionOutputStream create() {
            DelegateFileIO io = this.fileIO.fileIO();
            if (io instanceof DlfInnerFileIO) {
                return ((DlfInnerFileIO)io).newOutStream(this.path, false);
            }
            return io.newOutputFile(this.path).create();
        }

        public PositionOutputStream createOrOverwrite() {
            DelegateFileIO io = this.fileIO.fileIO();
            if (io instanceof DlfInnerFileIO) {
                return ((DlfInnerFileIO)io).newOutStream(this.path, true);
            }
            return io.newOutputFile(this.path).createOrOverwrite();
        }

        public String location() {
            return this.path;
        }

        public InputFile toInputFile() {
            return this.fileIO.fileIO().newInputFile(this.path);
        }
    }

    private static class DlfInputFile
    implements InputFile {
        private final DlfFileIO fileIO;
        private final String path;
        private Boolean exists = null;
        private Long length = null;

        public DlfInputFile(DlfFileIO fileIO, String path) {
            this.fileIO = fileIO;
            this.path = path;
        }

        public DlfInputFile(DlfFileIO fileIO, String path, long length) {
            this.fileIO = fileIO;
            this.path = path;
            this.length = length;
        }

        public SeekableInputStream newStream() {
            DelegateFileIO io = this.fileIO.fileIO();
            if (io instanceof DlfInnerFileIO) {
                return ((DlfInnerFileIO)io).newInStream(this.path);
            }
            return this.fileIO.fileIO().newInputFile(this.path).newStream();
        }

        public long getLength() {
            if (this.length == null) {
                this.length = this.fileIO.fileIO().newInputFile(this.path).getLength();
            }
            return this.length;
        }

        public boolean exists() {
            if (this.exists != null) {
                this.exists = this.fileIO.fileIO().newInputFile(this.path).exists();
            }
            return this.exists;
        }

        public String location() {
            return this.path;
        }
    }
}

