# Dataphin JDBC

## 版本

````
 Version:        5.3.0
 ReleaseDate:    2025-08-04
 GitCommit:      b766cf1f86be63642abfc901351dd652885861ae
````

## Release Note

### v5.3.0
- Maxcompute SQL，Hive、Impala、Spark SQL可以使用SelectDB，Doris，Starrocks加速源加速查询
- 使用方法：
  - Dataphin上先配置加速源，jdbc url中指定加速源code和加速源资源组，如：acceleration_source=code&acceleration_resource_group=rg

### v5.2.0
- 支持使用平台AK时，使用set语句切换当前Session用户
- 使用方法：
  - set dp_delegation_uid = '229372341924692767'; 
  - set dp_delegation_name = 'SuperAdmin@dataphin';

### v5.1.0
- 支持以ds_开头的项目名称

### v4.4.4
- 支持catalog指定为业务板块，当catalog为业务板块时支持指定计算项目
- 支持反向VPC连接

### v4.4.0
- 支持数据源类型Hive

### v4.3.0

- 支持数据库Mysql,Oracle
- 支持行级权限
- 支持Result分批获取

## 连接参数说明

url格式：

```
jdbc:dataphin://host:port/catalog?[currentschema=schema][&user=UserName][&password=PassWord][&tenant_id=TenantID][&delegation_uid=UserName][&engine=spark][&log_level=debug][&connect_timeout=20][&ssl=true][&acceleration_source=starrocksCode]
```

| 参数名称            | 说明                                                                         |
|-----------------|:---------------------------------------------------------------------------|
| host            | dataphin openapi 域名                                                        |
| port            | 端口号，默认为80，该端口会根据ssl参数动态调整，如果ssl=true，则端口为443                               |
| catalog         | dataphin catalog，如果使用某个项目则为项目英文名；如果使用物理数据源则为物理数据源code，4.4.4版本后支持业务板块       |
| username        | Dataphin平台的AccessKey ID，或Dataphin个人用户的AccessKey ID                         |
| password        | Dataphin平台的SecurityKey，或Dataphin个人用户的SecurityKey                           |
| currentschema   | 物理数据源的schema，如pg数据库，可以指定schema，如果数据库没schema的概念则忽略                          |
| current_schema  | 兼容currentschema参数                                                          |
| tenant_id       | 租户ID，主要用于多引擎多租户的场景                                                         |
| delegation_uid  | 代理用户id或者名称（为SSO系统原始ID或者名称），使用平台AK可代理某个用户进行SQL执行                            |
| account_type    | delegation_uid的账号类型，source_user_id表示用户sourceId；account_name表示用户名称          |
| engine          | 指定SQL执行引擎类型，如果计算源是Hadoop类型且计算源上配置了Impala或者spark，engine可选为hive，impala，spark |
| ssl             | 是否开启ssl,如果开启使用https协议，否则使用http协议                                           |
| log_level       | 日志级别，支持debug,info,warn,error                                               |
| connect_timeout | 连接超时时间，单位秒                                                                 |
| compute_project | 当catalog设置为业务板块时，需要指定计算项目，如果没有指定默认使用分析平台项目                                 |
| proxy_server    | 当需要反向VPC打通或者其他代理场景时，需要指定代理服务器                                              |
| proxy_port      | 配合proxy_server指定代理端口                                                       |
| acceleration_source | 加速源code                                                                    |
| acceleration_resource_group        | 加速源资源组                                                                     |

## 使用示例

### Maven

如果要使用Maven，请添加如下依赖，目前dataphin-jdbc驱动暂未上传到公共仓库，需要手动下载并导入本地maven仓库。

```xml

<dependencies>
    <dependency>
        <groupId>com.aliyun.dataphin</groupId>
        <artifactId>dataphin-jdbc</artifactId>
        <version>${version}</version>
    </dependency>
</dependencies>

```

### Java

```java
public class DataphinJdbcTest {
    public static void main(String[] args) throws Exception {
        String url = "jdbc:dataphin://host:port/catalog?[&tenant_id=TenantID][&ssl=true]";
        String username = "xxxxxx";
        String password = "xxxxxx";
        Class.forName("com.aliyun.dataphin.jdbc.DataphinDriver");
        try (Connection conn = DriverManager.getConnection(url, username, password);
             Statement statement = conn.createStatement()) {

            //query timeout 需要小于60s
            statement.setQueryTimeout(30000);
            String querySql = "select * from data_share_test.data_share_table1 limit 10;";
            ResultSet resultSet = statement.executeQuery(querySql);
            while (resultSet.next()) {
                System.out.print("Column 1 returned ");
                System.out.println(resultSet.getString(1));
            }
            ResultSetPrinter.printResultSet(resultSet);
            resultSet.close();
        }
    }
}
```

### 数据库管理工具

```
如果要使用Datagrip、DBeaver等数据库管理工具连接Dataphin，需要先在Dataphin中创建物理数据源或项目，并配置好连接信息。
然后下载Dataphin-JDBC驱动包，在工具中添加驱动，并选择对应的物理数据源。
```