/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.picnic;

import org.bouncycastle.pqc.crypto.picnic.KMatricesWithPointer;
import org.bouncycastle.pqc.crypto.picnic.LowmcConstants;
import org.bouncycastle.pqc.crypto.picnic.PicnicEngine;
import org.bouncycastle.pqc.crypto.picnic.Utils;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

class Tape {
    byte[][] tapes;
    int pos;
    int nTapes;
    private PicnicEngine engine;

    public Tape(PicnicEngine picnicEngine) {
        this.engine = picnicEngine;
        this.tapes = new byte[picnicEngine.numMPCParties][2 * picnicEngine.andSizeBytes];
        this.pos = 0;
        this.nTapes = picnicEngine.numMPCParties;
    }

    protected void setAuxBits(byte[] byArray) {
        int n = this.engine.numMPCParties - 1;
        int n2 = 0;
        int n3 = this.engine.stateSizeBits;
        for (int i = 0; i < this.engine.numRounds; ++i) {
            for (int j = 0; j < n3; ++j) {
                Utils.setBit(this.tapes[n], n3 + n3 * 2 * i + j, Utils.getBit(byArray, n2++));
            }
        }
    }

    protected void computeAuxTape(byte[] byArray) {
        int[] nArray = new int[16];
        int[] nArray2 = new int[16];
        int[] nArray3 = new int[16];
        int[] nArray4 = new int[16];
        int[] nArray5 = new int[16];
        nArray5[this.engine.stateSizeWords - 1] = 0;
        this.tapesToParityBits(nArray5, this.engine.stateSizeBits);
        KMatricesWithPointer kMatricesWithPointer = LowmcConstants.KMatrixInv(this.engine);
        this.engine.matrix_mul(nArray4, nArray5, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
        if (byArray != null) {
            Pack.intToLittleEndian(Arrays.copyOf(nArray4, this.engine.stateSizeWords), byArray, 0);
        }
        for (int i = this.engine.numRounds; i > 0; --i) {
            kMatricesWithPointer = LowmcConstants.KMatrix(this.engine, i);
            this.engine.matrix_mul(nArray, nArray4, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
            this.engine.xor_array(nArray2, nArray2, nArray, 0, this.engine.stateSizeWords);
            kMatricesWithPointer = LowmcConstants.LMatrixInv(this.engine, i - 1);
            this.engine.matrix_mul(nArray3, nArray2, kMatricesWithPointer.getData(), kMatricesWithPointer.getMatrixPointer());
            if (i == 1) {
                System.arraycopy(nArray5, 0, nArray2, 0, nArray5.length);
            } else {
                this.pos = this.engine.stateSizeBits * 2 * (i - 1);
                this.tapesToParityBits(nArray2, this.engine.stateSizeBits);
            }
            this.pos = this.engine.stateSizeBits * 2 * (i - 1) + this.engine.stateSizeBits;
            this.engine.aux_mpc_sbox(nArray2, nArray3, this);
        }
        this.pos = 0;
    }

    private void tapesToParityBits(int[] nArray, int n) {
        for (int i = 0; i < n; ++i) {
            Utils.setBitInWordArray(nArray, i, Utils.parity16(this.tapesToWord()));
        }
    }

    protected int tapesToWord() {
        byte[] byArray = new byte[4];
        for (int i = 0; i < 16; ++i) {
            byte by = Utils.getBit(this.tapes[i], this.pos);
            Utils.setBit(byArray, i, by);
        }
        ++this.pos;
        return Pack.littleEndianToInt(byArray, 0);
    }
}

