/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.bike;

import java.security.SecureRandom;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.pqc.crypto.bike.BIKERandomGenerator;
import org.bouncycastle.pqc.crypto.bike.Utils;
import org.bouncycastle.pqc.math.linearalgebra.GF2mField;
import org.bouncycastle.pqc.math.linearalgebra.PolynomialGF2mSmallM;
import org.bouncycastle.util.Arrays;

class BIKEEngine {
    private int r;
    private int w;
    private int hw;
    private int t;
    private int l;
    private int nbIter;
    private int tau;
    private GF2mField field;
    private final PolynomialGF2mSmallM reductionPoly;
    private int L_BYTE;
    private int R_BYTE;

    public BIKEEngine(int n, int n2, int n3, int n4, int n5, int n6) {
        GF2mField gF2mField;
        this.r = n;
        this.w = n2;
        this.t = n3;
        this.l = n4;
        this.nbIter = n5;
        this.tau = n6;
        this.hw = this.w / 2;
        this.L_BYTE = n4 / 8;
        this.R_BYTE = (n + 7) / 8;
        this.field = gF2mField = new GF2mField(1);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(gF2mField, n);
        this.reductionPoly = polynomialGF2mSmallM.addMonomial(0);
    }

    public int getSessionKeySize() {
        return this.L_BYTE;
    }

    private byte[] functionH(byte[] byArray) {
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray, 0, byArray.length);
        byte[] byArray2 = BIKERandomGenerator.generateRandomByteArray(this.r * 2, 2 * this.R_BYTE, this.t, sHAKEDigest);
        return byArray2;
    }

    private byte[] functionL(byte[] byArray, byte[] byArray2) {
        byte[] byArray3 = new byte[48];
        byte[] byArray4 = new byte[this.L_BYTE];
        SHA3Digest sHA3Digest = new SHA3Digest(384);
        sHA3Digest.update(byArray, 0, byArray.length);
        sHA3Digest.update(byArray2, 0, byArray2.length);
        sHA3Digest.doFinal(byArray3, 0);
        System.arraycopy(byArray3, 0, byArray4, 0, this.L_BYTE);
        return byArray4;
    }

    private byte[] functionK(byte[] byArray, byte[] byArray2, byte[] byArray3) {
        byte[] byArray4 = new byte[48];
        byte[] byArray5 = new byte[this.L_BYTE];
        SHA3Digest sHA3Digest = new SHA3Digest(384);
        sHA3Digest.update(byArray, 0, byArray.length);
        sHA3Digest.update(byArray2, 0, byArray2.length);
        sHA3Digest.update(byArray3, 0, byArray3.length);
        sHA3Digest.doFinal(byArray4, 0);
        System.arraycopy(byArray4, 0, byArray5, 0, this.L_BYTE);
        return byArray5;
    }

    public void genKeyPair(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, SecureRandom secureRandom) {
        byte[] byArray5 = new byte[64];
        secureRandom.nextBytes(byArray5);
        byte[] byArray6 = new byte[this.L_BYTE];
        byte[] byArray7 = new byte[this.L_BYTE];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
        System.arraycopy(byArray5, byArray6.length, byArray7, 0, byArray7.length);
        SHAKEDigest sHAKEDigest = new SHAKEDigest(256);
        sHAKEDigest.update(byArray6, 0, byArray6.length);
        byte[] byArray8 = BIKERandomGenerator.generateRandomByteArray(this.r, this.R_BYTE, this.hw, sHAKEDigest);
        byte[] byArray9 = BIKERandomGenerator.generateRandomByteArray(this.r, this.R_BYTE, this.hw, sHAKEDigest);
        System.arraycopy(byArray8, 0, byArray, 0, byArray.length);
        System.arraycopy(byArray9, 0, byArray2, 0, byArray2.length);
        byte[] byArray10 = new byte[this.r];
        byte[] byArray11 = new byte[this.r];
        Utils.fromByteArrayToBitArray(byArray11, byArray8);
        Utils.fromByteArrayToBitArray(byArray10, byArray9);
        byte[] byArray12 = Utils.removeLast0Bits(byArray11);
        byte[] byArray13 = Utils.removeLast0Bits(byArray10);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, byArray12);
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, byArray13);
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM.modInverseBigDeg(this.reductionPoly);
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM2.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM3, this.reductionPoly);
        byte[] byArray14 = polynomialGF2mSmallM4.getEncoded();
        byte[] byArray15 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray15, byArray14);
        System.arraycopy(byArray15, 0, byArray4, 0, byArray4.length);
        System.arraycopy(byArray7, 0, byArray3, 0, byArray3.length);
    }

    public void encaps(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, SecureRandom secureRandom) {
        byte[] byArray5 = new byte[64];
        secureRandom.nextBytes(byArray5);
        byte[] byArray6 = new byte[this.L_BYTE];
        System.arraycopy(byArray5, 0, byArray6, 0, byArray6.length);
        byte[] byArray7 = this.functionH(byArray6);
        byte[] byArray8 = new byte[2 * this.r];
        Utils.fromByteArrayToBitArray(byArray8, byArray7);
        byte[] byArray9 = Arrays.copyOfRange(byArray8, 0, this.r);
        byte[] byArray10 = Arrays.copyOfRange(byArray8, this.r, byArray8.length);
        byte[] byArray11 = Utils.removeLast0Bits(byArray9);
        byte[] byArray12 = Utils.removeLast0Bits(byArray10);
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, byArray11);
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, byArray12);
        byte[] byArray13 = new byte[this.r];
        Utils.fromByteArrayToBitArray(byArray13, byArray4);
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = new PolynomialGF2mSmallM(this.field, Utils.removeLast0Bits(byArray13));
        PolynomialGF2mSmallM polynomialGF2mSmallM4 = polynomialGF2mSmallM.add(polynomialGF2mSmallM2.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM3, this.reductionPoly));
        byte[] byArray14 = polynomialGF2mSmallM4.getEncoded();
        byte[] byArray15 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray15, byArray14);
        System.arraycopy(byArray15, 0, byArray, 0, byArray.length);
        byte[] byArray16 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray16, byArray9);
        byte[] byArray17 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray17, byArray10);
        byte[] byArray18 = this.functionL(byArray16, byArray17);
        byte[] byArray19 = Utils.xorBytes(byArray6, byArray18, this.L_BYTE);
        System.arraycopy(byArray19, 0, byArray2, 0, byArray2.length);
        byte[] byArray20 = this.functionK(byArray6, byArray, byArray2);
        System.arraycopy(byArray20, 0, byArray3, 0, byArray20.length);
    }

    public void decaps(byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4, byte[] byArray5, byte[] byArray6) {
        byte[] byArray7 = new byte[this.r];
        byte[] byArray8 = new byte[this.r];
        byte[] byArray9 = new byte[this.l];
        Utils.fromByteArrayToBitArray(byArray7, byArray5);
        Utils.fromByteArrayToBitArray(byArray8, byArray2);
        Utils.fromByteArrayToBitArray(byArray9, byArray4);
        byte[] byArray10 = Utils.removeLast0Bits(byArray7);
        byte[] byArray11 = Utils.removeLast0Bits(byArray8);
        int[] nArray = new int[this.hw];
        int[] nArray2 = new int[this.hw];
        this.convertToCompact(nArray, byArray2);
        this.convertToCompact(nArray2, byArray3);
        byte[] byArray12 = this.computeSyndrome(byArray10, byArray11);
        byte[] byArray13 = this.BGFDecoder(byArray12, nArray, nArray2);
        byte[] byArray14 = new byte[2 * this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray14, byArray13);
        byte[] byArray15 = Arrays.copyOfRange(byArray13, 0, this.r);
        byte[] byArray16 = Arrays.copyOfRange(byArray13, this.r, byArray13.length);
        byte[] byArray17 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray17, byArray15);
        byte[] byArray18 = new byte[this.R_BYTE];
        Utils.fromBitArrayToByteArray(byArray18, byArray16);
        byte[] byArray19 = Utils.xorBytes(byArray6, this.functionL(byArray17, byArray18), this.L_BYTE);
        byte[] byArray20 = new byte[this.l];
        byte[] byArray21 = this.functionH(byArray19);
        byArray20 = Arrays.areEqual(byArray14, byArray21) ? this.functionK(byArray19, byArray5, byArray6) : this.functionK(byArray4, byArray5, byArray6);
        System.arraycopy(byArray20, 0, byArray, 0, byArray20.length);
    }

    private byte[] computeSyndrome(byte[] byArray, byte[] byArray2) {
        PolynomialGF2mSmallM polynomialGF2mSmallM = new PolynomialGF2mSmallM(this.field, byArray2);
        PolynomialGF2mSmallM polynomialGF2mSmallM2 = new PolynomialGF2mSmallM(this.field, byArray);
        PolynomialGF2mSmallM polynomialGF2mSmallM3 = polynomialGF2mSmallM.modKaratsubaMultiplyBigDeg(polynomialGF2mSmallM2, this.reductionPoly);
        byte[] byArray3 = this.transpose(polynomialGF2mSmallM3.getEncoded());
        return byArray3;
    }

    private byte[] BGFDecoder(byte[] byArray, int[] nArray, int[] nArray2) {
        byte[] byArray2 = new byte[2 * this.r];
        int[] nArray3 = this.getColumnFromCompactVersion(nArray);
        int[] nArray4 = this.getColumnFromCompactVersion(nArray2);
        for (int i = 1; i <= this.nbIter; ++i) {
            byte[] byArray3 = new byte[2 * this.r];
            byte[] byArray4 = new byte[2 * this.r];
            int n = this.threshold(Utils.getHammingWeight(byArray), i, this.r);
            this.BFIter(byArray, byArray2, n, nArray, nArray2, nArray3, nArray4, byArray3, byArray4);
            if (i != 1) continue;
            this.BFMaskedIter(byArray, byArray2, byArray3, (this.hw + 1) / 2 + 1, nArray, nArray2, nArray3, nArray4);
            this.BFMaskedIter(byArray, byArray2, byArray4, (this.hw + 1) / 2 + 1, nArray, nArray2, nArray3, nArray4);
        }
        if (Utils.getHammingWeight(byArray) == 0) {
            return byArray2;
        }
        return null;
    }

    private byte[] transpose(byte[] byArray) {
        byte[] byArray2 = Utils.append0s(byArray, this.r);
        byte[] byArray3 = new byte[this.r];
        byArray3[0] = byArray2[0];
        for (int i = 1; i < this.r; ++i) {
            byArray3[i] = byArray2[this.r - i];
        }
        return byArray3;
    }

    private void BFIter(byte[] byArray, byte[] byArray2, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4, byte[] byArray3, byte[] byArray4) {
        int n2;
        int[] nArray5 = new int[2 * this.r];
        for (n2 = 0; n2 < this.r; ++n2) {
            if (this.ctr(nArray3, byArray, n2) >= n) {
                this.updateNewErrorIndex(byArray2, n2);
                nArray5[n2] = 1;
                byArray3[n2] = 1;
                continue;
            }
            if (this.ctr(nArray3, byArray, n2) < n - this.tau) continue;
            byArray4[n2] = 1;
        }
        for (n2 = 0; n2 < this.r; ++n2) {
            if (this.ctr(nArray4, byArray, n2) >= n) {
                this.updateNewErrorIndex(byArray2, this.r + n2);
                nArray5[this.r + n2] = 1;
                byArray3[this.r + n2] = 1;
                continue;
            }
            if (this.ctr(nArray4, byArray, n2) < n - this.tau) continue;
            byArray4[this.r + n2] = 1;
        }
        for (n2 = 0; n2 < 2 * this.r; ++n2) {
            if (nArray5[n2] != 1) continue;
            this.recomputeSyndrome(byArray, n2, nArray, nArray2);
        }
    }

    private void BFMaskedIter(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n2;
        int[] nArray5 = new int[2 * this.r];
        for (n2 = 0; n2 < this.r; ++n2) {
            if (this.ctr(nArray3, byArray, n2) < n || byArray3[n2] != 1) continue;
            this.updateNewErrorIndex(byArray2, n2);
            nArray5[n2] = 1;
        }
        for (n2 = 0; n2 < this.r; ++n2) {
            if (this.ctr(nArray4, byArray, n2) < n || byArray3[this.r + n2] != 1) continue;
            this.updateNewErrorIndex(byArray2, this.r + n2);
            nArray5[this.r + n2] = 1;
        }
        for (n2 = 0; n2 < 2 * this.r; ++n2) {
            if (nArray5[n2] != 1) continue;
            this.recomputeSyndrome(byArray, n2, nArray, nArray2);
        }
    }

    private int threshold(int n, int n2, int n3) {
        double d = 0.0;
        int n4 = 0;
        int n5 = 0;
        switch (n3) {
            case 12323: {
                d = 0.0069722 * (double)n + 13.53;
                n4 = (int)Math.floor(d);
                n5 = n4 > 36 ? n4 : 36;
                break;
            }
            case 24659: {
                d = 0.005265 * (double)n + 15.2588;
                n4 = (int)Math.floor(d);
                n5 = n4 > 52 ? n4 : 52;
                break;
            }
            case 40973: {
                d = 0.00402312 * (double)n + 17.8785;
                n4 = (int)Math.floor(d);
                n5 = n4 > 69 ? n4 : 69;
            }
        }
        return n5;
    }

    private int ctr(int[] nArray, byte[] byArray, int n) {
        int n2 = 0;
        for (int i = 0; i < this.hw; ++i) {
            if (byArray[(nArray[i] + n) % this.r] != 1) continue;
            ++n2;
        }
        return n2;
    }

    private void convertToCompact(int[] nArray, byte[] byArray) {
        int n = 0;
        for (int i = 0; i < this.R_BYTE; ++i) {
            for (int j = 0; j < 8 && i * 8 + j != this.r; ++j) {
                if ((byArray[i] >> j & 1) != 1) continue;
                nArray[n++] = i * 8 + j;
            }
        }
    }

    private int[] getColumnFromCompactVersion(int[] nArray) {
        int[] nArray2 = new int[this.hw];
        if (nArray[0] == 0) {
            nArray2[0] = 0;
            for (int i = 1; i < this.hw; ++i) {
                nArray2[i] = this.r - nArray[this.hw - i];
            }
        } else {
            for (int i = 0; i < this.hw; ++i) {
                nArray2[i] = this.r - nArray[this.hw - 1 - i];
            }
        }
        return nArray2;
    }

    private void recomputeSyndrome(byte[] byArray, int n, int[] nArray, int[] nArray2) {
        if (n < this.r) {
            for (int i = 0; i < this.hw; ++i) {
                if (nArray[i] <= n) {
                    int n2 = n - nArray[i];
                    byArray[n2] = (byte)(byArray[n2] ^ 1);
                    continue;
                }
                int n3 = this.r + n - nArray[i];
                byArray[n3] = (byte)(byArray[n3] ^ 1);
            }
        } else {
            for (int i = 0; i < this.hw; ++i) {
                if (nArray2[i] <= n - this.r) {
                    int n4 = n - this.r - nArray2[i];
                    byArray[n4] = (byte)(byArray[n4] ^ 1);
                    continue;
                }
                int n5 = this.r - nArray2[i] + (n - this.r);
                byArray[n5] = (byte)(byArray[n5] ^ 1);
            }
        }
    }

    private void updateNewErrorIndex(byte[] byArray, int n) {
        int n2 = n;
        if (n != 0 && n != this.r) {
            n2 = n > this.r ? 2 * this.r - n + this.r : this.r - n;
        }
        int n3 = n2;
        byArray[n3] = (byte)(byArray[n3] ^ 1);
    }
}

