/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.endpoint;

import com.aliyuncs.endpoint.EndpointResolverBase;
import com.aliyuncs.endpoint.ResolveEndpointRequest;
import com.dp.google.gson.JsonArray;
import com.dp.google.gson.JsonElement;
import com.dp.google.gson.JsonObject;
import com.dp.google.gson.JsonParser;
import java.io.InputStream;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;

public class LocalConfigRegionalEndpointResolver
extends EndpointResolverBase {
    protected static final String ENDPOINT_JSON = "endpoints.json";
    private Set<String> validRegionIds = new HashSet<String>();
    private Map<String, String> locationCodeMapping = new HashMap<String, String>();
    private JsonObject regionalEndpointData;
    protected static final JsonObject ENDPOINTS_JSON;

    public LocalConfigRegionalEndpointResolver() {
        this.initLocalConfig(ENDPOINTS_JSON);
    }

    public LocalConfigRegionalEndpointResolver(String configJsonStr) {
        JsonObject obj = new JsonParser().parse(configJsonStr).getAsJsonObject();
        this.initLocalConfig(obj);
    }

    private void initLocalConfig(JsonObject obj) {
        this.initRegionalEndpointData(obj);
        this.initRegionIds(obj);
        this.initLocationCodeMapping(obj);
    }

    private void initRegionalEndpointData(JsonObject obj) {
        if (!obj.has("regional_endpoints")) {
            return;
        }
        this.regionalEndpointData = obj.get("regional_endpoints").getAsJsonObject();
        JsonObject regionalEndpoints = obj.get("regional_endpoints").getAsJsonObject();
        HashSet<String> regionalEndpointsKeySet = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : regionalEndpoints.entrySet()) {
            regionalEndpointsKeySet.add(entry.getKey());
        }
        for (String normalizedProductCode : regionalEndpointsKeySet) {
            JsonObject productData = regionalEndpoints.get(normalizedProductCode).getAsJsonObject();
            HashSet<String> productDataKeySet = new HashSet<String>();
            for (Map.Entry<String, JsonElement> entry : productData.entrySet()) {
                productDataKeySet.add(entry.getKey());
            }
            for (String regionId : productDataKeySet) {
                String endpoint = productData.get(regionId).getAsString();
                this.putEndpointEntry(this.makeEndpointKey(normalizedProductCode, regionId), endpoint);
            }
        }
    }

    protected void initRegionIds(JsonObject obj) {
        if (!obj.has("regions")) {
            return;
        }
        JsonArray regions = obj.get("regions").getAsJsonArray();
        for (JsonElement regionData : regions) {
            this.validRegionIds.add(regionData.getAsString());
        }
    }

    protected void initLocationCodeMapping(JsonObject obj) {
        if (!obj.has("location_code_mapping")) {
            return;
        }
        JsonObject mappingData = obj.get("location_code_mapping").getAsJsonObject();
        HashSet<String> keySet = new HashSet<String>();
        for (Map.Entry<String, JsonElement> entry : mappingData.entrySet()) {
            keySet.add(entry.getKey());
        }
        for (String productCode : keySet) {
            String locationServiceCode = mappingData.get(productCode).getAsString();
            this.locationCodeMapping.put(productCode, locationServiceCode);
        }
    }

    protected String getNormalizedProductCode(String productCode) {
        String productCodeLower = productCode.toLowerCase();
        if (this.locationCodeMapping.containsKey(productCodeLower)) {
            return this.locationCodeMapping.get(productCodeLower);
        }
        return productCodeLower;
    }

    @Override
    public String resolve(ResolveEndpointRequest request) {
        if (request.isOpenApiEndpoint()) {
            return this.fetchEndpointEntry(request);
        }
        return null;
    }

    @Override
    public String makeEndpointKey(ResolveEndpointRequest request) {
        return this.makeEndpointKey(request.productCodeLower, request.regionId);
    }

    public String makeEndpointKey(String productCodeLower, String regionId) {
        return this.getNormalizedProductCode(productCodeLower) + "." + regionId.toLowerCase();
    }

    @Override
    public boolean isRegionIdValid(ResolveEndpointRequest request) {
        return this.validRegionIds.contains(request.regionId);
    }

    @Override
    public Set<String> getValidRegionIdsByProduct(String productCodeLower) {
        String code = this.getNormalizedProductCode(productCodeLower);
        if (this.regionalEndpointData != null && this.regionalEndpointData.has(code)) {
            JsonObject regionalEndpoints = this.regionalEndpointData.get(code).getAsJsonObject();
            HashSet<String> validRegionIdsByProduct = new HashSet<String>();
            for (Map.Entry<String, JsonElement> entry : regionalEndpoints.entrySet()) {
                validRegionIdsByProduct.add(entry.getKey());
            }
            return validRegionIdsByProduct;
        }
        return null;
    }

    @Override
    public boolean isProductCodeValid(ResolveEndpointRequest request) {
        ResolveEndpointRequest request2 = new ResolveEndpointRequest(request.regionId, this.getNormalizedProductCode(request.productCode), null, null);
        return super.isProductCodeValid(request2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Scanner scanner = null;
        try {
            ClassLoader classLoader = LocalConfigRegionalEndpointResolver.class.getClassLoader();
            InputStream is = classLoader.getResourceAsStream(ENDPOINT_JSON);
            scanner = new Scanner(is, "UTF-8");
            scanner.useDelimiter("\u0000");
            String jsonStr = scanner.hasNext() ? scanner.next() : "";
            ENDPOINTS_JSON = new JsonParser().parse(jsonStr).getAsJsonObject();
        }
        finally {
            if (null != scanner) {
                scanner.close();
            }
        }
    }
}

