/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.dataphin.util;

public abstract class StringUtils {
    public static String join(Iterable<?> items, String separator, int limit) {
        if (null == items) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (Integer.MAX_VALUE == limit) {
            for (Object x : items) {
                builder.append(x).append(separator);
            }
        } else {
            int n = 0;
            for (Object x : items) {
                if (n >= limit) {
                    builder.append("...").append(separator);
                    break;
                }
                builder.append(x).append(separator);
                ++n;
            }
        }
        return builder.length() > 0 ? builder.toString().substring(0, builder.length() - separator.length()) : builder.toString();
    }

    public static String join(Iterable<?> items, String separator) {
        return StringUtils.join(items, separator, Integer.MAX_VALUE);
    }

    public static String joinWithComma(Iterable<?> items) {
        return StringUtils.join(items, ",");
    }

    public static String joinWithComma(Iterable<?> items, int limit) {
        return StringUtils.join(items, ",", limit);
    }

    public static boolean isEmpty(String str) {
        return null == str || str.isEmpty();
    }

    public static boolean isTrimmedEmpty(String str) {
        return StringUtils.isEmpty(str) || str.trim().isEmpty();
    }

    public static boolean notEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static int searchInList(String list, String pattern) {
        if (null == list || list.isEmpty()) {
            return -1;
        }
        int patternLength = pattern.length();
        int runLength = list.length();
        int start = 0;
        while (start < runLength) {
            int p = list.indexOf(pattern, start);
            if (p >= 0) {
                if (!(0 != start && list.charAt(start - 1) != ',' || p + patternLength < runLength && list.charAt(p + patternLength) != ',')) {
                    return p;
                }
            } else {
                return -1;
            }
            start = p + patternLength + 1;
        }
        return -1;
    }

    public static boolean matchInList(String list, String pattern) {
        return StringUtils.searchInList(list, pattern) >= 0;
    }

    public static boolean listCrossMatch(String list1, String list2) {
        if (StringUtils.isEmpty(list1) || StringUtils.isEmpty(list2)) {
            return false;
        }
        int eb = 0;
        while (eb < list1.length()) {
            int ee = list1.indexOf(",", eb);
            if (ee < 0) {
                return StringUtils.matchInList(list2, list1.substring(eb));
            }
            if (ee > eb && StringUtils.matchInList(list2, list1.substring(eb, ee))) {
                return true;
            }
            eb = ee + 1;
        }
        return false;
    }

    public static String firstNonEmpty(String ... values) {
        for (String s : values) {
            if (null == s || s.isEmpty()) continue;
            return s;
        }
        return null;
    }

    public static String typeName(Object object) {
        return null == object ? null : object.getClass().getName();
    }
}

