/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.dataphin;

import com.aliyuncs.AcsResponse;
import com.aliyuncs.RpcAcsRequest;
import com.aliyuncs.dataphin.util.GsonUtils;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.MethodType;
import com.dp.google.gson.JsonParser;
import com.dp.google.gson.JsonSyntaxException;

public abstract class DataphinApiRequest<Response extends AcsResponse>
extends RpcAcsRequest<Response> {
    protected DataphinApiRequest() {
        super("dataphin");
        this.setVersion("2020-08-30");
        this.setActionName(this.actionFromClassName());
        this.setSysMethod(MethodType.POST);
        this.setHttpContentType(FormatType.JSON);
    }

    String actionFromClassName() {
        String requestClassName = this.getClass().getSimpleName();
        if (requestClassName.endsWith("Request")) {
            return requestClassName.substring(0, requestClassName.length() - 7);
        }
        throw new RuntimeException("Bad API request naming: " + requestClassName);
    }

    public void putJsonEncodedQueryParameter(String name, Object value) {
        this.putQueryParameter(name, GsonUtils.toJson(value));
    }

    public void putJsonEncodedHeaderParameter(String name, Object value) {
        this.putHeaderParameter(name, GsonUtils.toJson(value));
    }

    public void putJsonEncodedBodyParameter(String name, Object value) {
        this.putBodyParameter(name, GsonUtils.toJson(value));
    }

    public void putRawJsonEncodedBodyParameter(String name, String jsonValue) {
        try {
            JsonParser.parseString(jsonValue);
        }
        catch (JsonSyntaxException e) {
            throw new IllegalArgumentException("Parameter \"" + name + "\" value is not valid JSON!");
        }
        this.putBodyParameter(name, jsonValue);
    }

    public void setOpTenantId(Long tenantId) {
        this.putQueryParameter("OpTenantId", tenantId);
    }

    public void setOpUserId(String userId) {
        this.putQueryParameter("OpUserId", userId);
    }
}

