/*
 * Decompiled with CFR 0.152.
 */
package com.aliyuncs.dataphin;

import com.aliyuncs.AcsRequest;
import com.aliyuncs.AcsResponse;
import com.aliyuncs.DefaultAcsClient;
import com.aliyuncs.auth.AlibabaCloudCredentials;
import com.aliyuncs.auth.AlibabaCloudCredentialsProvider;
import com.aliyuncs.auth.Credential;
import com.aliyuncs.dataphin.util.GsonUtils;
import com.aliyuncs.exceptions.ClientException;
import com.aliyuncs.exceptions.ServerException;
import com.aliyuncs.http.FormatType;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.HttpResponse;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.aliyuncs.profile.IClientProfile;
import com.dp.google.gson.Gson;

public class DataphinAcsClient
extends DefaultAcsClient {
    private static final String DATAPHIN_SDK_CODE = "dataphin";
    private static final String DATAPHIN_PUBLIC_SDK_CODE = "dataphin-public";
    private Gson gson = GsonUtils.upperCamelCaseGson();
    private ProtocolType protocolType = null;

    public DataphinAcsClient(IClientProfile profile) {
        super(profile);
    }

    public DataphinAcsClient(IClientProfile profile, AlibabaCloudCredentials credentials) {
        super(profile, credentials);
    }

    public DataphinAcsClient(IClientProfile profile, AlibabaCloudCredentialsProvider credentialsProvider) {
        super(profile, credentialsProvider);
    }

    @Override
    protected <T extends AcsResponse> T readResponse(Class<T> clazz, HttpResponse httpResponse, FormatType format) throws ClientException {
        if (!format.equals((Object)FormatType.JSON)) {
            throw new ClientException("Unsupported response format: " + (Object)((Object)format));
        }
        return (T)((AcsResponse)this.gson.fromJson(httpResponse.getHttpContentString(), clazz));
    }

    public void setSysProtocol(ProtocolType protocolType) {
        this.protocolType = protocolType;
    }

    public static DataphinAcsClient create(String regionId, String endpoint, String accessKey, String secret, String productCode) {
        boolean usingSSL = false;
        if (endpoint.toLowerCase().startsWith("http://")) {
            endpoint = endpoint.substring(7);
        } else if (endpoint.toLowerCase().startsWith("https://")) {
            usingSSL = true;
            endpoint = endpoint.substring(8);
        }
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        DefaultProfile.addEndpoint(regionId, productCode, endpoint);
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKey, secret);
        if (usingSSL) {
            HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
            httpClientConfig.setIgnoreSSLCerts(true);
            profile.setHttpClientConfig(httpClientConfig);
        }
        DataphinAcsClient acsClient = new DataphinAcsClient(profile);
        if (usingSSL) {
            acsClient.setSysProtocol(ProtocolType.HTTPS);
        } else {
            acsClient.setSysProtocol(ProtocolType.HTTP);
        }
        return acsClient;
    }

    public static DataphinAcsClient create(String regionId, String endpoint, String accessKey, String secret) {
        return DataphinAcsClient.create(regionId, endpoint, accessKey, secret, DATAPHIN_SDK_CODE);
    }

    public static DataphinAcsClient createForPublic(String regionId, String endpoint, String accessKey, String secret) {
        return DataphinAcsClient.create(regionId, endpoint, accessKey, secret, DATAPHIN_PUBLIC_SDK_CODE);
    }

    private <T extends AcsResponse> AcsRequest<T> modifyRequest(AcsRequest<T> request) {
        if (null != this.protocolType) {
            request.setSysProtocol(this.protocolType);
        }
        return request;
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, boolean autoRetry, int maxRetryCounts) throws ServerException, ClientException {
        return super.getAcsResponse(this.modifyRequest(request), autoRetry, maxRetryCounts);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request) throws ServerException, ClientException {
        return super.getAcsResponse(this.modifyRequest(request));
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, IClientProfile profile) throws ServerException, ClientException {
        return super.getAcsResponse(this.modifyRequest(request), profile);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId, Credential credential) throws ServerException, ClientException {
        return super.getAcsResponse(this.modifyRequest(request), regionId, credential);
    }

    @Override
    public <T extends AcsResponse> T getAcsResponse(AcsRequest<T> request, String regionId) throws ServerException, ClientException {
        return super.getAcsResponse(this.modifyRequest(request), regionId);
    }
}

