/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.oss.internal;

import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.comm.RequestMessage;
import com.aliyun.oss.common.comm.ResponseHandler;
import com.aliyun.oss.common.comm.ServiceClient;
import com.aliyun.oss.common.comm.io.RepeatableFileInputStream;
import com.aliyun.oss.common.parser.RequestMarshallers;
import com.aliyun.oss.common.parser.ResponseParser;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.common.utils.CRC64;
import com.aliyun.oss.common.utils.CodingUtils;
import com.aliyun.oss.common.utils.DateUtil;
import com.aliyun.oss.common.utils.HttpUtil;
import com.aliyun.oss.common.utils.IOUtils;
import com.aliyun.oss.common.utils.LogUtils;
import com.aliyun.oss.common.utils.RangeSpec;
import com.aliyun.oss.event.ProgressEventType;
import com.aliyun.oss.event.ProgressInputStream;
import com.aliyun.oss.event.ProgressListener;
import com.aliyun.oss.event.ProgressPublisher;
import com.aliyun.oss.internal.Mimetypes;
import com.aliyun.oss.internal.OSSCallbackErrorResponseHandler;
import com.aliyun.oss.internal.OSSOperation;
import com.aliyun.oss.internal.OSSRequestMessageBuilder;
import com.aliyun.oss.internal.OSSUtils;
import com.aliyun.oss.internal.ResponseParsers;
import com.aliyun.oss.model.AppendObjectRequest;
import com.aliyun.oss.model.AppendObjectResult;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.CopyObjectRequest;
import com.aliyun.oss.model.CopyObjectResult;
import com.aliyun.oss.model.CreateDirectoryRequest;
import com.aliyun.oss.model.CreateSelectMetaInputStream;
import com.aliyun.oss.model.CreateSelectObjectMetadataRequest;
import com.aliyun.oss.model.CreateSymlinkRequest;
import com.aliyun.oss.model.DeleteDirectoryRequest;
import com.aliyun.oss.model.DeleteDirectoryResult;
import com.aliyun.oss.model.DeleteObjectsRequest;
import com.aliyun.oss.model.DeleteObjectsResult;
import com.aliyun.oss.model.DeleteVersionRequest;
import com.aliyun.oss.model.DeleteVersionsRequest;
import com.aliyun.oss.model.DeleteVersionsResult;
import com.aliyun.oss.model.GenericRequest;
import com.aliyun.oss.model.GenericResult;
import com.aliyun.oss.model.GetObjectRequest;
import com.aliyun.oss.model.HeadObjectRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.OSSSymlink;
import com.aliyun.oss.model.ObjectAcl;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.Payer;
import com.aliyun.oss.model.ProcessObjectRequest;
import com.aliyun.oss.model.PutObjectRequest;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.RenameObjectRequest;
import com.aliyun.oss.model.RestoreObjectRequest;
import com.aliyun.oss.model.RestoreObjectResult;
import com.aliyun.oss.model.SelectContentFormat;
import com.aliyun.oss.model.SelectInputStream;
import com.aliyun.oss.model.SelectObjectMetadata;
import com.aliyun.oss.model.SelectObjectRequest;
import com.aliyun.oss.model.SetObjectAclRequest;
import com.aliyun.oss.model.SetObjectTaggingRequest;
import com.aliyun.oss.model.SimplifiedObjectMeta;
import com.aliyun.oss.model.TagSet;
import com.aliyun.oss.model.VoidResult;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.CheckedInputStream;

public class OSSObjectOperation
extends OSSOperation {
    public OSSObjectOperation(ServiceClient client, CredentialsProvider credsProvider) {
        super(client, credsProvider);
    }

    public PutObjectResult putObject(PutObjectRequest putObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(putObjectRequest, "putObjectRequest");
        PutObjectResult result = null;
        result = !OSSObjectOperation.isNeedReturnResponse(putObjectRequest) ? this.writeObjectInternal(WriteMode.OVERWRITE, putObjectRequest, ResponseParsers.putObjectReponseParser) : this.writeObjectInternal(WriteMode.OVERWRITE, putObjectRequest, ResponseParsers.putObjectProcessReponseParser);
        if (this.isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public PutObjectResult putObject(URL signedUrl, InputStream requestContent, long contentLength, Map<String, String> requestHeaders, boolean useChunkEncoding) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(signedUrl, "signedUrl");
        CodingUtils.assertParameterNotNull(requestContent, "requestContent");
        if (requestHeaders == null) {
            requestHeaders = new HashMap<String, String>();
        }
        RequestMessage request = new RequestMessage(null, null);
        request.setMethod(HttpMethod.PUT);
        request.setAbsoluteUrl(signedUrl);
        request.setUseUrlSignature(true);
        request.setContent(requestContent);
        request.setContentLength(OSSUtils.determineInputStreamLength(requestContent, contentLength, useChunkEncoding));
        request.setHeaders(requestHeaders);
        request.setUseChunkEncoding(useChunkEncoding);
        PutObjectResult result = null;
        result = requestHeaders.get("x-oss-callback") == null ? this.doOperation(request, ResponseParsers.putObjectReponseParser, null, null, true) : this.doOperation(request, ResponseParsers.putObjectProcessReponseParser, null, null, true);
        if (this.isCrcCheckEnabled()) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public AppendObjectResult appendObject(AppendObjectRequest appendObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(appendObjectRequest, "appendObjectRequest");
        AppendObjectResult result = this.writeObjectInternal(WriteMode.APPEND, appendObjectRequest, ResponseParsers.appendObjectResponseParser);
        if (appendObjectRequest.getInitCRC() != null && result.getClientCRC() != null) {
            result.setClientCRC(CRC64.combine(appendObjectRequest.getInitCRC(), result.getClientCRC(), result.getNextPosition() - appendObjectRequest.getPosition()));
        }
        if (this.isCrcCheckEnabled() && appendObjectRequest.getInitCRC() != null) {
            OSSUtils.checkChecksum(result.getClientCRC(), result.getServerCRC(), result.getRequestId());
        }
        return result;
    }

    public SelectObjectMetadata createSelectObjectMetadata(CreateSelectObjectMetadataRequest createSelectObjectMetadataRequest) throws OSSException, ClientException {
        String process = createSelectObjectMetadataRequest.getProcess();
        CodingUtils.assertParameterNotNull(process, "process");
        GenericRequest genericRequest = new GenericRequest(createSelectObjectMetadataRequest.getBucketName(), createSelectObjectMetadataRequest.getKey());
        genericRequest.getParameters().put("x-oss-process", process);
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, createSelectObjectMetadataRequest.getRequestPayer());
        byte[] content = RequestMarshallers.createSelectObjectMetadataRequestMarshaller.marshall(createSelectObjectMetadataRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createSelectObjectMetadataRequest)).setMethod(HttpMethod.POST).setInputSize(content.length).setInputStream(new ByteArrayInputStream(content)).setBucket(bucketName).setKey(key).setHeaders(headers).setOriginalRequest(genericRequest).build();
        ProgressListener selectProgressListener = createSelectObjectMetadataRequest.getSelectProgressListener();
        try {
            SelectObjectMetadata.SelectContentMetadataBase selectContentMetadataBase;
            OSSObject ossObject = this.doOperation(request, new ResponseParsers.GetObjectResponseParser(bucketName, key), bucketName, key, true);
            ProgressPublisher.publishProgress(selectProgressListener, ProgressEventType.SELECT_STARTED_EVENT);
            SelectObjectMetadata selectObjectMetadata = new SelectObjectMetadata(ossObject.getObjectMetadata());
            if (createSelectObjectMetadataRequest.getInputSerialization().getSelectContentFormat() == SelectContentFormat.CSV) {
                selectObjectMetadata.setCsvObjectMetadata(new SelectObjectMetadata.CSVObjectMetadata());
                selectContentMetadataBase = selectObjectMetadata.getCsvObjectMetadata();
            } else {
                selectObjectMetadata.setJsonObjectMetadata(new SelectObjectMetadata.JsonObjectMetadata());
                selectContentMetadataBase = selectObjectMetadata.getJsonObjectMetadata();
            }
            InputStream in = ossObject.getObjectContent();
            CreateSelectMetaInputStream warppedStream = new CreateSelectMetaInputStream(in, selectContentMetadataBase, selectProgressListener);
            warppedStream.setRequestId(ossObject.getRequestId());
            while (warppedStream.read() != -1) {
            }
            return selectObjectMetadata;
        }
        catch (IOException e) {
            ProgressPublisher.publishProgress(selectProgressListener, ProgressEventType.SELECT_FAILED_EVENT);
            throw new RuntimeException(e);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(selectProgressListener, ProgressEventType.SELECT_FAILED_EVENT);
            throw e;
        }
    }

    public OSSObject selectObject(SelectObjectRequest selectObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(selectObjectRequest, "selectObjectRequest");
        String bucketName = selectObjectRequest.getBucketName();
        String key = selectObjectRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateGetObjectRequestHeaders(selectObjectRequest, headers);
        OSSObjectOperation.populateRequestPayerHeader(headers, selectObjectRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        OSSUtils.populateResponseHeaderParameters(params, selectObjectRequest.getResponseHeaders());
        String process = selectObjectRequest.getProcess();
        CodingUtils.assertParameterNotNull(process, "process");
        params.put("x-oss-process", process);
        SelectObjectRequest.ExpressionType expressionType = selectObjectRequest.getExpressionType();
        if (expressionType != SelectObjectRequest.ExpressionType.SQL) {
            throw new IllegalArgumentException("Select object only support sql expression");
        }
        if (selectObjectRequest.getExpression() == null) {
            throw new IllegalArgumentException("Select expression is null");
        }
        if (selectObjectRequest.getLineRange() != null && selectObjectRequest.getSplitRange() != null) {
            throw new IllegalArgumentException("Line range and split range of select request should not both set");
        }
        byte[] content = RequestMarshallers.selectObjectRequestMarshaller.marshall(selectObjectRequest);
        headers.put("Content-MD5", BinaryUtil.toBase64String(BinaryUtil.calculateMd5(content)));
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(selectObjectRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setInputSize(content.length).setInputStream(new ByteArrayInputStream(content)).setParameters(params).setOriginalRequest(selectObjectRequest).build();
        ProgressListener selectProgressListener = selectObjectRequest.getSelectProgressListener();
        try {
            OSSObject ossObject = this.doOperation(request, new ResponseParsers.GetObjectResponseParser(bucketName, key), bucketName, key, true);
            ProgressPublisher.publishProgress(selectProgressListener, ProgressEventType.SELECT_STARTED_EVENT);
            InputStream inputStream = ossObject.getObjectContent();
            if (!Boolean.parseBoolean(ossObject.getObjectMetadata().getRawMetadata().get("x-oss-select-output-raw").toString())) {
                SelectInputStream selectInputStream = new SelectInputStream(inputStream, selectProgressListener, selectObjectRequest.getOutputSerialization().isPayloadCrcEnabled());
                selectInputStream.setRequestId(ossObject.getRequestId());
                ossObject.setObjectContent(selectInputStream);
            }
            return ossObject;
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(selectProgressListener, ProgressEventType.SELECT_FAILED_EVENT);
            throw e;
        }
    }

    public OSSObject getObject(GetObjectRequest getObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
        String bucketName = null;
        String key = null;
        RequestMessage request = null;
        if (!getObjectRequest.isUseUrlSignature()) {
            String process;
            CodingUtils.assertParameterNotNull(getObjectRequest, "getObjectRequest");
            bucketName = getObjectRequest.getBucketName();
            key = getObjectRequest.getKey();
            CodingUtils.assertParameterNotNull(bucketName, "bucketName");
            CodingUtils.assertParameterNotNull(key, "key");
            OSSUtils.ensureBucketNameValid(bucketName);
            OSSUtils.ensureObjectKeyValid(key);
            HashMap<String, String> headers = new HashMap<String, String>();
            OSSObjectOperation.populateGetObjectRequestHeaders(getObjectRequest, headers);
            HashMap<String, String> params = new HashMap<String, String>();
            OSSUtils.populateResponseHeaderParameters(params, getObjectRequest.getResponseHeaders());
            String versionId = getObjectRequest.getVersionId();
            if (versionId != null) {
                params.put("versionId", versionId);
            }
            if ((process = getObjectRequest.getProcess()) != null) {
                params.put("x-oss-process", process);
            }
            request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(getObjectRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(getObjectRequest).build();
        } else {
            request = new RequestMessage(getObjectRequest, bucketName, key);
            request.setMethod(HttpMethod.GET);
            request.setAbsoluteUrl(getObjectRequest.getAbsoluteUri());
            request.setUseUrlSignature(true);
            request.setHeaders(getObjectRequest.getHeaders());
        }
        ProgressListener listener = getObjectRequest.getProgressListener();
        OSSObject ossObject = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            ossObject = this.doOperation(request, new ResponseParsers.GetObjectResponseParser(bucketName, key), bucketName, key, true);
            InputStream instream = ossObject.getObjectContent();
            ProgressInputStream progressInputStream = new ProgressInputStream(instream, listener){

                @Override
                protected void onEOF() {
                    ProgressPublisher.publishProgress(this.getListener(), ProgressEventType.TRANSFER_COMPLETED_EVENT);
                }
            };
            CRC64 crc = new CRC64();
            CheckedInputStream checkedInputstream = new CheckedInputStream(progressInputStream, crc);
            ossObject.setObjectContent(checkedInputstream);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        return ossObject;
    }

    public ObjectMetadata getObject(GetObjectRequest getObjectRequest, File file) throws OSSException, ClientException {
        ObjectMetadata objectMetadata;
        CodingUtils.assertParameterNotNull(file, "file");
        OSSObject ossObject = this.getObject(getObjectRequest);
        BufferedOutputStream outputStream = null;
        try {
            int bytesRead;
            outputStream = new BufferedOutputStream(new FileOutputStream(file));
            byte[] buffer = new byte[8192];
            while ((bytesRead = IOUtils.readNBytes(ossObject.getObjectContent(), buffer, 0, buffer.length)) > 0) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            if (this.isCrcCheckEnabled() && !this.hasRangeInRequest(getObjectRequest)) {
                Long clientCRC = IOUtils.getCRCValue(ossObject.getObjectContent());
                OSSUtils.checkChecksum(clientCRC, ossObject.getServerCRC(), ossObject.getRequestId());
            }
            objectMetadata = ossObject.getObjectMetadata();
        }
        catch (IOException ex) {
            try {
                LogUtils.logException("Cannot read object content stream: ", ex);
                throw new ClientException(OSSUtils.OSS_RESOURCE_MANAGER.getString("CannotReadContentStream"), ex);
            }
            catch (Throwable throwable) {
                IOUtils.safeClose(outputStream);
                IOUtils.safeClose(ossObject.getObjectContent());
                throw throwable;
            }
        }
        IOUtils.safeClose(outputStream);
        IOUtils.safeClose(ossObject.getObjectContent());
        return objectMetadata;
    }

    public SimplifiedObjectMeta getSimplifiedObjectMeta(GenericRequest genericRequest) {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("objectMeta", null);
        if (genericRequest.getVersionId() != null) {
            params.put("versionId", genericRequest.getVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getSimplifiedObjectMetaResponseParser, bucketName, key);
    }

    public ObjectMetadata getObjectMetadata(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        if (genericRequest.getVersionId() != null) {
            params.put("versionId", genericRequest.getVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getObjectMetadataResponseParser, bucketName, key);
    }

    public CopyObjectResult copyObject(CopyObjectRequest copyObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(copyObjectRequest, "copyObjectRequest");
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateCopyObjectHeaders(copyObjectRequest, headers);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(copyObjectRequest)).setMethod(HttpMethod.PUT).setBucket(copyObjectRequest.getDestinationBucketName()).setKey(copyObjectRequest.getDestinationKey()).setHeaders(headers).setOriginalRequest(copyObjectRequest).build();
        return this.doOperation(request, ResponseParsers.copyObjectResponseParser, copyObjectRequest.getDestinationBucketName(), copyObjectRequest.getDestinationKey(), true);
    }

    public VoidResult deleteObject(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setHeaders(headers).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, key);
    }

    public VoidResult deleteVersion(DeleteVersionRequest deleteVersionRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteVersionRequest, "deleteVersionRequest");
        String bucketName = deleteVersionRequest.getBucketName();
        String key = deleteVersionRequest.getKey();
        String versionId = deleteVersionRequest.getVersionId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertParameterNotNull(versionId, "versionId");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("versionId", versionId);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, deleteVersionRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteVersionRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(deleteVersionRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, key);
    }

    public DeleteObjectsResult deleteObjects(DeleteObjectsRequest deleteObjectsRequest) {
        CodingUtils.assertParameterNotNull(deleteObjectsRequest, "deleteObjectsRequest");
        String bucketName = deleteObjectsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delete", null);
        byte[] rawContent = RequestMarshallers.deleteObjectsRequestMarshaller.marshall(deleteObjectsRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.addDeleteObjectsRequiredHeaders(headers, rawContent);
        OSSObjectOperation.addDeleteObjectsOptionalHeaders(headers, deleteObjectsRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteObjectsRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteObjectsRequest).build();
        return this.doOperation(request, ResponseParsers.deleteObjectsResponseParser, bucketName, null, true);
    }

    public DeleteVersionsResult deleteVersions(DeleteVersionsRequest deleteVersionsRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteVersionsRequest, "deleteObjectsRequest");
        String bucketName = deleteVersionsRequest.getBucketName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("delete", null);
        byte[] rawContent = RequestMarshallers.deleteVersionsRequestMarshaller.marshall(deleteVersionsRequest);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.addDeleteVersionsRequiredHeaders(headers, rawContent);
        OSSObjectOperation.populateRequestPayerHeader(headers, deleteVersionsRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteVersionsRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setParameters(params).setHeaders(headers).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(deleteVersionsRequest).build();
        return this.doOperation(request, ResponseParsers.deleteVersionsResponseParser, bucketName, null, true);
    }

    public ObjectMetadata headObject(HeadObjectRequest headObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(headObjectRequest, "headObjectRequest");
        String bucketName = headObjectRequest.getBucketName();
        String key = headObjectRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.addDateHeader(headers, "If-Modified-Since", headObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "If-Unmodified-Since", headObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "If-Match", headObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "If-None-Match", headObjectRequest.getNonmatchingETagConstraints());
        OSSObjectOperation.populateRequestPayerHeader(headers, headObjectRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        if (headObjectRequest.getVersionId() != null) {
            params.put("versionId", headObjectRequest.getVersionId());
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(headObjectRequest)).setMethod(HttpMethod.HEAD).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(headObjectRequest).build();
        return this.doOperation(request, ResponseParsers.headObjectResponseParser, bucketName, key);
    }

    public VoidResult setObjectAcl(SetObjectAclRequest setObjectAclRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setObjectAclRequest, "setObjectAclRequest");
        String bucketName = setObjectAclRequest.getBucketName();
        String key = setObjectAclRequest.getKey();
        CannedAccessControlList cannedAcl = setObjectAclRequest.getCannedACL();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertParameterNotNull((Object)cannedAcl, "cannedAcl");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-object-acl", cannedAcl.toString());
        OSSObjectOperation.populateRequestPayerHeader(headers, setObjectAclRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        if (setObjectAclRequest.getVersionId() != null) {
            params.put("versionId", setObjectAclRequest.getVersionId());
        }
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setObjectAclRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setParameters(params).setHeaders(headers).setOriginalRequest(setObjectAclRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, key);
    }

    public ObjectAcl getObjectAcl(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("acl", null);
        if (genericRequest.getVersionId() != null) {
            params.put("versionId", genericRequest.getVersionId());
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getObjectAclResponseParser, bucketName, key, true);
    }

    public RestoreObjectResult restoreObject(GenericRequest genericRequest) throws OSSException, ClientException {
        RestoreObjectRequest restoreObjectRequest;
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        String versionId = genericRequest.getVersionId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        byte[] content = new byte[]{};
        if (genericRequest instanceof RestoreObjectRequest && (restoreObjectRequest = (RestoreObjectRequest)genericRequest).getRestoreConfiguration() != null) {
            content = RequestMarshallers.restoreObjectRequestMarshaller.marshall(restoreObjectRequest);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("restore", null);
        if (versionId != null) {
            params.put("versionId", versionId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStream(new ByteArrayInputStream(content)).setInputSize(content.length).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.restoreObjectResponseParser, bucketName, key);
    }

    public VoidResult setObjectTagging(SetObjectTaggingRequest setObjectTaggingRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(setObjectTaggingRequest, "setBucketTaggingRequest");
        String bucketName = setObjectTaggingRequest.getBucketName();
        String key = setObjectTaggingRequest.getKey();
        String versionId = setObjectTaggingRequest.getVersionId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        if (versionId != null) {
            params.put("versionId", versionId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, setObjectTaggingRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(setObjectTaggingRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStreamWithLength(RequestMarshallers.setBucketTaggingRequestMarshaller.marshall(setObjectTaggingRequest)).setOriginalRequest(setObjectTaggingRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, key);
    }

    public TagSet getObjectTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        String versionId = genericRequest.getVersionId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        if (versionId != null) {
            params.put("versionId", versionId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, ResponseParsers.getTaggingResponseParser, bucketName, key, true);
    }

    public VoidResult deleteObjectTagging(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String key = genericRequest.getKey();
        String versionId = genericRequest.getVersionId();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("tagging", null);
        if (versionId != null) {
            params.put("versionId", versionId);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.DELETE).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, key);
    }

    public OSSSymlink getSymlink(GenericRequest genericRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(genericRequest, "genericRequest");
        String bucketName = genericRequest.getBucketName();
        String symlink = genericRequest.getKey();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(symlink, "symlink");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(symlink);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symlink", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, genericRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(genericRequest)).setMethod(HttpMethod.GET).setBucket(bucketName).setKey(symlink).setHeaders(headers).setParameters(params).setOriginalRequest(genericRequest).build();
        OSSSymlink symbolicLink = this.doOperation(request, ResponseParsers.getSymbolicLinkResponseParser, bucketName, symlink, true);
        if (symbolicLink != null) {
            symbolicLink.setSymlink(new String(symlink));
        }
        return symbolicLink;
    }

    public VoidResult createSymlink(CreateSymlinkRequest createSymlinkRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createSymlinkRequest, "createSymlinkRequest");
        String bucketName = createSymlinkRequest.getBucketName();
        String symlink = createSymlinkRequest.getSymlink();
        String target = createSymlinkRequest.getTarget();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(symlink, "symlink");
        CodingUtils.assertParameterNotNull(target, "target");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(symlink);
        OSSUtils.ensureObjectKeyValid(target);
        ObjectMetadata metadata = createSymlinkRequest.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        String encodeTargetObject = HttpUtil.urlEncode(target, "utf-8");
        metadata.setHeader("x-oss-symlink-target", encodeTargetObject);
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(target, symlink));
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.populateRequestMetadata(headers, metadata);
        OSSObjectOperation.populateRequestPayerHeader(headers, createSymlinkRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("symlink", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createSymlinkRequest)).setMethod(HttpMethod.PUT).setBucket(bucketName).setKey(symlink).setHeaders(headers).setParameters(params).setOriginalRequest(createSymlinkRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, symlink);
    }

    public GenericResult processObject(ProcessObjectRequest processObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(processObjectRequest, "genericRequest");
        String bucketName = processObjectRequest.getBucketName();
        String key = processObjectRequest.getKey();
        String process = processObjectRequest.getProcess();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureObjectKeyValid(key);
        CodingUtils.assertStringNotNullOrEmpty(process, "process");
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x-oss-process", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, processObjectRequest.getRequestPayer());
        byte[] rawContent = RequestMarshallers.processObjectRequestMarshaller.marshall(processObjectRequest);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(processObjectRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputSize(rawContent.length).setInputStream(new ByteArrayInputStream(rawContent)).setOriginalRequest(processObjectRequest).build();
        return this.doOperation(request, ResponseParsers.processObjectResponseParser, bucketName, key, true);
    }

    public boolean doesObjectExist(GenericRequest genericRequest) throws OSSException, ClientException {
        try {
            this.getSimplifiedObjectMeta(genericRequest);
            return true;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchBucket") || e.getErrorCode().equals("NoSuchKey")) {
                return false;
            }
            throw e;
        }
    }

    public boolean doesObjectExistWithRedirect(GenericRequest genericRequest) throws OSSException, ClientException {
        OSSObject ossObject = null;
        try {
            String bucketName = genericRequest.getBucketName();
            String key = genericRequest.getKey();
            Payer payer = genericRequest.getRequestPayer();
            GetObjectRequest getObjectRequest = new GetObjectRequest(bucketName, key);
            if (payer != null) {
                getObjectRequest.setRequestPayer(payer);
            }
            ossObject = this.getObject(getObjectRequest);
            boolean bl = true;
            return bl;
        }
        catch (OSSException e) {
            if (e.getErrorCode().equals("NoSuchBucket") || e.getErrorCode().equals("NoSuchKey")) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (ossObject != null) {
                try {
                    ossObject.forcedClose();
                }
                catch (IOException e) {
                    LogUtils.logException("Forced close failed: ", e);
                }
            }
        }
    }

    public VoidResult createDirectory(CreateDirectoryRequest createDirectoryRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(createDirectoryRequest, "createDirectoryRequest");
        String bucketName = createDirectoryRequest.getBucketName();
        String directory = createDirectoryRequest.getDirectoryName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(directory, "directory");
        OSSUtils.ensureObjectKeyValid(directory);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x-oss-dir", null);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateRequestPayerHeader(headers, createDirectoryRequest.getRequestPayer());
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(createDirectoryRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(directory).setParameters(params).setHeaders(headers).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).setOriginalRequest(createDirectoryRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, directory);
    }

    public DeleteDirectoryResult deleteDirectory(DeleteDirectoryRequest deleteDirectoryRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(deleteDirectoryRequest, "deleteDirectoryRequest");
        String bucketName = deleteDirectoryRequest.getBucketName();
        String directoryName = deleteDirectoryRequest.getDirectoryName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(directoryName, "directoryName");
        OSSUtils.ensureObjectKeyValid(directoryName);
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSObjectOperation.populateDeleteDirectoryRequestHeaders(headers, deleteDirectoryRequest);
        OSSObjectOperation.populateRequestPayerHeader(headers, deleteDirectoryRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x-oss-delete", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(deleteDirectoryRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(directoryName).setParameters(params).setHeaders(headers).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).setOriginalRequest(deleteDirectoryRequest).build();
        return this.doOperation(request, ResponseParsers.deleteDirectoryResponseParser, bucketName, directoryName, true);
    }

    public VoidResult renameObject(RenameObjectRequest renameObjectRequest) throws OSSException, ClientException {
        CodingUtils.assertParameterNotNull(renameObjectRequest, "renameObjectRequest");
        String bucketName = renameObjectRequest.getBucketName();
        String destObject = renameObjectRequest.getDestinationObjectName();
        String srcObject = renameObjectRequest.getSourceObjectName();
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        OSSUtils.ensureBucketNameValid(bucketName);
        CodingUtils.assertParameterNotNull(destObject, "dstObject");
        CodingUtils.assertParameterNotNull(srcObject, "srcObject");
        OSSUtils.ensureObjectKeyValid(destObject);
        OSSUtils.ensureObjectKeyValid(srcObject);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("x-oss-rename-source", HttpUtil.urlEncode(srcObject, "utf-8"));
        OSSObjectOperation.populateRequestPayerHeader(headers, renameObjectRequest.getRequestPayer());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("x-oss-rename", null);
        RequestMessage request = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(renameObjectRequest)).setMethod(HttpMethod.POST).setBucket(bucketName).setKey(destObject).setParameters(params).setHeaders(headers).setInputStream(new ByteArrayInputStream(new byte[0])).setInputSize(0L).setOriginalRequest(renameObjectRequest).build();
        return this.doOperation(request, requestIdResponseParser, bucketName, destObject);
    }

    private <RequestType extends PutObjectRequest, ResponseType> ResponseType writeObjectInternal(WriteMode mode, RequestType originalRequest, ResponseParser<ResponseType> responseParser) {
        String bucketName = originalRequest.getBucketName();
        String key = originalRequest.getKey();
        InputStream originalInputStream = originalRequest.getInputStream();
        ObjectMetadata metadata = originalRequest.getMetadata();
        if (metadata == null) {
            metadata = new ObjectMetadata();
        }
        CodingUtils.assertParameterNotNull(bucketName, "bucketName");
        CodingUtils.assertParameterNotNull(key, "key");
        OSSUtils.ensureBucketNameValid(bucketName);
        OSSUtils.ensureObjectKeyValid(key);
        OSSUtils.ensureCallbackValid(originalRequest.getCallback());
        InputStream repeatableInputStream = null;
        if (originalRequest.getFile() != null) {
            File toUpload = originalRequest.getFile();
            if (!IOUtils.checkFile(toUpload)) {
                LogUtils.getLog().info("Illegal file path: " + toUpload.getPath());
                throw new ClientException("Illegal file path: " + toUpload.getPath());
            }
            metadata.setContentLength(toUpload.length());
            if (metadata.getContentType() == null) {
                metadata.setContentType(Mimetypes.getInstance().getMimetype(toUpload, key));
            }
            try {
                repeatableInputStream = new RepeatableFileInputStream(toUpload);
            }
            catch (IOException ex) {
                LogUtils.logException("Cannot locate file to upload: ", ex);
                throw new ClientException("Cannot locate file to upload: ", ex);
            }
        }
        CodingUtils.assertTrue(originalInputStream != null, "Please specify input stream or file to upload");
        if (metadata.getContentType() == null) {
            metadata.setContentType(Mimetypes.getInstance().getMimetype(key));
        }
        try {
            repeatableInputStream = IOUtils.newRepeatableInputStream(originalInputStream);
        }
        catch (IOException ex) {
            LogUtils.logException("Cannot wrap to repeatable input stream: ", ex);
            throw new ClientException("Cannot wrap to repeatable input stream: ", ex);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        OSSUtils.populateRequestMetadata(headers, metadata);
        OSSUtils.populateRequestCallback(headers, originalRequest.getCallback());
        OSSObjectOperation.populateRequestPayerHeader(headers, originalRequest.getRequestPayer());
        OSSObjectOperation.populateTrafficLimitHeader(headers, originalRequest.getTrafficLimit());
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        OSSObjectOperation.populateWriteObjectParams(mode, originalRequest, params);
        RequestMessage httpRequest = new OSSRequestMessageBuilder(this.getInnerClient()).setEndpoint(this.getEndpoint(originalRequest)).setMethod(WriteMode.getMappingMethod(mode)).setBucket(bucketName).setKey(key).setHeaders(headers).setParameters(params).setInputStream(repeatableInputStream).setInputSize(OSSUtils.determineInputStreamLength(repeatableInputStream, metadata.getContentLength())).setOriginalRequest(originalRequest).build();
        ArrayList<ResponseHandler> reponseHandlers = new ArrayList<ResponseHandler>();
        reponseHandlers.add(new OSSCallbackErrorResponseHandler());
        ProgressListener listener = originalRequest.getProgressListener();
        ResponseType result = null;
        try {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_STARTED_EVENT);
            result = originalRequest.getCallback() == null ? (ResponseType)this.doOperation(httpRequest, responseParser, bucketName, key, true) : (ResponseType)this.doOperation(httpRequest, responseParser, bucketName, key, true, null, reponseHandlers);
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_COMPLETED_EVENT);
        }
        catch (RuntimeException e) {
            ProgressPublisher.publishProgress(listener, ProgressEventType.TRANSFER_FAILED_EVENT);
            throw e;
        }
        return result;
    }

    private boolean isCrcCheckEnabled() {
        return this.getInnerClient().getClientConfiguration().isCrcCheckEnabled();
    }

    private boolean hasRangeInRequest(GetObjectRequest getObjectRequest) {
        return getObjectRequest.getHeaders().get("Range") != null;
    }

    private static void populateCopyObjectHeaders(CopyObjectRequest copyObjectRequest, Map<String, String> headers) {
        String copySourceHeader = "/" + copyObjectRequest.getSourceBucketName() + "/" + HttpUtil.urlEncode(copyObjectRequest.getSourceKey(), "utf-8");
        if (copyObjectRequest.getSourceVersionId() != null) {
            copySourceHeader = copySourceHeader + "?versionId=" + copyObjectRequest.getSourceVersionId();
        }
        headers.put("x-oss-copy-source", copySourceHeader);
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-modified-since", copyObjectRequest.getModifiedSinceConstraint());
        OSSUtils.addDateHeader(headers, "x-oss-copy-source-if-unmodified-since", copyObjectRequest.getUnmodifiedSinceConstraint());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-match", copyObjectRequest.getMatchingETagConstraints());
        OSSUtils.addStringListHeader(headers, "x-oss-copy-source-if-none-match", copyObjectRequest.getNonmatchingEtagConstraints());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption", copyObjectRequest.getServerSideEncryption());
        OSSUtils.addHeader(headers, "x-oss-server-side-encryption-key-id", copyObjectRequest.getServerSideEncryptionKeyId());
        ObjectMetadata newObjectMetadata = copyObjectRequest.getNewObjectMetadata();
        if (newObjectMetadata != null) {
            headers.put("x-oss-metadata-directive", MetadataDirective.REPLACE.toString());
            if (newObjectMetadata.getRawMetadata().get("x-oss-tagging") != null) {
                headers.put("x-oss-tagging-directive", MetadataDirective.REPLACE.toString());
            }
            OSSUtils.populateRequestMetadata(headers, newObjectMetadata);
        }
        OSSObjectOperation.populateRequestPayerHeader(headers, copyObjectRequest.getRequestPayer());
        OSSUtils.removeHeader(headers, "Content-Length");
    }

    private static void populateGetObjectRequestHeaders(GetObjectRequest getObjectRequest, Map<String, String> headers) {
        if (getObjectRequest.getRange() != null) {
            OSSObjectOperation.addGetObjectRangeHeader(getObjectRequest.getRange(), headers);
        }
        if (getObjectRequest.getModifiedSinceConstraint() != null) {
            headers.put("If-Modified-Since", DateUtil.formatRfc822Date(getObjectRequest.getModifiedSinceConstraint()));
        }
        if (getObjectRequest.getUnmodifiedSinceConstraint() != null) {
            headers.put("If-Unmodified-Since", DateUtil.formatRfc822Date(getObjectRequest.getUnmodifiedSinceConstraint()));
        }
        if (getObjectRequest.getMatchingETagConstraints().size() > 0) {
            headers.put("If-Match", OSSUtils.joinETags(getObjectRequest.getMatchingETagConstraints()));
        }
        if (getObjectRequest.getNonmatchingETagConstraints().size() > 0) {
            headers.put("If-None-Match", OSSUtils.joinETags(getObjectRequest.getNonmatchingETagConstraints()));
        }
        OSSObjectOperation.populateRequestPayerHeader(headers, getObjectRequest.getRequestPayer());
        OSSObjectOperation.populateTrafficLimitHeader(headers, getObjectRequest.getTrafficLimit());
    }

    private static void addDeleteObjectsRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        headers.put("Content-Length", String.valueOf(rawContent.length));
        byte[] md5 = BinaryUtil.calculateMd5(rawContent);
        String md5Base64 = BinaryUtil.toBase64String(md5);
        headers.put("Content-MD5", md5Base64);
    }

    private static void addDeleteVersionsRequiredHeaders(Map<String, String> headers, byte[] rawContent) {
        OSSObjectOperation.addDeleteObjectsRequiredHeaders(headers, rawContent);
        headers.put("encoding-type", "url");
    }

    private static void addDeleteObjectsOptionalHeaders(Map<String, String> headers, DeleteObjectsRequest request) {
        if (request.getEncodingType() != null) {
            headers.put("encoding-type", request.getEncodingType());
        }
        OSSObjectOperation.populateRequestPayerHeader(headers, request.getRequestPayer());
    }

    private static void addGetObjectRangeHeader(long[] range, Map<String, String> headers) {
        RangeSpec rangeSpec = RangeSpec.parse(range);
        headers.put("Range", rangeSpec.toString());
    }

    private static void populateRequestPayerHeader(Map<String, String> headers, Payer payer) {
        if (payer != null && payer.equals((Object)Payer.Requester)) {
            headers.put("x-oss-request-payer", payer.toString().toLowerCase());
        }
    }

    private static void populateTrafficLimitHeader(Map<String, String> headers, int limit) {
        if (limit > 0) {
            headers.put("x-oss-traffic-limit", String.valueOf(limit));
        }
    }

    private static void populateWriteObjectParams(WriteMode mode, PutObjectRequest originalRequest, Map<String, String> params) {
        if (mode == WriteMode.OVERWRITE) {
            return;
        }
        assert (originalRequest instanceof AppendObjectRequest);
        params.put("append", null);
        AppendObjectRequest appendObjectRequest = (AppendObjectRequest)originalRequest;
        if (appendObjectRequest.getPosition() != null) {
            params.put("position", String.valueOf(appendObjectRequest.getPosition()));
        }
    }

    private static boolean isNeedReturnResponse(PutObjectRequest putObjectRequest) {
        return putObjectRequest.getCallback() != null || putObjectRequest.getProcess() != null;
    }

    private static void populateDeleteDirectoryRequestHeaders(Map<String, String> headers, DeleteDirectoryRequest deleteDirectoryRequest) {
        if (deleteDirectoryRequest.isDeleteRecursive().booleanValue()) {
            headers.put("x-oss-delete-recursive", deleteDirectoryRequest.isDeleteRecursive().toString());
        }
        if (deleteDirectoryRequest.getNextDeleteToken() != null && !deleteDirectoryRequest.getNextDeleteToken().isEmpty()) {
            headers.put("x-oss-delete-token", deleteDirectoryRequest.getNextDeleteToken());
        }
    }

    private static enum WriteMode {
        APPEND("APPEND"),
        OVERWRITE("OVERWRITE");

        private final String modeAsString;

        private WriteMode(String modeAsString) {
            this.modeAsString = modeAsString;
        }

        public String toString() {
            return this.modeAsString;
        }

        public static HttpMethod getMappingMethod(WriteMode mode) {
            switch (mode) {
                case APPEND: {
                    return HttpMethod.POST;
                }
                case OVERWRITE: {
                    return HttpMethod.PUT;
                }
            }
            throw new IllegalArgumentException("Unsuported write mode" + mode.toString());
        }
    }

    private static enum MetadataDirective {
        COPY("COPY"),
        REPLACE("REPLACE");

        private final String directiveAsString;

        private MetadataDirective(String directiveAsString) {
            this.directiveAsString = directiveAsString;
        }

        public String toString() {
            return this.directiveAsString;
        }
    }
}

