/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc.utils;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLCharExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLIdentifierExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertInto;
import com.alibaba.fastsql.sql.ast.statement.SQLInsertStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQueryBlock;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLSubqueryTableSource;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.google.common.collect.Lists;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class SparkSqlUtil {
    private static final String SPARK_GEN_SQL_ALIAS_PREFIX = "SPARK_GEN_SUBQ_";
    private static final String DOUBLE_QUOTE = "\"";
    private static final String SINGLE_QUOTE = "'";

    public static String trimSelectFiledDoubleQuoteOfSparkGenSql(String sql) {
        SQLStatement sqlStatement;
        if (StringUtils.isEmpty(sql)) {
            return sql;
        }
        try {
            sqlStatement = SQLUtils.parseSingleStatement(sql, DbType.odps, new SQLParserFeature[0]);
        }
        catch (Exception e) {
            try {
                sqlStatement = SQLUtils.parseSingleStatement(sql, DbType.other, new SQLParserFeature[0]);
            }
            catch (Exception e1) {
                return sql;
            }
        }
        if (sqlStatement instanceof SQLSelectStatement) {
            SQLSelectStatement sqlSelectStatement = (SQLSelectStatement)sqlStatement;
            SQLSelectQueryBlock queryBlock = sqlSelectStatement.getSelect().getQueryBlock();
            if (queryBlock.getFrom() == null || StringUtils.isEmpty(queryBlock.getFrom().getAlias())) {
                return sql;
            }
            boolean isSparkGenQuerySql = queryBlock.getFrom().getAlias().toUpperCase().startsWith(SPARK_GEN_SQL_ALIAS_PREFIX);
            if (isSparkGenQuerySql && queryBlock.getFrom() instanceof SQLSubqueryTableSource) {
                if (queryBlock.getSelectList() == null || queryBlock.getSelectList().size() <= 0) {
                    return sql;
                }
                for (SQLSelectItem selectItem : queryBlock.getSelectList()) {
                    if (StringUtils.isNotEmpty(selectItem.getAlias())) {
                        String alias = SparkSqlUtil.trimStringSingleQuote(selectItem.getAlias());
                        selectItem.setAlias(alias);
                    }
                    String exprStr = selectItem.getExpr().toString();
                    String newExprStr = SparkSqlUtil.trimStringSingleQuote(exprStr);
                    selectItem.setExpr(SQLUtils.toSQLExpr(newExprStr, DbType.odps));
                }
                return SQLUtils.toSQLString(queryBlock);
            }
        } else if (sqlStatement instanceof SQLCreateTableStatement) {
            SQLCreateTableStatement sqlCreateTableStatement = (SQLCreateTableStatement)sqlStatement;
            for (SQLColumnDefinition columnDefinition : sqlCreateTableStatement.getColumnDefinitions()) {
                String colAfterTrimDoubleQuota = SparkSqlUtil.trimStringDoubleQuote(columnDefinition.getColumnName());
                String colAfterTrimSingleQuota = SparkSqlUtil.trimStringSingleQuote(colAfterTrimDoubleQuota);
                columnDefinition.setName(colAfterTrimSingleQuota);
            }
            return SQLUtils.toSQLString(sqlStatement);
        }
        return sql;
    }

    public static List<String> insertSqlMerge(List<String> sqlList) {
        SQLInsertInto mergeSqlInsertStatement = null;
        for (String singleSql : sqlList) {
            try {
                SQLStatement sqlStatement = SQLUtils.parseSingleStatement(singleSql, DbType.odps, new SQLParserFeature[0]);
                if (!(sqlStatement instanceof SQLInsertStatement)) {
                    return sqlList;
                }
                SQLInsertStatement sqlInsertStatement = (SQLInsertStatement)sqlStatement;
                if (mergeSqlInsertStatement == null) {
                    mergeSqlInsertStatement = sqlInsertStatement;
                    continue;
                }
                mergeSqlInsertStatement.getValuesList().addAll(sqlInsertStatement.getValuesList());
            }
            catch (Exception e) {
                return sqlList;
            }
        }
        if (mergeSqlInsertStatement != null) {
            for (SQLExpr column : mergeSqlInsertStatement.getColumns()) {
                if (!(column instanceof SQLCharExpr)) continue;
                SQLCharExpr sqlCharExpr = (SQLCharExpr)column;
                SQLIdentifierExpr sqlIdentifierExpr = new SQLIdentifierExpr(sqlCharExpr.getText());
                SQLUtils.replaceInParent(sqlCharExpr, sqlIdentifierExpr);
            }
            String mergedSql = SQLUtils.toSQLString(mergeSqlInsertStatement);
            return Lists.newArrayList(mergedSql);
        }
        return sqlList;
    }

    public static String trimStringDoubleQuote(String data) {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        String dataNew = StringUtils.stripStart(data, DOUBLE_QUOTE);
        return StringUtils.stripEnd(dataNew, DOUBLE_QUOTE);
    }

    public static String trimStringSingleQuote(String data) {
        if (StringUtils.isEmpty(data)) {
            return data;
        }
        String dataNew = StringUtils.stripStart(data, SINGLE_QUOTE);
        return StringUtils.stripEnd(dataNew, SINGLE_QUOTE);
    }
}

