/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc.utils;

import com.aliyun.dataphin_public20230630.models.CreateJdbcConnectionResponse;
import com.aliyun.dataphin_public20230630.models.ExecSqlByJdbcResponse;
import com.aliyun.dataphin_public20230630.models.GetDataSourceByCatalogForJdbcResponse;
import com.aliyun.dataphin_public20230630.models.GetServerVersionResponse;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesResponse;
import com.aliyun.dataphin_public20230630.models.ListSchemasResponse;
import com.aliyun.dataphin_public20230630.models.QueryTaskStatusResponse;
import com.aliyuncs.dataphin.DataphinApiResponse;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;

public class ResponseStatusCheckUtils {
    private static final Logger logger = LoggerFactory.getLogger(ResponseStatusCheckUtils.class);
    private static final String LOGGER_ERROR_MSG_FORMAT = "RequestId: %s, httpStatusCode: %s, code: %s, message: %s";

    public static void checkStatus(CreateJdbcConnectionResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(GetServerVersionResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(ListSchemasResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(ListCatalogTablesResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(QueryTaskStatusResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(ExecSqlByJdbcResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(DataphinApiResponse response) {
        if (!response.getCode().equalsIgnoreCase("OK")) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getRequestId(), response.getCode(), response.getCode(), response.getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }

    public static void checkStatus(GetDataSourceByCatalogForJdbcResponse response) {
        if (!response.getBody().getSuccess().booleanValue()) {
            String message = String.format(LOGGER_ERROR_MSG_FORMAT, response.getBody().getRequestId(), response.getBody().getHttpStatusCode(), response.getBody().getCode(), response.getBody().getMessage());
            logger.error(message);
            throw new RuntimeException(message);
        }
    }
}

