/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc.utils;

import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

public class ParameterUtils {
    public static String updateSql(String sql, Map<Integer, Object> parameters) throws SQLException {
        if (!sql.contains("?")) {
            return sql;
        }
        StringBuilder newSql = new StringBuilder(sql);
        int paramIndex = 1;
        int pos = 0;
        while (pos < newSql.length()) {
            if (newSql.charAt(pos) == '?') {
                if (parameters.containsKey(paramIndex)) {
                    newSql.deleteCharAt(pos);
                    String str = ParameterUtils.convertJavaTypeToSqlString(parameters.get(paramIndex));
                    newSql.insert(pos, str);
                    pos += str.length() - 1;
                } else {
                    ++pos;
                }
                ++paramIndex;
                continue;
            }
            ++pos;
        }
        return newSql.toString();
    }

    private static String convertJavaTypeToSqlString(Object x) throws SQLException {
        if (x instanceof Byte) {
            return String.format("%sY", x);
        }
        if (x instanceof Short) {
            return String.format("%sS", x);
        }
        if (x instanceof Integer) {
            return x.toString();
        }
        if (x instanceof Long) {
            return String.format("%sL", x);
        }
        if (x instanceof Float || x instanceof Double) {
            return x.toString();
        }
        if (x instanceof BigDecimal) {
            return String.format("%sBD", x);
        }
        if (x instanceof String) {
            return "'" + x + "'";
        }
        if (x instanceof Timestamp) {
            return String.format("TIMESTAMP\"%s\"", x);
        }
        if (x instanceof Date) {
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return String.format("DATETIME\"%s\"", formatter.format(x));
        }
        if (x instanceof Boolean) {
            return x.toString().toUpperCase();
        }
        if (x == null || x.equals(0)) {
            return "NULL";
        }
        throw new SQLFeatureNotSupportedException("Method not supported");
    }
}

