/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc.logger;

import com.aliyun.dataphin.jdbc.logger.DataphinJdbcFormatter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Objects;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.lang.StringUtils;

public class DataphinJdbcConsoleLogger {
    private boolean enableConsoleLog = false;
    private Logger consoleLogger;
    private final String DEBUG_LEVEL = "debug";
    private final String INFO_LEVEL = "info";
    private final String WARNING_LEVEL = "warning";
    private final String ERROR_LEVEL = "error";

    public DataphinJdbcConsoleLogger(String name, String sessionId, String level, boolean enableConsoleLog) {
        this.enableConsoleLog = enableConsoleLog;
        Objects.requireNonNull(name);
        if (enableConsoleLog) {
            Level logLevel = Level.ALL;
            if (StringUtils.equalsIgnoreCase(level, "debug")) {
                logLevel = Level.FINE;
            } else if (StringUtils.equalsIgnoreCase(level, "info")) {
                logLevel = Level.INFO;
            } else if (StringUtils.equalsIgnoreCase(level, "warning")) {
                logLevel = Level.WARNING;
            } else if (StringUtils.equalsIgnoreCase(level, "error")) {
                logLevel = Level.SEVERE;
            }
            this.consoleLogger = Logger.getLogger(name);
            this.consoleLogger.setLevel(logLevel);
            ConsoleHandler consoleHandler = new ConsoleHandler();
            consoleHandler.setFormatter(new DataphinJdbcFormatter(sessionId));
            consoleHandler.setLevel(logLevel);
            this.consoleLogger.addHandler(consoleHandler);
        }
    }

    public synchronized void debug(String msg) {
        if (this.enableConsoleLog) {
            this.consoleLogger.fine(msg);
        }
    }

    public synchronized void info(String msg) {
        if (this.enableConsoleLog) {
            this.consoleLogger.info(msg);
        }
    }

    public synchronized void warn(String msg) {
        if (this.enableConsoleLog) {
            this.consoleLogger.warning(msg);
        }
    }

    public synchronized void error(String msg) {
        if (this.enableConsoleLog) {
            this.consoleLogger.severe(msg);
        }
    }

    public synchronized void error(String msg, Throwable e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        e.printStackTrace(pw);
        if (this.enableConsoleLog) {
            this.consoleLogger.severe(msg);
            this.consoleLogger.severe(sw.toString());
        }
    }
}

