/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum TaskStatusEnum {
    TRANSLATE("Translate"),
    RUNNING("Running"),
    SUSPENDED("Suspended"),
    WAITING("Waiting"),
    SUCCESS("Success"),
    FAILED("Failed"),
    CANCELLED("Cancelled"),
    CANCELLING("Cancelling"),
    FINISHING("Finishing"),
    TERMINATED("Terminated");

    private final String status;
    private static Map<String, TaskStatusEnum> M;

    private TaskStatusEnum(String type) {
        this.status = type;
    }

    public String getStatus() {
        return this.status;
    }

    public static TaskStatusEnum of(String status) {
        return M.getOrDefault(status, null);
    }

    static {
        M = Arrays.stream(TaskStatusEnum.values()).collect(Collectors.toMap(TaskStatusEnum::getStatus, e -> e));
    }
}

