/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.dp.google.gson.internal.LinkedTreeMap;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.apache.commons.lang.StringUtils;

public class JdbcColumn {
    public static final String EXECUTE_SQL_RESULT_COLUMN_NAME = "result";
    public static final String EXECUTE_SQL_RESULT_COLUMN_TYPE = "string";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss.SSS";
    public static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String DATE_FORMAT = "yyyy-MM-dd";
    public static final String TIME_FORMAT = "HH:mm:ss";
    private static final String DECIMAL_TYPE_PREFIX = "decimal";
    private static final String NULL_STR = "null";
    private static final String ODPS_NULL_STR = "\\N";
    private static final String VALUE_KEY = "value";
    private static final String VARCHAR_TYPE_PREFIX = "varchar";

    public static int getJdbcType(String type) {
        String t = type.toLowerCase();
        if (t.startsWith(DECIMAL_TYPE_PREFIX)) {
            return 3;
        }
        if (t.startsWith(VARCHAR_TYPE_PREFIX)) {
            return 12;
        }
        switch (t) {
            case "string": 
            case "datetime": {
                return 12;
            }
            case "char": {
                return 1;
            }
            case "float": {
                return 6;
            }
            case "double": {
                return 8;
            }
            case "boolean": {
                return 16;
            }
            case "tinyint": {
                return -6;
            }
            case "smallint": {
                return 5;
            }
            case "int": {
                return 4;
            }
            case "bigint": {
                return -5;
            }
            case "date": {
                return 91;
            }
            case "timestamp": {
                return 93;
            }
            case "binary": {
                return -2;
            }
            case "map": {
                return 2000;
            }
            case "array": {
                return 2003;
            }
            case "struct": {
                return 2002;
            }
        }
        return 1111;
    }

    public static int columnPrecision(int type) {
        switch (type) {
            case 16: {
                return 1;
            }
            case -2: 
            case 3: 
            case 1111: 
            case 2000: 
            case 2002: 
            case 2003: {
                return Integer.MAX_VALUE;
            }
            case -6: {
                return 3;
            }
            case 5: {
                return 5;
            }
            case 4: 
            case 91: {
                return 10;
            }
            case -5: {
                return 19;
            }
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: {
                return 29;
            }
            case 2014: {
                return 31;
            }
        }
        return 0;
    }

    public static int columnScale(int type) {
        switch (type) {
            case 6: {
                return 7;
            }
            case 8: {
                return 15;
            }
            case 93: 
            case 2014: {
                return 9;
            }
        }
        return 0;
    }

    public static boolean columnSigned(int type) throws SQLException {
        switch (type) {
            case -6: 
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                return true;
            }
        }
        return false;
    }

    public static Object evaluate(int type, Object value) {
        if (value == null) {
            return null;
        }
        if (type != 12 && (StringUtils.equalsIgnoreCase(NULL_STR, value.toString()) || StringUtils.equalsIgnoreCase(ODPS_NULL_STR, value.toString()))) {
            return null;
        }
        switch (type) {
            case 12: {
                LinkedTreeMap mapValue;
                if (value instanceof LinkedTreeMap && (mapValue = (LinkedTreeMap)value).containsKey(VALUE_KEY)) {
                    return mapValue.get(VALUE_KEY);
                }
                return String.valueOf(value);
            }
            case 6: {
                if (value instanceof Float || value instanceof Double) {
                    return value;
                }
                return Float.valueOf(value.toString());
            }
            case 8: {
                if (value instanceof Double) {
                    return value;
                }
                return Double.valueOf(value.toString());
            }
            case 16: {
                return Boolean.valueOf(value.toString());
            }
            case -6: 
            case 4: 
            case 5: {
                return Integer.valueOf(value.toString());
            }
            case -5: {
                return new BigInteger(value.toString());
            }
            case 91: {
                if (value instanceof Long) {
                    return new Date((Long)value);
                }
                try {
                    return Date.valueOf(value.toString());
                }
                catch (Exception e) {
                    return Timestamp.valueOf(value.toString());
                }
            }
            case 93: {
                return Timestamp.valueOf(value.toString());
            }
            case 3: {
                return new BigDecimal(value.toString());
            }
            case -2: {
                if (!(value instanceof String)) break;
                return ((String)value).getBytes(StandardCharsets.UTF_8);
            }
        }
        return value;
    }
}

