/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ConnectionProperty;
import com.aliyun.dataphin.jdbc.DataphinBaseMetaResultSet;
import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.utils.ResponseStatusCheckUtils;
import com.aliyun.dataphin.jdbc.utils.StringUtil;
import com.aliyun.dataphin_public20230630.Client;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesRequest;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesResponse;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DataphinTableMetaResultSet
extends DataphinBaseMetaResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DataphinTableMetaResultSet.class);
    private final String catalog;
    private final String schemaPattern;
    private final String tableNamePattern;
    private final String[] types;
    private List<ListCatalogTablesResponseBody.ListCatalogTablesResponseBodyPaginatedResultData> batchResults;
    private List<String> matchSchemaList;
    private int currentPageNum = 1;
    private int schemaOffset = 0;
    private int currentOffset = 0;
    private boolean hasNextPage = false;

    public DataphinTableMetaResultSet(DataphinConnection connection, String catalog, String schemaPattern, String tableNamePattern, String[] types) {
        super(connection);
        this.catalog = catalog;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.types = types;
    }

    @Override
    Map<String, String> listMetaColumns() {
        LinkedHashMap<String, String> metaMap = Maps.newLinkedHashMap();
        metaMap.put("TABLE_CAT", "STRING");
        metaMap.put("TABLE_SCHEM", "STRING");
        metaMap.put("TABLE_NAME", "STRING");
        metaMap.put("TABLE_TYPE", "STRING");
        metaMap.put("REMARKS", "STRING");
        metaMap.put("TYPE_CAT", "STRING");
        metaMap.put("TYPE_SCHEM", "STRING");
        metaMap.put("TYPE_NAME", "STRING");
        metaMap.put("SELF_REFERENCING_COL_NAME", "STRING");
        metaMap.put("REF_GENERATION", "STRING");
        return metaMap;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.matchSchemaList == null) {
            this.fetchSchemas();
            if (this.matchSchemaList == null || this.matchSchemaList.isEmpty()) {
                return false;
            }
        }
        if (this.batchResults == null) {
            this.fetchResult();
        }
        while (this.currentOffset >= this.batchResults.size()) {
            this.currentOffset = 0;
            if (!this.hasNextPage) {
                ++this.schemaOffset;
                this.currentPageNum = 0;
            }
            if (this.schemaOffset >= this.matchSchemaList.size()) {
                return false;
            }
            this.fetchResult();
            if (this.batchResults.isEmpty()) continue;
        }
        this.currentRow = this.tableInfoToRow(this.batchResults.get(this.currentOffset));
        ++this.currentOffset;
        return true;
    }

    private void fetchSchemas() throws SQLException {
        this.matchSchemaList = this.fetchAllSchemas();
        if (this.matchSchemaList == null) {
            String message = String.format("Fetch schemas response null, query info : %s.%s", this.catalog, this.schemaPattern);
            this.dataphinJdbcConsoleLogger.info(message);
            logger.warn(message);
            return;
        }
        this.matchSchemaList = this.matchSchemaList.stream().filter(t -> StringUtil.matchPattern(t, this.schemaPattern)).collect(Collectors.toList());
    }

    private void fetchResult() throws SQLException {
        ListCatalogTablesRequest fetchRequest = new ListCatalogTablesRequest();
        ConnectionProperty connectionProperty = this.connection.getConnectionProperty();
        fetchRequest.setOpTenantId(connectionProperty.getTenantId());
        if (connectionProperty.getDelegationUid() != null) {
            fetchRequest.setOpUserId(connectionProperty.getDelegationUid());
        }
        ListCatalogTablesRequest.ListCatalogTablesRequestTableQuery tableQuery = new ListCatalogTablesRequest.ListCatalogTablesRequestTableQuery();
        tableQuery.setCatalog(this.catalog);
        tableQuery.setSchema(this.matchSchemaList.get(this.schemaOffset));
        tableQuery.setPageSize(this.fetchSize);
        tableQuery.setPageNum(this.currentPageNum);
        fetchRequest.setTableQuery(tableQuery);
        this.dataphinJdbcConsoleLogger.info(String.format(String.format("Fetch table meta, pageNum: %d, fetchSize: %d", this.currentPageNum, this.fetchSize), new Object[0]));
        try {
            Client client = this.connection.getDataphinAcsClient();
            RuntimeOptions options = this.connection.getDataphinClientOptions();
            ListCatalogTablesResponse response = client.listCatalogTablesWithOptions(fetchRequest, options);
            ResponseStatusCheckUtils.checkStatus(response);
            if (response.getBody() == null || response.getBody().getPaginatedResult() == null || response.getBody().getPaginatedResult().getData() == null) {
                String message = String.format("Fetch table list response is null, query info : %s.%s", this.catalog, this.matchSchemaList.get(this.schemaOffset));
                logger.warn(message);
                this.hasNextPage = false;
                this.batchResults = Lists.newArrayList();
                return;
            }
            this.hasNextPage = response.getBody().getPaginatedResult().getData().size() >= this.fetchSize;
            this.batchResults = response.getBody().getPaginatedResult().getData().stream().filter(t -> StringUtil.matchPattern(t.getName(), this.tableNamePattern)).filter(t -> this.matchTableTypes(this.types, t.getTableType())).collect(Collectors.toList());
            ++this.currentPageNum;
        }
        catch (Exception e) {
            String message = String.format("Fetch table list error, query info : %s, error data: %s", tableQuery, e.getMessage());
            throw new SQLException(message);
        }
    }

    private String[] tableInfoToRow(ListCatalogTablesResponseBody.ListCatalogTablesResponseBodyPaginatedResultData table) {
        String[] result = new String[10];
        result[0] = this.catalog;
        result[1] = this.matchSchemaList.get(this.schemaOffset);
        result[2] = table.getName();
        result[3] = table.getTableType().toUpperCase();
        result[4] = table.getDesc();
        return result;
    }

    private Boolean matchTableTypes(String[] types, String tableType) {
        if (types == null || types.length == 0 || StringUtils.isEmpty(tableType)) {
            return true;
        }
        for (String type : types) {
            if (!type.equalsIgnoreCase(tableType)) continue;
            return true;
        }
        return false;
    }
}

