/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ColumnMetadata;
import com.aliyun.dataphin.jdbc.ConnectionProperty;
import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.DataphinResultSet;
import com.aliyun.dataphin.jdbc.DataphinResultSetMetaData;
import com.aliyun.dataphin.jdbc.JdbcColumn;
import com.aliyun.dataphin.jdbc.logger.DataphinJdbcConsoleLogger;
import com.aliyun.dataphin.jdbc.utils.ResponseStatusCheckUtils;
import com.aliyun.dataphin.jdbc.utils.SparkSqlUtil;
import com.aliyun.dataphin.jdbc.utils.TaskStatusUtil;
import com.aliyun.dataphin_public20230630.Client;
import com.aliyun.dataphin_public20230630.models.CancelTaskRequest;
import com.aliyun.dataphin_public20230630.models.ExecSqlByJdbcRequest;
import com.aliyun.dataphin_public20230630.models.ExecSqlByJdbcResponse;
import com.aliyun.dataphin_public20230630.models.QueryTaskStatusRequest;
import com.aliyun.dataphin_public20230630.models.QueryTaskStatusResponse;
import com.aliyun.dataphin_public20230630.models.QueryTaskStatusResponseBody;
import com.google.common.collect.Lists;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class DataphinStatement
implements Statement {
    private static final Logger logger = LoggerFactory.getLogger(DataphinStatement.class);
    private DataphinConnection connHandle;
    private DataphinResultSet resultSet;
    private int fetchSize = 1000;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private SQLWarning warningChain = null;
    private int queryTimeout = 0;
    private int maxRows = 0;
    private boolean closeOnResultSetCompletion = false;
    private static final int TASK_STATUS_QUERY_MAX_COUNT = 3;
    private static final long QUERY_STATE_INTERVAL = 1000L;
    private static final long QUERY_STATE_MAX_INTERVAL = 30000L;
    private boolean isOperationComplete = false;
    private boolean isMockData = false;
    private DataphinJdbcConsoleLogger dataphinJdbcConsoleLogger;
    private StringBuilder executeLogCache = new StringBuilder();
    private String currentTaskId;

    public DataphinStatement(DataphinConnection connHandle) {
        this.connHandle = connHandle;
        this.dataphinJdbcConsoleLogger = new DataphinJdbcConsoleLogger(DataphinStatement.class.getName(), connHandle.getSessionId(), connHandle.getConnectionProperty().getLogLevel(), true);
    }

    private void mockExecute() {
        ArrayList<String> columnNames = Lists.newArrayList("name", "age", "home", "col1", "col2");
        ArrayList<List<Object>> resultData = Lists.newArrayList();
        for (int i = 0; i < this.fetchSize; ++i) {
            ArrayList<String> rowData = Lists.newArrayList();
            rowData.add("name_" + i);
            rowData.add(String.valueOf(i));
            rowData.add("hz_" + i);
            rowData.add("aaa_" + i);
            rowData.add("bbb_" + i);
            resultData.add((List<Object>)rowData);
        }
        ArrayList<ColumnMetadata> columnMetadataList = new ArrayList<ColumnMetadata>();
        for (String columnName : columnNames) {
            ColumnMetadata columnMetadata = new ColumnMetadata();
            columnMetadata.setColumnName(columnName);
            columnMetadata.setColumnLabel(columnName);
            columnMetadata.setColumnType(JdbcColumn.getJdbcType("string"));
            columnMetadata.setColumnTypeName("string");
            columnMetadata.setPrecision(0);
            columnMetadata.setScale(0);
            columnMetadataList.add(columnMetadata);
        }
        DataphinResultSetMetaData metaData = new DataphinResultSetMetaData(columnMetadataList);
        this.resultSet = new DataphinResultSet(this, metaData, resultData);
    }

    private boolean checkTaskStatus(String sql, String taskId) throws SQLException {
        if (StringUtils.isEmpty(taskId)) {
            String message = "Execute sql error, Client response taskId is empty.";
            logger.error(message);
            this.dataphinJdbcConsoleLogger.error(message);
            throw new SQLException(message);
        }
        if (taskId.startsWith("DATAPHIN_USERID_")) {
            String userId = taskId.substring("DATAPHIN_USERID_".length());
            this.connHandle.changCurrentUser(userId);
            return true;
        }
        int queryStatusCount = 0;
        long checkStatusInterval = 1000L;
        ConnectionProperty connectionProperty = this.connHandle.getConnectionProperty();
        QueryTaskStatusRequest statusRequest = new QueryTaskStatusRequest();
        statusRequest.setProjectName(connectionProperty.getComputeProject());
        statusRequest.setTaskId(taskId);
        statusRequest.setOpTenantId(connectionProperty.getTenantId());
        if (connectionProperty.getDelegationUid() != null) {
            statusRequest.setOpUserId(connectionProperty.getDelegationUid());
        }
        statusRequest.setSessionId(this.connHandle.getSessionId());
        int checkStateFailedCount = 0;
        int logOffset = 0;
        do {
            ++queryStatusCount;
            if (checkStatusInterval < 30000L) {
                checkStatusInterval = (long)queryStatusCount * 1000L;
            }
            try {
                statusRequest.setLogOffset(logOffset);
                QueryTaskStatusResponse statusResponse = this.connHandle.getDataphinAcsClient().queryTaskStatusWithOptions(statusRequest, this.connHandle.getDataphinClientOptions());
                ResponseStatusCheckUtils.checkStatus(statusResponse);
                if (statusResponse == null || statusResponse.getBody() == null || statusResponse.getBody().getSqlTaskStatus() == null) {
                    String message = String.format("Query response is null, failed count: %d", ++checkStateFailedCount);
                    logger.warn(message);
                    this.executeLogCache.append(message);
                    this.dataphinJdbcConsoleLogger.warn(message);
                } else {
                    String message;
                    QueryTaskStatusResponseBody.QueryTaskStatusResponseBodySqlTaskStatus taskStatus = statusResponse.getBody().getSqlTaskStatus();
                    this.dataphinJdbcConsoleLogger.info(taskStatus.getLogContent());
                    this.executeLogCache.append(taskStatus.getLogContent());
                    if (TaskStatusUtil.isTaskSuccess(taskStatus.getTaskStatus())) {
                        return true;
                    }
                    if (TaskStatusUtil.isTaskRunning(taskStatus.getTaskStatus())) {
                        message = String.format("Task %s status is %s", taskId, taskStatus.getTaskStatus());
                        logger.info(message);
                        this.dataphinJdbcConsoleLogger.debug(message);
                    } else {
                        message = "Sql execute failed, task status: " + taskStatus.getTaskStatus();
                        logger.error("Sql execute failed");
                        this.executeLogCache.append(message);
                        this.dataphinJdbcConsoleLogger.error(message);
                        throw new SQLException(this.executeLogCache.toString());
                    }
                }
                Thread.sleep(checkStatusInterval);
            }
            catch (SQLException e) {
                this.executeLogCache.append(e.getMessage());
                throw e;
            }
            catch (Exception e) {
                String errorMessage = String.format("Query status error, failed count: %d. ", ++checkStateFailedCount);
                logger.error(errorMessage, e);
                this.executeLogCache.append(errorMessage);
                this.dataphinJdbcConsoleLogger.error(errorMessage, e);
            }
            if (!this.isCancelled) continue;
            throw new SQLException(String.format("query has been cancelled, sql:\n[\n%s\n] ", sql));
        } while (checkStateFailedCount <= 3);
        String message = String.format("Query sql task status response is null, query failed count %d exceed max Count %d.", checkStateFailedCount, 3);
        this.executeLogCache.append(message);
        this.dataphinJdbcConsoleLogger.error(message);
        throw new SQLException(message);
    }

    private void executeByClient(String sql) throws SQLException {
        if (this.isMockData) {
            this.mockExecute();
            return;
        }
        this.executeLogCache = new StringBuilder();
        this.dataphinJdbcConsoleLogger.info("Prepare execute Sql: " + sql);
        String formatSql = SparkSqlUtil.trimSelectFiledDoubleQuoteOfSparkGenSql(sql);
        this.dataphinJdbcConsoleLogger.info("SQl after trim double quote: " + formatSql);
        ExecSqlByJdbcRequest execSqlByJdbcRequest = new ExecSqlByJdbcRequest();
        ConnectionProperty connectionProperty = this.connHandle.getConnectionProperty();
        execSqlByJdbcRequest.setProjectName(connectionProperty.getComputeProject());
        execSqlByJdbcRequest.setCodeBody(formatSql);
        execSqlByJdbcRequest.setOpTenantId(connectionProperty.getTenantId());
        if (connectionProperty.getDelegationUid() != null) {
            execSqlByJdbcRequest.setOpUserId(connectionProperty.getDelegationUid());
        }
        execSqlByJdbcRequest.setSessionId(this.connHandle.getSessionId());
        try {
            String taskId;
            Client dataphinAcsClient = this.connHandle.getDataphinAcsClient();
            ExecSqlByJdbcResponse execSqlByJdbcResponse = dataphinAcsClient.execSqlByJdbcWithOptions(execSqlByJdbcRequest, this.connHandle.getDataphinClientOptions());
            ResponseStatusCheckUtils.checkStatus(execSqlByJdbcResponse);
            if (execSqlByJdbcResponse == null || execSqlByJdbcResponse.getBody() == null) {
                String message = "Execute sql error, Client response is null";
                this.executeLogCache.append(message);
                this.dataphinJdbcConsoleLogger.error(message);
                throw new SQLException(message);
            }
            this.currentTaskId = taskId = execSqlByJdbcResponse.getBody().getTaskId();
            this.checkTaskStatus(sql, taskId);
            this.isOperationComplete = true;
            this.resultSet = new DataphinResultSet(this, taskId);
            this.resultSet.setFetchSize(this.getFetchSize());
            this.resultSet.setMaxRows(this.getMaxRows());
        }
        catch (SQLException e) {
            this.isOperationComplete = true;
            this.executeLogCache.append(e.getMessage());
            throw e;
        }
        catch (Exception e) {
            logger.error("Execute sql error, detail: ", e);
            this.executeLogCache.append(e.getMessage());
            this.dataphinJdbcConsoleLogger.error("Execute sql error, detail: ", e);
            throw new SQLException("Execute sql error", e);
        }
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.executeByClient(sql);
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return this.getUpdateCount();
    }

    @Override
    public void close() throws SQLException {
        this.dataphinJdbcConsoleLogger.info("Statement close");
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            if (!this.resultSet.isClosed()) {
                this.resultSet.close();
            }
            this.resultSet = null;
        }
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        this.checkConnection("setMaxRows");
        if (max < 0) {
            throw new SQLException("Maximum number of rows must be >= 0");
        }
        this.maxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        if (enable) {
            throw new SQLFeatureNotSupportedException("Method not supported");
        }
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        this.checkConnection("getQueryTimeout");
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("getQueryTimeout");
        if (this.isCancelled) {
            return;
        }
        if (this.currentTaskId.startsWith("DATAPHIN_USERID_")) {
            this.isCancelled = true;
            return;
        }
        ConnectionProperty connectionProperty = this.connHandle.getConnectionProperty();
        CancelTaskRequest request = new CancelTaskRequest();
        request.setProjectName(connectionProperty.getComputeProject());
        request.setOpTenantId(connectionProperty.getTenantId());
        request.setSessionId(this.connHandle.getSessionId());
        request.setTaskId(this.currentTaskId);
        Client dataphinAcsClient = this.connHandle.getDataphinAcsClient();
        try {
            dataphinAcsClient.cancelTaskWithOptions(request, this.connHandle.getDataphinClientOptions());
        }
        catch (Exception e) {
            String errorMessage = String.format("Cancel task failed, detail : %s", e.getMessage());
            logger.debug(errorMessage, e);
            this.dataphinJdbcConsoleLogger.error(errorMessage);
        }
        this.isCancelled = true;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        this.checkConnection("getWarnings");
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.executeByClient(sql);
        return true;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        this.checkConnection("getUpdateCount");
        while (!this.isOperationComplete) {
        }
        return -1;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException("Not supported direction: " + direction);
        }
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.checkConnection("setFetchSize");
        if (rows > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        this.checkConnection("getConnection");
        return this.connHandle;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        this.closeOnResultSetCompletion = true;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return this.closeOnResultSetCompletion;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    public String fetchExecuteLogContent() {
        String result = this.executeLogCache.toString();
        this.executeLogCache = new StringBuilder();
        return result;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot " + action + " after statement has been closed");
        }
    }
}

