/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.DataphinBaseMetaResultSet;
import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.utils.StringUtil;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataphinSchemaMetaResultSet
extends DataphinBaseMetaResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DataphinSchemaMetaResultSet.class);
    private final String schemaPattern;
    private final String catalog;
    private int currentOffset = 0;
    private List<String> batchResults;

    public DataphinSchemaMetaResultSet(DataphinConnection connection, String catalog, String schemaPattern) {
        super(connection);
        this.catalog = connection.getCatalog();
        this.schemaPattern = schemaPattern;
    }

    @Override
    Map<String, String> listMetaColumns() {
        LinkedHashMap<String, String> metaMap = Maps.newLinkedHashMap();
        metaMap.put("TABLE_SCHEM", "STRING");
        metaMap.put("TABLE_CAT", "STRING");
        return metaMap;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.batchResults == null) {
            this.currentOffset = 0;
            this.fetchResult();
        }
        if (this.currentOffset >= this.batchResults.size()) {
            return false;
        }
        String schema = this.batchResults.get(this.currentOffset);
        this.currentRow = this.schemaInfoToRow(schema);
        ++this.currentOffset;
        return true;
    }

    private Object[] schemaInfoToRow(String schema) {
        return new Object[]{schema, this.catalog};
    }

    private void fetchResult() throws SQLException {
        this.batchResults = this.fetchAllSchemas();
        if (this.batchResults == null) {
            String message = String.format("Fetch schemas response null, query info : %s.%s", this.catalog, this.schemaPattern);
            this.dataphinJdbcConsoleLogger.info(message);
            logger.warn(message);
            this.batchResults = Lists.newArrayList();
            return;
        }
        this.batchResults = this.batchResults.stream().filter(t -> StringUtil.matchPattern(t, this.schemaPattern)).collect(Collectors.toList());
    }
}

