/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ColumnMetadata;
import com.aliyun.dataphin.jdbc.JdbcColumn;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DataphinResultSetMetaData
implements ResultSetMetaData {
    private Map<String, Integer> nameIndexMap;
    private final List<ColumnMetadata> columnMetadataList;
    private static final String STRING_TYPE_NAME = "string";

    public DataphinResultSetMetaData(List<ColumnMetadata> columnMetadataList) {
        this.columnMetadataList = columnMetadataList;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columnMetadataList.size();
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        String type = columnMetadata.getColumnTypeName();
        return STRING_TYPE_NAME.equalsIgnoreCase(type);
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        int type = this.getColumnType(column);
        return JdbcColumn.columnSigned(type);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        return this.columnMetadataList.size();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        if (StringUtils.isNotEmpty(columnMetadata.getColumnLabel())) {
            return columnMetadata.getColumnLabel();
        }
        return columnMetadata.getColumnName();
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        return columnMetadata.getColumnName();
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        if (columnMetadata.getPrecision() > 0) {
            return columnMetadata.getPrecision();
        }
        return JdbcColumn.columnPrecision(columnMetadata.getColumnType());
    }

    @Override
    public int getScale(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        if (columnMetadata.getScale() > 0) {
            return columnMetadata.getScale();
        }
        return JdbcColumn.columnScale(columnMetadata.getColumnType());
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return "";
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return "";
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        return JdbcColumn.getJdbcType(columnMetadata.getColumnTypeName());
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        return columnMetadata.getColumnTypeName();
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        ColumnMetadata columnMetadata = this.columnMetadataList.get(this.toZeroIndex(column));
        return columnMetadata.getColumnTypeName();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    public Integer getColumnIndex(String columnLabel) {
        Integer index;
        if (this.nameIndexMap == null) {
            this.nameIndexMap = new HashMap<String, Integer>();
            for (int i = 0; i < this.columnMetadataList.size(); ++i) {
                ColumnMetadata columnMetadata = this.columnMetadataList.get(i);
                if (StringUtils.isNotEmpty(columnMetadata.getColumnLabel())) {
                    this.nameIndexMap.put(columnMetadata.getColumnLabel(), i + 1);
                    this.nameIndexMap.put(columnMetadata.getColumnLabel().toLowerCase(), i + 1);
                    continue;
                }
                this.nameIndexMap.put(columnMetadata.getColumnName(), i + 1);
                this.nameIndexMap.put(columnMetadata.getColumnName().toLowerCase(), i + 1);
            }
        }
        if ((index = this.nameIndexMap.get(columnLabel)) == null) {
            String lowerName = columnLabel.toLowerCase();
            if (lowerName.equals(columnLabel)) {
                return -1;
            }
            index = this.nameIndexMap.get(columnLabel);
        }
        if (index == null) {
            return -1;
        }
        return index;
    }

    protected int toZeroIndex(int column) {
        if (column <= 0 || column > this.columnMetadataList.size()) {
            throw new IllegalArgumentException();
        }
        return column - 1;
    }
}

