/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ColumnMetadata;
import com.aliyun.dataphin.jdbc.ConnectionProperty;
import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.DataphinResultSetMetaData;
import com.aliyun.dataphin.jdbc.DataphinStatement;
import com.aliyun.dataphin.jdbc.JdbcColumn;
import com.aliyun.dataphin.jdbc.logger.DataphinJdbcConsoleLogger;
import com.aliyun.dataphin.jdbc.utils.GsonUtil;
import com.aliyun.dataphin_public20230630.Client;
import com.aliyun.dataphin_public20230630.models.CancelTaskRequest;
import com.aliyun.dataphin_public20230630.models.FetchTaskResultRequest;
import com.aliyun.dataphin_public20230630.models.FetchTaskResultResponse;
import com.aliyun.dataphin_public20230630.models.FetchTaskResultResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.aliyuncs.exceptions.ClientException;
import com.dp.google.gson.Gson;
import com.dp.google.gson.reflect.TypeToken;
import com.google.common.collect.Lists;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class DataphinResultSet
implements ResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DataphinResultSet.class);
    private final DataphinStatement sdkStatement;
    private String taskId;
    private DataphinResultSetMetaData metaData;
    private List<List<Object>> batchResults;
    private DataphinJdbcConsoleLogger dataphinJdbcConsoleLogger;
    private static final int fetchTimeOutRetryMaxCount = 10;
    private static final long fetchTimeOutRetryInterval = 10000L;
    private static final String timeoutErrorCode = "SDK.ReadTimeout";
    private SQLWarning warningChain;
    private List<Object> currentRow;
    private int totalFetchedRows = 0;
    private int totalOffset = 0;
    private int currentBatchOffset = 0;
    private long maxRows = Long.MAX_VALUE;
    private boolean wasNull = false;
    private boolean isClosed = false;
    private int fetchSize = 50;
    private boolean hasResult = true;
    private final String COLUMN_META_PREFIX = "COLUMN_META:";

    public DataphinResultSet(DataphinStatement sdkStatement, String taskId) throws SQLException {
        this.sdkStatement = sdkStatement;
        this.taskId = taskId;
        DataphinConnection connection = (DataphinConnection)sdkStatement.getConnection();
        ConnectionProperty connectionProperty = connection.getConnectionProperty();
        this.dataphinJdbcConsoleLogger = new DataphinJdbcConsoleLogger(DataphinStatement.class.getName(), connection.getSessionId(), connectionProperty.getLogLevel(), true);
        this.fetchResult();
    }

    public DataphinResultSet(DataphinStatement statement, DataphinResultSetMetaData metaData, List<List<Object>> batchResults) {
        this.sdkStatement = statement;
        this.metaData = metaData;
        this.batchResults = batchResults;
        this.dataphinJdbcConsoleLogger = new DataphinJdbcConsoleLogger(DataphinStatement.class.getName(), "es", "info", true);
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }

    public void setMaxRows(int maxRows) {
        this.maxRows = maxRows;
    }

    private FetchTaskResultResponse executeFetchWithTimeoutRetry(DataphinConnection connection, FetchTaskResultRequest fetchSqlResultRequest) throws Exception {
        for (int retryCount = 0; retryCount <= 10; ++retryCount) {
            try {
                Client client = connection.getDataphinAcsClient();
                RuntimeOptions options = connection.getDataphinClientOptions();
                return client.fetchTaskResultWithOptions(fetchSqlResultRequest, options);
            }
            catch (ClientException e) {
                if (StringUtils.equalsIgnoreCase(e.getErrCode(), timeoutErrorCode)) {
                    this.dataphinJdbcConsoleLogger.error("fetch result timeout, retry: " + retryCount);
                    long waitInterval = 10000L * (long)retryCount;
                    Thread.sleep(waitInterval);
                    continue;
                }
                throw e;
            }
        }
        throw new Exception(String.format("Fetch result timeout exceed %d times.", 10));
    }

    private void fetchResult() throws SQLException {
        this.dataphinJdbcConsoleLogger.info("Begin fetch result from service.");
        if (this.taskId.startsWith("DATAPHIN_USERID_")) {
            this.dataphinJdbcConsoleLogger.info("change current session user success.");
            this.batchResults = Lists.newArrayList();
            this.metaData = new DataphinResultSetMetaData(Lists.newArrayList());
            this.hasResult = false;
            return;
        }
        DataphinConnection connection = (DataphinConnection)this.sdkStatement.getConnection();
        ConnectionProperty connectionProperty = connection.getConnectionProperty();
        FetchTaskResultRequest fetchSqlResultRequest = new FetchTaskResultRequest();
        fetchSqlResultRequest.setTaskId(this.taskId);
        fetchSqlResultRequest.setProjectName(connectionProperty.getComputeProject());
        fetchSqlResultRequest.setOpTenantId(connectionProperty.getTenantId());
        if (connectionProperty.getDelegationUid() != null) {
            fetchSqlResultRequest.setOpUserId(connectionProperty.getDelegationUid());
        }
        fetchSqlResultRequest.setSessionId(connection.getSessionId());
        fetchSqlResultRequest.setOffset(this.totalOffset);
        fetchSqlResultRequest.setFetchSize(this.sdkStatement.getFetchSize());
        try {
            FetchTaskResultResponse fetchResultResponse = this.executeFetchWithTimeoutRetry(connection, fetchSqlResultRequest);
            if (fetchResultResponse == null || fetchResultResponse.getBody() == null || fetchResultResponse.getBody().getSqlResult() == null) {
                String message = String.format("Fetch task: %s result response is null", this.taskId);
                logger.error(message);
                this.dataphinJdbcConsoleLogger.error(message);
                throw new SQLException(message);
            }
            FetchTaskResultResponseBody.FetchTaskResultResponseBodySqlResult sqlResult = fetchResultResponse.getBody().getSqlResult();
            this.dataphinJdbcConsoleLogger.info(String.format("Fetch result offset: %s", sqlResult.getOffset()));
            if (sqlResult.getOffset() < this.totalOffset) {
                String errorMessage = String.format("client offset : %d is larger than server response offset: %d", this.totalOffset, sqlResult.getOffset());
                this.dataphinJdbcConsoleLogger.error(errorMessage);
            }
            this.totalOffset = sqlResult.getOffset();
            Gson gson = GsonUtil.buildGson();
            boolean isNoMeta = false;
            if (StringUtils.isEmpty(sqlResult.getMetaData())) {
                isNoMeta = true;
                if (StringUtils.isEmpty(sqlResult.getResult())) {
                    this.metaData = new DataphinResultSetMetaData(Lists.newArrayList());
                } else {
                    ColumnMetadata executeResultMeta = new ColumnMetadata();
                    executeResultMeta.setColumnName("result");
                    executeResultMeta.setColumnTypeName("string");
                    this.metaData = new DataphinResultSetMetaData(Lists.newArrayList(executeResultMeta));
                }
            } else {
                try {
                    String metaDataJsonContent = sqlResult.getMetaData();
                    this.dataphinJdbcConsoleLogger.debug("sqlResultMeta: " + sqlResult.getMetaData());
                    if (metaDataJsonContent.startsWith("COLUMN_META:")) {
                        metaDataJsonContent = metaDataJsonContent.substring("COLUMN_META:".length());
                    }
                    List columnMetadataList = (List)gson.fromJson(metaDataJsonContent, new TypeToken<List<ColumnMetadata>>(){}.getType());
                    this.metaData = new DataphinResultSetMetaData(columnMetadataList);
                }
                catch (Exception e) {
                    String message = String.format("Task: %s result metadata format error, detail: %s", this.taskId, e.getMessage());
                    logger.error(message, e);
                    this.dataphinJdbcConsoleLogger.error(message, e);
                    throw new SQLException(message);
                }
            }
            if (StringUtils.isEmpty(sqlResult.getResult())) {
                this.dataphinJdbcConsoleLogger.info("Fetched result is Empty, no data found.");
                this.batchResults = Lists.newArrayList();
            } else {
                try {
                    List resultDataList;
                    if (isNoMeta) {
                        resultDataList = Lists.newArrayList();
                        resultDataList.add(Lists.newArrayList(sqlResult.getResult()));
                        this.batchResults = resultDataList;
                    } else {
                        resultDataList = (List)gson.fromJson(sqlResult.getResult(), new TypeToken<List<List<Object>>>(){}.getType());
                        this.batchResults = resultDataList == null || resultDataList.size() <= 1 ? new ArrayList<List<Object>>() : resultDataList.subList(1, resultDataList.size());
                    }
                }
                catch (Exception e) {
                    String message = String.format("Task: %s result data format error, detail: %s", this.taskId, e.getMessage());
                    logger.error(message, e);
                    this.dataphinJdbcConsoleLogger.error(message, e);
                    throw new SQLException(message);
                }
            }
            this.hasResult = sqlResult.getHasResult();
        }
        catch (Exception e) {
            logger.error("Execute sql error, detail: ", e);
            this.dataphinJdbcConsoleLogger.error("Execute sql error, detail: ", e);
            throw new SQLException("Execute sql error", e);
        }
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.maxRows > 0L && (long)this.totalFetchedRows >= this.maxRows) {
            return false;
        }
        if (this.currentBatchOffset == 0 && this.batchResults.isEmpty()) {
            return false;
        }
        if (this.batchResults != null && this.currentBatchOffset < this.batchResults.size()) {
            this.currentRow = this.batchResults.get(this.currentBatchOffset);
            ++this.currentBatchOffset;
            ++this.totalFetchedRows;
            return true;
        }
        if (!this.hasResult) {
            return false;
        }
        this.fetchResult();
        this.currentBatchOffset = 0;
        if (this.batchResults.isEmpty()) {
            return false;
        }
        this.currentRow = this.batchResults.get(this.currentBatchOffset);
        ++this.currentBatchOffset;
        ++this.totalFetchedRows;
        return true;
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            this.dataphinJdbcConsoleLogger.info("ResultSet close");
            if (this.taskId.startsWith("DATAPHIN_USERID_")) {
                this.isClosed = true;
                this.getStatement().close();
                return;
            }
            DataphinConnection connHandle = (DataphinConnection)this.sdkStatement.getConnection();
            ConnectionProperty connectionProperty = connHandle.getConnectionProperty();
            CancelTaskRequest request = new CancelTaskRequest();
            request.setProjectName(connectionProperty.getComputeProject());
            request.setOpTenantId(connectionProperty.getTenantId());
            request.setSessionId(connHandle.getSessionId());
            if (connectionProperty.getDelegationUid() != null) {
                request.setOpUserId(connectionProperty.getDelegationUid());
            }
            request.setTaskId(this.taskId);
            Client dataphinAcsClient = connHandle.getDataphinAcsClient();
            try {
                dataphinAcsClient.cancelTaskWithOptions(request, connHandle.getDataphinClientOptions());
            }
            catch (Exception e) {
                String errorMessage = String.format("Close resultSet failed, detail : %s", e.getMessage());
                logger.debug(errorMessage, e);
                this.dataphinJdbcConsoleLogger.error(errorMessage);
            }
            this.isClosed = true;
            this.getStatement().close();
        }
    }

    @Override
    public boolean wasNull() throws SQLException {
        return this.wasNull;
    }

    @Override
    public String getString(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        return String.valueOf(obj);
    }

    @Override
    public boolean getBoolean(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return false;
        }
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            return !((String)obj).equals("0");
        }
        throw new SQLException("Illegal conversion to boolean from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public byte getByte(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).byteValue();
        }
        throw new SQLException("Illegal conversion to byte from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public short getShort(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj instanceof Number) {
            return ((Number)obj).shortValue();
        }
        if (obj == null) {
            return 0;
        }
        if (obj instanceof String) {
            try {
                return Short.parseShort((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public int getInt(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue();
        }
        if (obj instanceof String) {
            try {
                return Integer.parseInt((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public long getLong(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0L;
        }
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to long from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to long from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public float getFloat(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0f;
        }
        if (obj instanceof Number) {
            return ((Number)obj).floatValue();
        }
        if (obj instanceof String) {
            try {
                return Float.parseFloat((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to float from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to float from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public double getDouble(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return 0.0;
        }
        if (obj instanceof Number) {
            return ((Number)obj).doubleValue();
        }
        if (obj instanceof String) {
            try {
                return Double.parseDouble((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to double from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to double from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        throw new SQLException("Illegal conversion to BigDecimal from column " + columnIndex + " [" + val + "]");
    }

    @Override
    public byte[] getBytes(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val == null) {
            return null;
        }
        if (val instanceof byte[]) {
            return (byte[])val;
        }
        return val.toString().getBytes();
    }

    @Override
    public Date getDate(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Date) {
            return (Date)obj;
        }
        if (obj instanceof String) {
            try {
                return Date.valueOf((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to Date from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        if (obj instanceof Timestamp) {
            try {
                return new Date(((Timestamp)obj).getTime());
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to Date from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to Date from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof Timestamp) {
            return (Timestamp)obj;
        }
        if (obj instanceof String) {
            try {
                return Timestamp.valueOf((String)obj);
            }
            catch (Exception e) {
                throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]", e);
            }
        }
        throw new SQLException("Illegal conversion to int from column " + columnIndex + " [" + obj + "]");
    }

    @Override
    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        Object obj = this.getObject(columnIndex);
        if (obj == null) {
            return null;
        }
        if (obj instanceof InputStream) {
            return (InputStream)obj;
        }
        if (obj instanceof byte[]) {
            byte[] byteArray = (byte[])obj;
            return new ByteArrayInputStream(byteArray);
        }
        if (obj instanceof String) {
            String str = (String)obj;
            return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
        }
        String str = obj.toString();
        return new ByteArrayInputStream(str.getBytes(StandardCharsets.UTF_8));
    }

    @Override
    public String getString(String columnLabel) throws SQLException {
        return this.getString(this.findColumn(columnLabel));
    }

    @Override
    public boolean getBoolean(String columnLabel) throws SQLException {
        return this.getBoolean(this.findColumn(columnLabel));
    }

    @Override
    public byte getByte(String columnLabel) throws SQLException {
        return this.getByte(this.findColumn(columnLabel));
    }

    @Override
    public short getShort(String columnLabel) throws SQLException {
        return this.getShort(this.findColumn(columnLabel));
    }

    @Override
    public int getInt(String columnLabel) throws SQLException {
        return this.getInt(this.findColumn(columnLabel));
    }

    @Override
    public long getLong(String columnLabel) throws SQLException {
        return this.getLong(this.findColumn(columnLabel));
    }

    @Override
    public float getFloat(String columnLabel) throws SQLException {
        return this.getFloat(this.findColumn(columnLabel));
    }

    @Override
    public double getDouble(String columnLabel) throws SQLException {
        return this.getDouble(this.findColumn(columnLabel));
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public byte[] getBytes(String columnLabel) throws SQLException {
        return this.getBytes(this.findColumn(columnLabel));
    }

    @Override
    public Date getDate(String columnLabel) throws SQLException {
        return this.getDate(this.findColumn(columnLabel));
    }

    @Override
    public Time getTime(String columnLabel) throws SQLException {
        return this.getTime(this.findColumn(columnLabel));
    }

    @Override
    public Timestamp getTimestamp(String columnLabel) throws SQLException {
        return this.getTimestamp(this.findColumn(columnLabel));
    }

    @Override
    public InputStream getAsciiStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public InputStream getUnicodeStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public InputStream getBinaryStream(String columnLabel) throws SQLException {
        return this.getBinaryStream(this.findColumn(columnLabel));
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public String getCursorName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSetMetaData getMetaData() throws SQLException {
        return this.metaData;
    }

    @Override
    public Object getObject(int columnIndex) throws SQLException {
        return this.getColumnValue(columnIndex);
    }

    @Override
    public Object getObject(String columnLabel) throws SQLException {
        return this.getObject(this.findColumn(columnLabel));
    }

    @Override
    public int findColumn(String columnLabel) throws SQLException {
        int index = this.metaData.getColumnIndex(columnLabel);
        if (index == -1) {
            throw new SQLException("the column label is invalid");
        }
        return index;
    }

    @Override
    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Reader getCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        Object val = this.getObject(columnIndex);
        if (val == null) {
            return null;
        }
        if (val instanceof BigDecimal) {
            return (BigDecimal)val;
        }
        throw new SQLException("Illegal conversion to BigDecimal from column " + columnIndex + " [" + val + "]");
    }

    @Override
    public BigDecimal getBigDecimal(String columnLabel) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnLabel));
    }

    @Override
    public boolean isBeforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isAfterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void beforeFirst() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void afterLast() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean first() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean last() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean absolute(int row) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean relative(int rows) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean previous() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        if (this.fetchSize > 0) {
            this.fetchSize = rows;
        }
    }

    @Override
    public int getFetchSize() throws SQLException {
        return this.fetchSize;
    }

    @Override
    public int getType() throws SQLException {
        return 1003;
    }

    @Override
    public int getConcurrency() throws SQLException {
        return 1007;
    }

    @Override
    public boolean rowUpdated() throws SQLException {
        return false;
    }

    @Override
    public boolean rowInserted() throws SQLException {
        return false;
    }

    @Override
    public boolean rowDeleted() throws SQLException {
        return false;
    }

    @Override
    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNull(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBoolean(String columnLabel, boolean x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateByte(String columnLabel, byte x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateShort(String columnLabel, short x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateInt(String columnLabel, int x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateLong(String columnLabel, long x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateFloat(String columnLabel, float x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateDouble(String columnLabel, double x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBigDecimal(String columnLabel, BigDecimal x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateString(String columnLabel, String x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBytes(String columnLabel, byte[] x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateDate(String columnLabel, Date x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateTime(String columnLabel, Time x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateTimestamp(String columnLabel, Timestamp x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, int length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x, int scaleOrLength) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateObject(String columnLabel, Object x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void insertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void deleteRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void refreshRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void cancelRowUpdates() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void moveToInsertRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void moveToCurrentRow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Statement getStatement() throws SQLException {
        return this.sdkStatement;
    }

    @Override
    public Object getObject(int columnIndex, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Ref getRef(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob getBlob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Clob getClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Array getArray(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Object getObject(String columnLabel, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Ref getRef(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob getBlob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Clob getClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Array getArray(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Date getDate(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Time getTime(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Timestamp getTimestamp(String columnLabel, Calendar cal) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public URL getURL(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateRef(String columnLabel, Ref x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(String columnLabel, Blob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(String columnLabel, Clob x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateArray(String columnLabel, Array x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public RowId getRowId(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public RowId getRowId(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateRowId(int columnIndex, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateRowId(String columnLabel, RowId x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void updateNString(int columnIndex, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNString(String columnLabel, String nString) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(int columnIndex, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(String columnLabel, NClob nClob) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob getNClob(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob getNClob(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML getSQLXML(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateSQLXML(int columnIndex, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateSQLXML(String columnLabel, SQLXML xmlObject) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getNString(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getNString(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Reader getNCharacterStream(int columnIndex) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Reader getNCharacterStream(String columnLabel) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader, long length) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(int columnIndex, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(int columnIndex, Reader x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateAsciiStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBinaryStream(String columnLabel, InputStream x) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateCharacterStream(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(int columnIndex, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateBlob(String columnLabel, InputStream inputStream) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(int columnIndex, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void updateNClob(String columnLabel, Reader reader) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T getObject(int columnIndex, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T getObject(String columnLabel, Class<T> type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    private Object getColumnValue(int columnIndex) throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("No row found.");
        }
        if (columnIndex <= 0 || columnIndex > this.currentRow.size()) {
            String message = String.format("Invalid columnIndex: %d, row size: %d, data: %s", columnIndex, this.currentRow.size(), this.currentRow.toString());
            this.dataphinJdbcConsoleLogger.error(message);
            throw new SQLException("Invalid columnIndex: " + columnIndex);
        }
        int columnType = this.metaData.getColumnType(columnIndex);
        Object value = this.currentRow.get(columnIndex - 1);
        try {
            return JdbcColumn.evaluate(columnType, value);
        }
        catch (Throwable e) {
            e.printStackTrace();
            String valueType = "NULL";
            if (value != null) {
                valueType = value.getClass().getName();
            }
            String message = String.format("Unrecognized column type: %d, value type: %s, value: %s", columnType, valueType, value);
            logger.error(message);
            this.dataphinJdbcConsoleLogger.error(message);
            String currentRowData = "Current Row Data: " + this.currentRow.toString();
            this.dataphinJdbcConsoleLogger.error(currentRowData);
            throw new SQLException(message, e);
        }
    }
}

