/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.utils.StringUtil;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class DataphinDriver
implements Driver {
    public static final String PRODUCT_NAME = "Dataphin";
    public static final String DRIVER_NAME = "Dataphin JDBC Driver";
    public static final String URL_PREFIX = "jdbc:dataphin://";
    public static final String DEFAULT_CATALOG = "default";

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return this.acceptsURL(url) ? new DataphinConnection(url, info) : null;
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:dataphin://.*", url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return new DriverPropertyInfo[0];
    }

    @Override
    public int getMajorVersion() {
        return StringUtil.getVersionPart(DataphinDriver.getFullDriverVersion(), 0);
    }

    @Override
    public int getMinorVersion() {
        return StringUtil.getVersionPart(DataphinDriver.getFullDriverVersion(), 1);
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return Logger.getLogger("com.aliyun.dataphin.jdbc");
    }

    static String getFullDriverVersion() {
        return DataphinDriver.class.getPackage().getImplementationVersion();
    }

    static {
        try {
            DriverManager.registerDriver(new DataphinDriver());
        }
        catch (SQLException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

