/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ConnectionProperty;
import com.aliyun.dataphin.jdbc.DataphinDatabaseMetaData;
import com.aliyun.dataphin.jdbc.DataphinPrepareStatement;
import com.aliyun.dataphin.jdbc.DataphinStatement;
import com.aliyun.dataphin.jdbc.logger.DataphinJdbcConsoleLogger;
import com.aliyun.dataphin.jdbc.utils.GsonUtil;
import com.aliyun.dataphin.jdbc.utils.ResponseStatusCheckUtils;
import com.aliyun.dataphin_public20230630.Client;
import com.aliyun.dataphin_public20230630.models.CloseJdbcConnectionRequest;
import com.aliyun.dataphin_public20230630.models.CreateJdbcConnectionRequest;
import com.aliyun.dataphin_public20230630.models.CreateJdbcConnectionResponse;
import com.aliyun.dataphin_public20230630.models.GetDataSourceByCatalogForJdbcRequest;
import com.aliyun.dataphin_public20230630.models.GetDataSourceByCatalogForJdbcResponse;
import com.aliyun.dataphin_public20230630.models.GetDataSourceByCatalogForJdbcResponseBody;
import com.aliyun.dataphin_public20230630.models.GetServerVersionRequest;
import com.aliyun.dataphin_public20230630.models.GetServerVersionResponse;
import com.aliyun.teaopenapi.models.Config;
import com.aliyun.teautil.models.RuntimeOptions;
import com.aliyuncs.dataphin.DataphinAcsClient;
import com.aliyuncs.dataphin.model.v20200830.inner.FindUserBySourceRequest;
import com.aliyuncs.dataphin.model.v20200830.inner.FindUserBySourceResponse;
import com.aliyuncs.dataphin.model.v20200830.inner.FindUsersByAccountNameRequest;
import com.aliyuncs.dataphin.model.v20200830.inner.FindUsersByAccountNameResponse;
import com.aliyuncs.http.HttpClientConfig;
import com.aliyuncs.http.ProtocolType;
import com.aliyuncs.profile.DefaultProfile;
import com.dp.google.gson.Gson;
import com.google.common.collect.Lists;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.commons.lang3.StringUtils;

public class DataphinConnection
implements Connection {
    private static final Logger log = LoggerFactory.getLogger(DataphinConnection.class);
    public static final String DATA_SOURCE_CODE_PREFIX = "ds_";
    private boolean isClosed = false;
    private static final String DEFAULT_SESSION = "default_session";
    public static final String DP_USER_ID_PREFIX = "DATAPHIN_USERID_";
    private final List<Statement> stmtHandles;
    private final ConnectionProperty connectionProperty;
    private Properties clientInfo;
    private SQLWarning warningChain = null;
    private String sessionId;
    private final DataphinAcsClient dataphinInnerAcsClient;
    private final Client dataphinAcsV2Client;
    private final RuntimeOptions options;
    private final DataphinJdbcConsoleLogger dataphinJdbcConsoleLogger;

    DataphinConnection(String url, Properties properties) throws SQLException {
        ConnectionProperty connectionProperty = new ConnectionProperty(url, properties);
        this.dataphinJdbcConsoleLogger = new DataphinJdbcConsoleLogger(DataphinConnection.class.getName(), DEFAULT_SESSION, connectionProperty.getLogLevel(), true);
        this.stmtHandles = Lists.newArrayList();
        this.clientInfo = properties;
        this.connectionProperty = connectionProperty;
        this.dataphinInnerAcsClient = this.createForInner(connectionProperty);
        this.dataphinAcsV2Client = this.createAcsV2Client(connectionProperty);
        this.options = new RuntimeOptions().setConnectTimeout(5000).setReadTimeout(600000).setIgnoreSSL(true);
        this.setConnectionType(connectionProperty);
        if (connectionProperty.accountTypeIsAccountName()) {
            this.delegationUidTransformFromAccountName();
        } else if (connectionProperty.accountTypeIsSourceAccountId()) {
            this.delegationUidTransformFromSourceUserId();
        }
        this.createJDBCConnection();
    }

    private void setConnectionType(ConnectionProperty connectionProperty) throws SQLException {
        String projectOrDsCode = connectionProperty.getProjectOrDsCode();
        if (StringUtils.isNotBlank(projectOrDsCode)) {
            if (projectOrDsCode.toLowerCase().startsWith(DATA_SOURCE_CODE_PREFIX)) {
                GetDataSourceByCatalogForJdbcResponseBody.GetDataSourceByCatalogForJdbcResponseBodyDataSourceInfo dataSourceInfo;
                GetDataSourceByCatalogForJdbcRequest request = new GetDataSourceByCatalogForJdbcRequest();
                request.setCatalog(projectOrDsCode);
                request.setOpTenantId(connectionProperty.getTenantId());
                try {
                    GetDataSourceByCatalogForJdbcResponse response = this.dataphinAcsV2Client.getDataSourceByCatalogForJdbcWithOptions(request, this.options);
                    ResponseStatusCheckUtils.checkStatus(response);
                    dataSourceInfo = response.getBody().getDataSourceInfo();
                }
                catch (Exception e) {
                    log.error("Get datasource config error.", e);
                    String message = "Get datasource config error, detail: " + e.getMessage();
                    this.dataphinJdbcConsoleLogger.error(message, e);
                    throw new SQLException(message);
                }
                if (dataSourceInfo != null) {
                    connectionProperty.setConnectionType(ConnectionProperty.ConnectionType.DATA_SOURCE_CONNECTION);
                } else {
                    connectionProperty.setConnectionType(ConnectionProperty.ConnectionType.PROJECT_CONNECTION);
                }
            } else {
                connectionProperty.setConnectionType(ConnectionProperty.ConnectionType.PROJECT_CONNECTION);
            }
        }
    }

    private DataphinAcsClient createForInner(ConnectionProperty connectionProperty) {
        return this.create("dataphin", connectionProperty);
    }

    private DataphinAcsClient create(String productCode, ConnectionProperty connectionProperty) {
        boolean usingSSL = false;
        String endpoint = connectionProperty.getHost();
        String accessKey = connectionProperty.getUser();
        String secret = connectionProperty.getPassword();
        String regionId = connectionProperty.getRegionId();
        if (endpoint.toLowerCase().startsWith("http://")) {
            endpoint = endpoint.substring(7);
        } else if (endpoint.toLowerCase().startsWith("https://")) {
            usingSSL = true;
            endpoint = endpoint.substring(8);
        }
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        DefaultProfile.addEndpoint(regionId, productCode, endpoint);
        DefaultProfile profile = DefaultProfile.getProfile(regionId, accessKey, secret);
        HttpClientConfig httpClientConfig = HttpClientConfig.getDefault();
        httpClientConfig.setMaxRequestsPerHost(1000);
        httpClientConfig.setReadTimeoutMillis(connectionProperty.getReadTimeout());
        httpClientConfig.setIgnoreSSLCerts(true);
        if (connectionProperty.getUseProxy().booleanValue()) {
            if (usingSSL) {
                httpClientConfig.setHttpsProxy(String.format("https://%s:%s", connectionProperty.getProxyServer(), connectionProperty.getProxyPort()));
            } else {
                httpClientConfig.setHttpProxy(String.format("http://%s:%s", connectionProperty.getProxyServer(), connectionProperty.getProxyPort()));
            }
        }
        profile.setHttpClientConfig(httpClientConfig);
        DataphinAcsClient acsClient = new DataphinAcsClient(profile);
        if (usingSSL) {
            acsClient.setSysProtocol(ProtocolType.HTTPS);
        } else {
            acsClient.setSysProtocol(ProtocolType.HTTP);
        }
        return acsClient;
    }

    private Client createAcsV2Client(ConnectionProperty connectionProperty) throws SQLException {
        boolean usingSSL = false;
        String endpoint = connectionProperty.getHost();
        String accessKey = connectionProperty.getUser();
        String secret = connectionProperty.getPassword();
        String regionId = connectionProperty.getRegionId();
        if (endpoint.toLowerCase().startsWith("http://")) {
            endpoint = endpoint.substring(7);
        } else if (endpoint.toLowerCase().startsWith("https://")) {
            usingSSL = true;
            endpoint = endpoint.substring(8);
        }
        if (endpoint.endsWith("/")) {
            endpoint = endpoint.substring(0, endpoint.length() - 1);
        }
        Config config = new Config().setAccessKeyId(accessKey).setAccessKeySecret(secret).setEndpoint(endpoint);
        config.setRegionId(regionId);
        if (usingSSL) {
            config.setProtocol(ProtocolType.HTTPS.name());
        } else {
            config.setProtocol(ProtocolType.HTTP.name());
        }
        if (connectionProperty.getUseProxy().booleanValue()) {
            if (usingSSL) {
                config.setHttpsProxy(String.format("https://%s:%s", connectionProperty.getProxyServer(), connectionProperty.getProxyPort()));
            } else {
                config.setHttpProxy(String.format("http://%s:%s", connectionProperty.getProxyServer(), connectionProperty.getProxyPort()));
            }
        }
        try {
            return new Client(config);
        }
        catch (Exception e) {
            String message = "Create JDBC Connection error, detail: ." + e.getMessage();
            this.dataphinJdbcConsoleLogger.error(message, e);
            throw new RuntimeException(message);
        }
    }

    private void createJDBCConnection() throws SQLException {
        CreateJdbcConnectionRequest createJdbcConnectionRequest = new CreateJdbcConnectionRequest();
        createJdbcConnectionRequest.setProjectName(this.connectionProperty.getComputeProject());
        createJdbcConnectionRequest.setOpTenantId(this.connectionProperty.getTenantId());
        HashMap<String, String> properties = new HashMap<String, String>();
        if (StringUtils.isNotEmpty(this.connectionProperty.getEngine())) {
            properties.put("engine", this.connectionProperty.getEngine());
        }
        if (StringUtils.isNotEmpty(this.connectionProperty.getCurrentSchema())) {
            properties.put("currentschema", this.connectionProperty.getCurrentSchema());
            properties.put("current_schema", this.connectionProperty.getCurrentSchema());
        }
        if (StringUtils.isNotBlank(this.connectionProperty.getAccelerationSource())) {
            properties.put("acceleration_source", this.connectionProperty.getAccelerationSource());
            properties.put("acceleration_resource_group", this.connectionProperty.getAccelerationResourceGroup());
        }
        if (!properties.isEmpty()) {
            Gson gson = GsonUtil.buildGson();
            createJdbcConnectionRequest.setProperties(gson.toJson(properties));
        }
        if (this.connectionProperty.getDelegationUid() != null) {
            createJdbcConnectionRequest.setOpUserId(this.connectionProperty.getDelegationUid());
        }
        if (StringUtils.isNotEmpty(this.connectionProperty.getComputeProject())) {
            properties.put("compute_project", this.connectionProperty.getComputeProject());
        }
        try {
            CreateJdbcConnectionResponse response = this.dataphinAcsV2Client.createJdbcConnectionWithOptions(createJdbcConnectionRequest, this.options);
            ResponseStatusCheckUtils.checkStatus(response);
            this.sessionId = response.getBody().getSessionId();
        }
        catch (Exception e) {
            String message = "Create JDBC Connection error, detail: ." + e.getMessage();
            this.dataphinJdbcConsoleLogger.error(message, e);
            throw new SQLException(message);
        }
    }

    private void delegationUidTransformFromAccountName() throws SQLException {
        FindUsersByAccountNameRequest listUsersRequest = new FindUsersByAccountNameRequest();
        listUsersRequest.setOpTenantId(this.connectionProperty.getTenantId());
        listUsersRequest.setAccountName(this.connectionProperty.getDelegationUid());
        try {
            List<FindUsersByAccountNameResponse.User> userList;
            FindUsersByAccountNameResponse listUsersResponse = this.dataphinInnerAcsClient.getAcsResponse(listUsersRequest);
            ResponseStatusCheckUtils.checkStatus(listUsersResponse);
            if (listUsersResponse != null && listUsersResponse.getData() != null) {
                userList = listUsersResponse.getData();
                if (userList.isEmpty()) {
                    String message = "Not found user by account_name, please check.";
                    this.dataphinJdbcConsoleLogger.error(message);
                    throw new SQLException(message);
                }
                if (userList.size() > 1) {
                    String message = String.format("Found %d user by account_name, only need 1 user, please check.", userList.size());
                    this.dataphinJdbcConsoleLogger.error(message);
                    throw new SQLException(message);
                }
            } else {
                String message = "Get delegationUid by account_name error, Client response is null";
                this.dataphinJdbcConsoleLogger.error(message);
                throw new SQLException(message);
            }
            this.connectionProperty.setDelegationUid(userList.get(0).getUserId());
        }
        catch (Exception e) {
            this.dataphinJdbcConsoleLogger.error("Get delegationUid by account_name error", e);
            throw new SQLException("Get delegationUid by account_name error", e);
        }
    }

    private void delegationUidTransformFromSourceUserId() throws SQLException {
        FindUserBySourceRequest userBySourceRequest = new FindUserBySourceRequest();
        userBySourceRequest.setOpTenantId(this.connectionProperty.getTenantId());
        userBySourceRequest.setSourceUserId(this.connectionProperty.getDelegationUid());
        userBySourceRequest.setAccountSourceType("source");
        try {
            FindUserBySourceResponse.UserDTO user;
            FindUserBySourceResponse userBySourceResponse = this.dataphinInnerAcsClient.getAcsResponse(userBySourceRequest);
            ResponseStatusCheckUtils.checkStatus(userBySourceResponse);
            if (userBySourceResponse != null && userBySourceResponse.getData() != null) {
                user = userBySourceResponse.getData();
                if (user == null) {
                    String message = "Not found user by source_user_id, please check.";
                    this.dataphinJdbcConsoleLogger.error(message);
                    throw new SQLException(message);
                }
            } else {
                String message = "Get delegationUid by source_user_id error, Client response is null";
                this.dataphinJdbcConsoleLogger.error(message);
                throw new SQLException(message);
            }
            this.connectionProperty.setDelegationUid(user.getUserId());
        }
        catch (Exception e) {
            this.dataphinJdbcConsoleLogger.error("Get delegationUid by source_user_id error", e);
            throw new SQLException("Get delegationUid by source_user_id error", e);
        }
    }

    public String getServerVersion() throws SQLException {
        GetServerVersionRequest request = new GetServerVersionRequest();
        request.setOpTenantId(this.connectionProperty.getTenantId());
        if (this.connectionProperty.getDelegationUid() != null) {
            request.setOpUserId(this.connectionProperty.getDelegationUid());
        }
        try {
            GetServerVersionResponse response = this.dataphinAcsV2Client.getServerVersionWithOptions(request, this.options);
            ResponseStatusCheckUtils.checkStatus(response);
            return response.getBody().getData();
        }
        catch (Exception e) {
            this.dataphinJdbcConsoleLogger.error("get server version error", e);
            throw new SQLException("get server version error", e);
        }
    }

    public void changCurrentUser(String userId) {
        if (StringUtils.isNotBlank(userId)) {
            this.connectionProperty.setDelegationUid(userId);
        }
    }

    public Client getDataphinAcsClient() {
        return this.dataphinAcsV2Client;
    }

    public RuntimeOptions getDataphinClientOptions() {
        return this.options;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        DataphinStatement stmt = new DataphinStatement(this);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        DataphinPrepareStatement prepareStatement = new DataphinPrepareStatement(this, sql);
        this.stmtHandles.add(prepareStatement);
        return prepareStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Method not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void close() throws SQLException {
        CloseJdbcConnectionRequest closeJdbcConnectionRequest = new CloseJdbcConnectionRequest();
        closeJdbcConnectionRequest.setProjectName(this.connectionProperty.getComputeProject());
        closeJdbcConnectionRequest.setOpTenantId(this.connectionProperty.getTenantId());
        if (this.connectionProperty.getDelegationUid() != null) {
            closeJdbcConnectionRequest.setOpUserId(this.connectionProperty.getDelegationUid());
        }
        closeJdbcConnectionRequest.setSessionId(this.sessionId);
        try {
            this.dataphinAcsV2Client.closeJdbcConnectionWithOptions(closeJdbcConnectionRequest, this.options);
            this.isClosed = true;
            this.dataphinJdbcConsoleLogger.info(String.format("Connection %s closed.", this.sessionId));
        }
        catch (Exception e) {
            this.dataphinJdbcConsoleLogger.error("Close JDBC Connection error", e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new DataphinDatabaseMetaData(this);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (readOnly) {
            throw new SQLException("Enabling read-only mode not supported");
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() {
        if (this.connectionProperty.getConnectionType() == ConnectionProperty.ConnectionType.PROJECT_CONNECTION) {
            return "default";
        }
        return this.connectionProperty.getProjectOrDsCode();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public DataphinStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetType != 1005) {
            throw new SQLFeatureNotSupportedException("Statement with resultset type " + resultSetType + " is not supported");
        }
        if (resultSetConcurrency != 1007) {
            throw new SQLFeatureNotSupportedException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported");
        }
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        DataphinStatement stmt = new DataphinStatement(this);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Can't create Statement, connection is closed");
        }
        DataphinPrepareStatement prepareStatement = new DataphinPrepareStatement(this, sql);
        this.stmtHandles.add(prepareStatement);
        return prepareStatement;
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        this.checkClosed();
        return new DataphinPrepareStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        this.checkClosed();
        return new DataphinPrepareStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        this.checkClosed();
        return new DataphinPrepareStatement(this, sql);
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("timeout value was negative");
        }
        return !this.isClosed;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        this.clientInfo.put(name, value);
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
        this.clientInfo = properties;
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        if (this.clientInfo == null) {
            return null;
        }
        return this.clientInfo.getProperty(name);
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return this.clientInfo;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        this.checkClosed();
        if (this.connectionProperty.getConnectionType() == ConnectionProperty.ConnectionType.PROJECT_CONNECTION) {
            return this.getConnectionProperty().getProjectOrDsCode();
        }
        if (StringUtils.isNotEmpty(this.getConnectionProperty().getCurrentSchema())) {
            return this.getConnectionProperty().getCurrentSchema();
        }
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("the connection has already been closed");
        }
    }

    public ConnectionProperty getConnectionProperty() {
        return this.connectionProperty;
    }

    public String getSessionId() {
        return this.sessionId;
    }
}

