/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import com.aliyun.dataphin.jdbc.ConnectionProperty;
import com.aliyun.dataphin.jdbc.DataphinBaseMetaResultSet;
import com.aliyun.dataphin.jdbc.DataphinConnection;
import com.aliyun.dataphin.jdbc.JdbcColumn;
import com.aliyun.dataphin.jdbc.utils.ResponseStatusCheckUtils;
import com.aliyun.dataphin.jdbc.utils.StringUtil;
import com.aliyun.dataphin.jdbc.utils.TableNameUtils;
import com.aliyun.dataphin_public20230630.Client;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesRequest;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesResponse;
import com.aliyun.dataphin_public20230630.models.ListCatalogTablesResponseBody;
import com.aliyun.teautil.models.RuntimeOptions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dataphin.org.slf4j.Logger;
import dataphin.org.slf4j.LoggerFactory;
import java.sql.SQLException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class DataphinColumnMetaResultSet
extends DataphinBaseMetaResultSet {
    private static final Logger logger = LoggerFactory.getLogger(DataphinColumnMetaResultSet.class);
    private final String catalog;
    private final String schemaPattern;
    private final String tableNamePattern;
    private final String columnNamePattern;
    private List<ListCatalogTablesResponseBody.ListCatalogTablesResponseBodyPaginatedResultDataColumns> batchResults;
    private List<String> matchSchemaList;
    private int currentPageNum = 1;
    private int currentOffset = 0;
    private int schemaOffset = 0;
    private Boolean hasNextPage = false;

    public DataphinColumnMetaResultSet(DataphinConnection connection, String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) {
        super(connection);
        this.catalog = catalog;
        this.fetchSize = 10;
        this.schemaPattern = schemaPattern;
        this.tableNamePattern = tableNamePattern;
        this.columnNamePattern = columnNamePattern;
    }

    @Override
    Map<String, String> listMetaColumns() {
        LinkedHashMap<String, String> metaMap = Maps.newLinkedHashMap();
        metaMap.put("TABLE_CAT", "STRING");
        metaMap.put("TABLE_SCHEM", "STRING");
        metaMap.put("TABLE_NAME", "STRING");
        metaMap.put("COLUMN_NAME", "STRING");
        metaMap.put("DATA_TYPE", "INT");
        metaMap.put("TYPE_NAME", "STRING");
        metaMap.put("COLUMN_SIZE", "INT");
        metaMap.put("BUFFER_LENGTH", "INT");
        metaMap.put("DECIMAL_DIGITS", "INT");
        metaMap.put("NULLABLE", "INT");
        metaMap.put("NUM_PREC_RADIX", "INT");
        metaMap.put("REMARKS", "STRING");
        metaMap.put("COLUMN_DEF", "STRING");
        metaMap.put("SQL_DATA_TYPE", "INT");
        metaMap.put("SQL_DATETIME_SUB", "INT");
        metaMap.put("CHAR_OCTET_LENGTH", "INT");
        metaMap.put("ORDINAL_POSITION", "INT");
        metaMap.put("IS_NULLABLE", "STRING");
        metaMap.put("SCOPE_CATALOG", "STRING");
        metaMap.put("SCOPE_SCHEMA", "STRING");
        metaMap.put("SCOPE_TABLE", "STRING");
        metaMap.put("SOURCE_DATA_TYPE", "SHORT");
        metaMap.put("IS_AUTOINCREMENT", "STRING");
        metaMap.put("IS_GENERATEDCOLUMN", "STRING");
        return metaMap;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        if (this.matchSchemaList == null) {
            this.fetchSchemas();
            if (this.matchSchemaList == null) {
                return false;
            }
        }
        if (this.batchResults == null) {
            this.fetchResult();
        }
        while (this.currentOffset >= this.batchResults.size()) {
            this.currentOffset = 0;
            if (!this.hasNextPage.booleanValue()) {
                ++this.schemaOffset;
            }
            if (this.schemaOffset >= this.matchSchemaList.size()) {
                return false;
            }
            this.fetchResult();
            if (this.batchResults.isEmpty()) continue;
        }
        ListCatalogTablesResponseBody.ListCatalogTablesResponseBodyPaginatedResultDataColumns column = this.batchResults.get(this.currentOffset);
        this.currentRow = this.tableInfoToRow(column);
        ++this.currentOffset;
        return true;
    }

    private void fetchResult() throws SQLException {
        ListCatalogTablesRequest fetchRequest = new ListCatalogTablesRequest();
        ConnectionProperty connectionProperty = this.connection.getConnectionProperty();
        fetchRequest.setOpTenantId(connectionProperty.getTenantId());
        if (connectionProperty.getDelegationUid() != null) {
            fetchRequest.setOpUserId(connectionProperty.getDelegationUid());
        }
        ListCatalogTablesRequest.ListCatalogTablesRequestTableQuery tableQuery = new ListCatalogTablesRequest.ListCatalogTablesRequestTableQuery();
        tableQuery.setCatalog(this.catalog);
        tableQuery.setSchema(this.matchSchemaList.get(this.schemaOffset));
        tableQuery.setNeedColumns(true);
        tableQuery.setPageSize(this.fetchSize);
        tableQuery.setPageNum(this.currentPageNum);
        if (TableNameUtils.isValidTableName(this.tableNamePattern)) {
            tableQuery.setKeyword(this.tableNamePattern);
        }
        fetchRequest.setTableQuery(tableQuery);
        try {
            Client client = this.connection.getDataphinAcsClient();
            RuntimeOptions options = this.connection.getDataphinClientOptions();
            ListCatalogTablesResponse response = client.listCatalogTablesWithOptions(fetchRequest, options);
            ResponseStatusCheckUtils.checkStatus(response);
            if (response.getBody() == null || response.getBody().getPaginatedResult() == null || response.getBody().getPaginatedResult().getData() == null) {
                String message = String.format("Fetch table column response is null, query info : %s.%s", this.schemaPattern, this.tableNamePattern);
                logger.warn(message);
                this.hasNextPage = false;
                this.batchResults = Lists.newArrayList();
                return;
            }
            this.hasNextPage = response.getBody().getPaginatedResult().getData().size() >= this.fetchSize;
            this.batchResults = response.getBody().getPaginatedResult().getData().stream().filter(t -> StringUtil.matchPattern(t.getName(), this.tableNamePattern)).flatMap(t -> t.getColumns().stream()).filter(t -> StringUtil.matchPattern(t.getName(), this.columnNamePattern)).collect(Collectors.toList());
            ++this.currentPageNum;
        }
        catch (Exception e) {
            String message = String.format("Fetch column list, query info : %s, error data: %s", tableQuery, e.getMessage());
            throw new SQLException(message);
        }
    }

    private void fetchSchemas() throws SQLException {
        this.matchSchemaList = this.fetchAllSchemas();
        if (this.matchSchemaList == null) {
            String message = String.format("Fetch schemas response null, query info : %s.%s", this.catalog, this.schemaPattern);
            this.dataphinJdbcConsoleLogger.info(message);
            logger.warn(message);
            return;
        }
        this.matchSchemaList = this.matchSchemaList.stream().filter(t -> StringUtil.matchPattern(t, this.schemaPattern)).collect(Collectors.toList());
    }

    private Object[] tableInfoToRow(ListCatalogTablesResponseBody.ListCatalogTablesResponseBodyPaginatedResultDataColumns column) {
        Object[] result = new Object[24];
        result[0] = this.catalog;
        result[1] = this.matchSchemaList.get(this.schemaOffset);
        result[2] = column.getTableName();
        result[3] = column.getName();
        result[4] = JdbcColumn.getJdbcType(column.getDataType() != null ? column.getDataType() : "string");
        result[5] = column.getDataType();
        result[11] = column.getDes();
        return result;
    }
}

