/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.dataphin.jdbc;

import java.net.URI;
import java.nio.charset.Charset;
import java.sql.SQLException;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.utils.URLEncodedUtils;

public class ConnectionProperty {
    private static final String JDBC_URL_PREFIX = "jdbc:";
    private static final String USER_URL_KEY = "user";
    private static final String PASSWORD_URL_KEY = "password";
    private static final String DELEGATION_UID_URL_KEY = "delegation_uid";
    private static final String REGION_ID_URL_KEY = "region_id";
    private static final String TENANT_ID_URL_KEY = "tenant_id";
    private static final String DEFAULT_REGION_ID = "default";
    private static final String SSL_URL_KEY = "ssl";
    private static final String ACCOUNT_TYPE_URL_KEY = "account_type";
    private static final String LOG_LEVEL_URL_KEY = "log_level";
    private static final String HTTP_URL_PREFIX = "http://";
    private static final String HTTPS_URL_PREFIX = "https://";
    private static final int HTTP_DEFAULT_PORT = 80;
    private static final int HTTPS_DEFAULT_PORT = 443;
    private static final String ACCOUNT_TYPE_SOURCE_USER_ID = "source_user_id";
    private static final String ACCOUNT_TYPE_ACCOUNT_NAME = "account_name";
    private static final String CONNECTION_TIMEOUT = "connect_timeout";
    private static final String READ_TIMEOUT = "read_timeout";
    public static final String ENGINE = "engine";
    public static final String CURRENT_SCHEMA = "currentschema";
    public static final String CURRENT_SCHEMA_V2 = "current_schema";
    public static final String COMPUTE_PROJECT = "compute_project";
    public static final String PROXY_SERVER = "proxy_server";
    public static final String PROXY_PORT = "proxy_port";
    public static final String ACCELERATION_SOURCE = "acceleration_source";
    public static final String ACCELERATION_RESOURCE_GROUP = "acceleration_resource_group";
    private String host;
    int port;
    private String projectOrDsCode;
    private String user;
    private String password;
    private String delegationUid;
    private String regionId;
    private Long tenantId;
    private String accountType;
    private boolean ssl;
    private Properties info;
    private String logLevel;
    private Long connectionTimeout = 10L;
    private Long readTimeout = 60000L;
    private String engine;
    private String currentSchema;
    private String accelerationSource;
    private String accelerationResourceGroup;
    private String computeProject;
    private Boolean useProxy = false;
    private String proxyServer;
    private String proxyPort;
    private ConnectionType connectionType;

    public ConnectionProperty(String url, Properties info) throws SQLException {
        this.initParamsFromUrl(url, info);
        this.info = info;
    }

    private void initParamsFromUrl(String url, Properties info) throws SQLException {
        if (!url.startsWith("jdbc:dataphin://")) {
            throw new SQLException("Bad URL format: Missing prefix jdbc:dataphin://");
        }
        url = url.substring(JDBC_URL_PREFIX.length());
        URI jdbcURI = URI.create(url);
        this.host = jdbcURI.getHost();
        this.port = jdbcURI.getPort();
        this.projectOrDsCode = jdbcURI.getPath();
        if (StringUtils.isNotEmpty(this.projectOrDsCode)) {
            this.projectOrDsCode = this.projectOrDsCode.substring(1);
        }
        if (StringUtils.isEmpty(this.projectOrDsCode)) {
            throw new SQLException(new IllegalArgumentException("Jdbc url missing project name or data source code"));
        }
        Properties urlParameters = new Properties();
        urlParameters.putAll((Map<?, ?>)info);
        URLEncodedUtils.parse(jdbcURI.getQuery(), Charset.defaultCharset()).forEach(t -> urlParameters.put(t.getName().toLowerCase(), t.getValue()));
        if (urlParameters.containsKey(SSL_URL_KEY)) {
            String sslStr = (String)urlParameters.get(SSL_URL_KEY);
            this.ssl = Boolean.parseBoolean(sslStr);
        } else {
            this.ssl = false;
        }
        if (this.port == -1) {
            this.port = this.ssl ? 443 : 80;
        }
        this.host = this.ssl ? String.format("%s%s", HTTPS_URL_PREFIX, this.host) : String.format("%s%s", HTTP_URL_PREFIX, this.host);
        if (!urlParameters.containsKey(USER_URL_KEY)) {
            throw new SQLException(new IllegalArgumentException(String.format("Jdbc url lack parameter: %s.", USER_URL_KEY)));
        }
        this.user = (String)urlParameters.get(USER_URL_KEY);
        if (!urlParameters.containsKey(PASSWORD_URL_KEY)) {
            throw new SQLException(new IllegalArgumentException(String.format("Jdbc url lack parameter: %s.", PASSWORD_URL_KEY)));
        }
        this.password = (String)urlParameters.get(PASSWORD_URL_KEY);
        if (urlParameters.containsKey(ACCOUNT_TYPE_URL_KEY)) {
            this.accountType = (String)urlParameters.get(ACCOUNT_TYPE_URL_KEY);
        }
        if (urlParameters.containsKey(DELEGATION_UID_URL_KEY)) {
            this.delegationUid = (String)urlParameters.get(DELEGATION_UID_URL_KEY);
            if (this.accountType == null) {
                this.accountType = ACCOUNT_TYPE_ACCOUNT_NAME;
            }
        }
        this.regionId = urlParameters.containsKey(REGION_ID_URL_KEY) ? (String)urlParameters.get(REGION_ID_URL_KEY) : DEFAULT_REGION_ID;
        if (!urlParameters.containsKey(TENANT_ID_URL_KEY)) {
            throw new SQLException(new IllegalArgumentException(String.format("Jdbc url lack parameter: %s.", TENANT_ID_URL_KEY)));
        }
        this.tenantId = Long.parseLong((String)urlParameters.get(TENANT_ID_URL_KEY));
        if (urlParameters.containsKey(LOG_LEVEL_URL_KEY)) {
            this.logLevel = (String)urlParameters.get(LOG_LEVEL_URL_KEY);
        }
        if (urlParameters.containsKey(CONNECTION_TIMEOUT)) {
            this.connectionTimeout = Long.parseLong((String)urlParameters.get(CONNECTION_TIMEOUT));
        }
        if (urlParameters.containsKey(READ_TIMEOUT)) {
            this.readTimeout = Long.parseLong((String)urlParameters.get(READ_TIMEOUT));
        }
        if (urlParameters.containsKey(ENGINE)) {
            this.engine = (String)urlParameters.get(ENGINE);
        }
        if (urlParameters.containsKey(CURRENT_SCHEMA)) {
            this.currentSchema = (String)urlParameters.get(CURRENT_SCHEMA);
        }
        if (urlParameters.containsKey(CURRENT_SCHEMA_V2)) {
            this.currentSchema = (String)urlParameters.get(CURRENT_SCHEMA_V2);
        }
        if (urlParameters.containsKey(COMPUTE_PROJECT)) {
            this.computeProject = (String)urlParameters.get(COMPUTE_PROJECT);
        }
        if (urlParameters.containsKey(PROXY_SERVER)) {
            this.proxyServer = (String)urlParameters.get(PROXY_SERVER);
        }
        if (urlParameters.containsKey(PROXY_PORT)) {
            this.proxyPort = (String)urlParameters.get(PROXY_PORT);
        }
        this.useProxy = StringUtils.isNotBlank(this.proxyServer) && StringUtils.isNotBlank(this.proxyPort);
        if (urlParameters.containsKey(ACCELERATION_SOURCE)) {
            this.accelerationSource = (String)urlParameters.get(ACCELERATION_SOURCE);
        }
        if (urlParameters.containsKey(ACCELERATION_RESOURCE_GROUP)) {
            this.accelerationResourceGroup = (String)urlParameters.get(ACCELERATION_RESOURCE_GROUP);
        }
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getProjectOrDsCode() {
        return this.projectOrDsCode;
    }

    public void setProjectOrDsCode(String projectOrDsCode) {
        this.projectOrDsCode = projectOrDsCode;
    }

    public String getUser() {
        return this.user;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDelegationUid() {
        return this.delegationUid;
    }

    public void setDelegationUid(String delegationUid) {
        this.delegationUid = delegationUid;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public void setRegionId(String regionId) {
        this.regionId = regionId;
    }

    public Long getTenantId() {
        return this.tenantId;
    }

    public void setTenantId(Long tenantId) {
        this.tenantId = tenantId;
    }

    public Properties getInfo() {
        return this.info;
    }

    public void setInfo(Properties info) {
        this.info = info;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public void setSsl(boolean ssl) {
        this.ssl = ssl;
    }

    public String getUrl() {
        return String.format("%s:%d", this.host, this.port);
    }

    public String getAccountType() {
        return this.accountType;
    }

    public void setAccountType(String accountType) {
        this.accountType = accountType;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    public boolean accountTypeIsAccountName() {
        return ACCOUNT_TYPE_ACCOUNT_NAME.equalsIgnoreCase(this.accountType);
    }

    public boolean accountTypeIsSourceAccountId() {
        return ACCOUNT_TYPE_SOURCE_USER_ID.equalsIgnoreCase(this.accountType);
    }

    public Long getConnectionTimeout() {
        return this.connectionTimeout;
    }

    public void setConnectionTimeout(Long connectionTimeout) {
        this.connectionTimeout = connectionTimeout;
    }

    public Long getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(Long readTimeout) {
        this.readTimeout = readTimeout;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public String getCurrentSchema() {
        return this.currentSchema;
    }

    public void setCurrentSchema(String currentSchema) {
        this.currentSchema = currentSchema;
    }

    public ConnectionType getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(ConnectionType connectionType) {
        this.connectionType = connectionType;
    }

    public String getComputeProject() {
        if (StringUtils.isNotBlank(this.computeProject) && ConnectionType.PROJECT_CONNECTION.equals((Object)this.connectionType)) {
            return this.computeProject;
        }
        return this.projectOrDsCode;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyServer() {
        return this.proxyServer;
    }

    public Boolean getUseProxy() {
        return this.useProxy;
    }

    public String getAccelerationSource() {
        return this.accelerationSource;
    }

    public String getAccelerationResourceGroup() {
        return this.accelerationResourceGroup;
    }

    public static enum ConnectionType {
        PROJECT_CONNECTION,
        DATA_SOURCE_CONNECTION;

    }
}

