/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.credentials;

import com.aliyun.credentials.exception.CredentialException;
import com.aliyun.credentials.models.Config;
import com.aliyun.credentials.models.CredentialModel;
import com.aliyun.credentials.provider.AlibabaCloudCredentialsProvider;
import com.aliyun.credentials.provider.DefaultCredentialsProvider;
import com.aliyun.credentials.provider.EcsRamRoleCredentialProvider;
import com.aliyun.credentials.provider.OIDCRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RamRoleArnCredentialProvider;
import com.aliyun.credentials.provider.RsaKeyPairCredentialProvider;
import com.aliyun.credentials.provider.StaticCredentialsProvider;
import com.aliyun.credentials.provider.URLCredentialProvider;
import com.aliyun.credentials.utils.StringUtils;
import com.aliyun.tea.utils.Validate;

public class Client {
    private final AlibabaCloudCredentialsProvider credentialsProvider;

    public Client() {
        this.credentialsProvider = new DefaultCredentialsProvider();
    }

    public Client(Config config) {
        this.credentialsProvider = null == config ? new DefaultCredentialsProvider() : this.getProvider(config);
    }

    public Client(AlibabaCloudCredentialsProvider provider) {
        this.credentialsProvider = provider;
    }

    private AlibabaCloudCredentialsProvider getProvider(Config config) {
        switch (config.type) {
            case "access_key": {
                return StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(config.accessKeyId, "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(config.accessKeySecret, "AccessKeySecret must not be null.", new Object[0])).type(config.type).providerName("static_ak").build()).build();
            }
            case "sts": {
                return StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(config.accessKeyId, "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(config.accessKeySecret, "AccessKeySecret must not be null.", new Object[0])).securityToken(Validate.notNull(config.securityToken, "SecurityToken must not be null.", new Object[0])).type(config.type).providerName("static_sts").build()).build();
            }
            case "bearer": {
                return StaticCredentialsProvider.builder().credential(CredentialModel.builder().bearerToken(Validate.notNull(config.bearerToken, "BearerToken must not be null.", new Object[0])).type(config.type).build()).build();
            }
            case "ecs_ram_role": {
                return EcsRamRoleCredentialProvider.builder().roleName(config.roleName).disableIMDSv1(config.disableIMDSv1).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
            }
            case "ram_role_arn": {
                StaticCredentialsProvider innerProvider = StringUtils.isEmpty(config.securityToken) ? StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(config.accessKeyId, "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(config.accessKeySecret, "AccessKeySecret must not be null.", new Object[0])).type("access_key").providerName("static_ak").build()).build() : StaticCredentialsProvider.builder().credential(CredentialModel.builder().accessKeyId(Validate.notNull(config.accessKeyId, "AccessKeyId must not be null.", new Object[0])).accessKeySecret(Validate.notNull(config.accessKeySecret, "AccessKeySecret must not be null.", new Object[0])).securityToken(Validate.notNull(config.securityToken, "SecurityToken must not be null.", new Object[0])).type("sts").providerName("static_sts").build()).build();
                return RamRoleArnCredentialProvider.builder().credentialsProvider(innerProvider).durationSeconds(config.roleSessionExpiration).roleArn(config.roleArn).roleSessionName(config.roleSessionName).policy(config.policy).STSEndpoint(config.STSEndpoint).externalId(config.externalId).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
            }
            case "rsa_key_pair": {
                return RsaKeyPairCredentialProvider.builder().publicKeyId(config.publicKeyId).privateKeyFile(config.privateKeyFile).durationSeconds(config.roleSessionExpiration).STSEndpoint(config.STSEndpoint).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
            }
            case "oidc_role_arn": {
                return OIDCRoleArnCredentialProvider.builder().durationSeconds(config.roleSessionExpiration).roleArn(config.roleArn).roleSessionName(config.roleSessionName).oidcProviderArn(config.oidcProviderArn).oidcTokenFilePath(config.oidcTokenFilePath).policy(config.policy).STSEndpoint(config.STSEndpoint).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
            }
            case "credentials_uri": {
                return URLCredentialProvider.builder().credentialsURI(config.credentialsURI).connectionTimeout(config.connectTimeout).readTimeout(config.timeout).build();
            }
        }
        throw new CredentialException("invalid type option, support: access_key, sts, ecs_ram_role, ram_role_arn, rsa_key_pair");
    }

    @Deprecated
    public String getAccessKeyId() {
        return this.credentialsProvider.getCredentials().getAccessKeyId();
    }

    @Deprecated
    public String getAccessKeySecret() {
        return this.credentialsProvider.getCredentials().getAccessKeySecret();
    }

    @Deprecated
    public String getSecurityToken() {
        return this.credentialsProvider.getCredentials().getSecurityToken();
    }

    @Deprecated
    public String getType() {
        return this.credentialsProvider.getCredentials().getType();
    }

    @Deprecated
    public String getBearerToken() {
        return this.credentialsProvider.getCredentials().getBearerToken();
    }

    public CredentialModel getCredential() {
        return this.credentialsProvider.getCredentials();
    }
}

