/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.util.MySqlUtils;

public class NumberUtils {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static float parseFloat(byte[] str, int off, int len) {
        double value;
        boolean small;
        long intVal;
        boolean negative;
        if (str == null) {
            throw new NumberFormatException();
        }
        if (len == 0 || off + len > str.length) {
            throw new NumberFormatException(new String(str, MySqlUtils.UTF8));
        }
        int end = off + len - 1;
        int i = off;
        byte ch = str[i];
        boolean bl = negative = ch == 45;
        if (ch == 45) {
            negative = true;
            ch = str[++i];
        } else if (ch == 43) {
            ch = str[++i];
        }
        if (ch == 46) {
            intVal = 0L;
        } else {
            if (ch < 48 || ch > 57) {
                throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            }
            intVal = ch - 48;
            while (i < end && (ch = str[++i]) >= 48 && ch <= 57) {
                intVal = intVal * 10L + (long)(ch - 48);
            }
        }
        boolean exp = false;
        long power = 1L;
        boolean bl2 = small = ch == 46;
        if (small) {
            if (i < end) {
                if ((ch = str[++i]) < 48 || ch > 57) throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
                intVal = intVal * 10L + (long)(ch - 48);
                power = 10L;
                while (i < end && (ch = str[++i]) >= 48 && ch <= 57) {
                    intVal = intVal * 10L + (long)(ch - 48);
                    power *= 10L;
                }
            } else if (len == 1) {
                throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            }
        } else if (ch == 101 || ch == 69) {
            exp = true;
        } else if (ch < 48 || ch > 57) {
            throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
        }
        if (!exp && len < 17 && i == end) {
            value = (double)intVal / (double)power;
            if (!negative) return (float)value;
            value = -value;
            return (float)value;
        } else {
            String text = new String(str, off, len, MySqlUtils.ASCII);
            value = Double.parseDouble(text);
        }
        return (float)value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static double parseDouble(byte[] str, int off, int len) {
        boolean small;
        long intVal;
        boolean negative;
        if (str == null) {
            throw new NumberFormatException();
        }
        if (len == 0) throw new NumberFormatException(new String(str, MySqlUtils.UTF8));
        if (off + len > str.length) {
            throw new NumberFormatException(new String(str, MySqlUtils.UTF8));
        }
        int end = off + len - 1;
        int i = off;
        byte ch = str[i];
        boolean bl = negative = ch == 45;
        if (ch == 45) {
            negative = true;
            ch = str[++i];
        } else if (ch == 43) {
            ch = str[++i];
        }
        if (ch == 46) {
            intVal = 0L;
        } else {
            if (ch < 48) throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            if (ch > 57) {
                throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            }
            intVal = ch - 48;
            while (i < end && (ch = str[++i]) >= 48 && ch <= 57) {
                intVal = intVal * 10L + (long)(ch - 48);
            }
        }
        boolean exp = false;
        long power = 1L;
        boolean bl2 = small = ch == 46;
        if (small) {
            if (i < end) {
                if ((ch = str[++i]) < 48) throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
                if (ch > 57) throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
                intVal = intVal * 10L + (long)(ch - 48);
                power = 10L;
                while (i < end && (ch = str[++i]) >= 48 && ch <= 57) {
                    intVal = intVal * 10L + (long)(ch - 48);
                    power *= 10L;
                }
            } else if (len == 1) {
                throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            }
        } else if (ch == 101 || ch == 69) {
            exp = true;
        } else {
            if (ch < 48) throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            if (ch > 57) {
                throw new NumberFormatException(new String(str, off, len, MySqlUtils.UTF8));
            }
        }
        if (!exp && len < 17 && i == end) {
            double value = (double)intVal / (double)power;
            if (!negative) return value;
            return -value;
        }
        String text = new String(str, off, len, MySqlUtils.ASCII);
        return Double.parseDouble(text);
    }
}

