/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.util;

import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.MySqlUtils;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import java.util.TimeZone;

public class Jdk8TimeUtils {
    public static Integer timestampDiff(long unitHash, String str1, String str2, TimeZone timeZone) {
        ChronoUnit unit = null;
        if (unitHash == FnvHash.Constants.DAY) {
            unit = ChronoUnit.DAYS;
        } else if (unitHash == FnvHash.Constants.MONTH) {
            unit = ChronoUnit.MONTHS;
        } else if (unitHash == FnvHash.Constants.HOUR) {
            unit = ChronoUnit.HOURS;
        } else if (unitHash == FnvHash.Constants.MINUTE) {
            unit = ChronoUnit.MINUTES;
        } else if (unitHash == FnvHash.Constants.SECOND) {
            unit = ChronoUnit.SECONDS;
        }
        if (unit == null) {
            return null;
        }
        Date d1 = MySqlUtils.parseDate(str1, timeZone);
        Date d2 = MySqlUtils.parseDate(str2, timeZone);
        if (d1 == null || d2 == null) {
            return null;
        }
        return (int)unit.between(d1.toInstant().atZone(timeZone.toZoneId()), d2.toInstant().atZone(timeZone.toZoneId()));
    }

    public static Integer dateDiff(String str0, String str1, TimeZone timeZone) {
        Date d0 = MySqlUtils.parseDate(str0, timeZone);
        Date d1 = MySqlUtils.parseDate(str1, timeZone);
        if (d0 == null || d1 == null) {
            return null;
        }
        ZoneId zoneId = timeZone != null ? timeZone.toZoneId() : ZoneId.systemDefault();
        ZonedDateTime zonedDateTime0 = d0.toInstant().atZone(zoneId).truncatedTo(ChronoUnit.DAYS);
        ZonedDateTime zonedDateTime1 = d1.toInstant().atZone(zoneId).truncatedTo(ChronoUnit.DAYS);
        return (int)ChronoUnit.DAYS.between(zonedDateTime1, zonedDateTime0);
    }

    public static Integer dateDiff1(long unitHash, String str1, String str2, TimeZone timeZone) {
        ChronoUnit unit = null;
        if (unitHash == FnvHash.Constants.DAY) {
            unit = ChronoUnit.DAYS;
        } else if (unitHash == FnvHash.Constants.MONTH) {
            unit = ChronoUnit.MONTHS;
        } else if (unitHash == FnvHash.Constants.HOUR) {
            unit = ChronoUnit.HOURS;
        } else if (unitHash == FnvHash.Constants.MINUTE) {
            unit = ChronoUnit.MINUTES;
        } else if (unitHash == FnvHash.Constants.SECOND) {
            unit = ChronoUnit.SECONDS;
        }
        if (unit == null) {
            return null;
        }
        Date d1 = MySqlUtils.parseDate(str1, timeZone);
        Date d2 = MySqlUtils.parseDate(str2, timeZone);
        if (d1 == null || d2 == null) {
            return null;
        }
        return (int)unit.between(d1.toInstant().atZone(timeZone.toZoneId()), d2.toInstant().atZone(timeZone.toZoneId()));
    }

    public static Integer monthBetween(String str1, String str2, TimeZone timeZone) {
        ChronoUnit unit = ChronoUnit.MONTHS;
        Date d1 = MySqlUtils.parseDate(str1, timeZone);
        Date d2 = MySqlUtils.parseDate(str2, timeZone);
        if (d1 == null || d2 == null) {
            return null;
        }
        return (int)unit.between(d1.toInstant().atZone(timeZone.toZoneId()), d2.toInstant().atZone(timeZone.toZoneId()));
    }

    public static String formatDateTime14(Instant instant, ZoneId zoneId) {
        ZonedDateTime zt = ZonedDateTime.ofInstant(instant, zoneId);
        int year = zt.get(ChronoField.YEAR);
        int month = zt.get(ChronoField.MONTH_OF_YEAR);
        int dayOfMonth = zt.get(ChronoField.DAY_OF_MONTH);
        int hour = zt.get(ChronoField.HOUR_OF_DAY);
        int minute = zt.get(ChronoField.MINUTE_OF_HOUR);
        int second = zt.get(ChronoField.SECOND_OF_MINUTE);
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), (char)(month / 10 + 48), (char)(month % 10 + 48), (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48), (char)(hour / 10 + 48), (char)(hour % 10 + 48), (char)(minute / 10 + 48), (char)(minute % 10 + 48), (char)(second / 10 + 48), (char)(second % 10 + 48)};
        return new String(chars);
    }

    public static String formatDateTime19(Instant instant, ZoneId zoneId) {
        ZonedDateTime zt = ZonedDateTime.ofInstant(instant, zoneId);
        int year = zt.get(ChronoField.YEAR);
        int month = zt.get(ChronoField.MONTH_OF_YEAR);
        int dayOfMonth = zt.get(ChronoField.DAY_OF_MONTH);
        int hour = zt.get(ChronoField.HOUR_OF_DAY);
        int minute = zt.get(ChronoField.MINUTE_OF_HOUR);
        int second = zt.get(ChronoField.SECOND_OF_MINUTE);
        char[] chars = new char[]{(char)(year / 1000 + 48), (char)(year / 100 % 10 + 48), (char)(year / 10 % 10 + 48), (char)(year % 10 + 48), '-', (char)(month / 10 + 48), (char)(month % 10 + 48), '-', (char)(dayOfMonth / 10 + 48), (char)(dayOfMonth % 10 + 48), ' ', (char)(hour / 10 + 48), (char)(hour % 10 + 48), ':', (char)(minute / 10 + 48), (char)(minute % 10 + 48), ':', (char)(second / 10 + 48), (char)(second % 10 + 48)};
        return new String(chars);
    }
}

