/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.protobuf;

import com.alibaba.fastsql.sql.ast.SQLDataType;
import com.alibaba.fastsql.sql.ast.statement.SQLColumnDefinition;
import com.alibaba.fastsql.sql.ast.statement.SQLCreateTableStatement;
import com.alibaba.fastsql.sql.ast.statement.SQLTableElement;
import com.alibaba.fastsql.support.protobuf.InvalidTypeException;
import com.alibaba.fastsql.util.FnvHash;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import java.sql.SQLException;

public class ProtobufUtils {
    public static Descriptors.Descriptor buildDescriptor(SQLCreateTableStatement stmt) throws SQLException {
        String tableName = stmt.getTableName();
        DescriptorProtos.DescriptorProto.Builder msgTypeBuilder = DescriptorProtos.DescriptorProto.newBuilder();
        msgTypeBuilder.setName(tableName);
        int fieldNum = 1;
        for (SQLTableElement element : stmt.getTableElementList()) {
            DescriptorProtos.FieldDescriptorProto.Type fieldType;
            if (!(element instanceof SQLColumnDefinition)) continue;
            SQLColumnDefinition column = (SQLColumnDefinition)element;
            DescriptorProtos.FieldDescriptorProto.Builder fieldBuilder = DescriptorProtos.FieldDescriptorProto.newBuilder();
            fieldBuilder.setName(column.getColumnName());
            SQLDataType dataType = column.getDataType();
            long dataTypeNameHashCode64 = dataType.nameHashCode64();
            if (dataTypeNameHashCode64 == FnvHash.Constants.INT) {
                fieldType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT32;
            } else if (dataTypeNameHashCode64 == FnvHash.Constants.BIGINT) {
                fieldType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_INT64;
            } else if (dataTypeNameHashCode64 == FnvHash.Constants.FLOAT) {
                fieldType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_FLOAT;
            } else if (dataTypeNameHashCode64 == FnvHash.Constants.DOUBLE) {
                fieldType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_DOUBLE;
            } else if (dataTypeNameHashCode64 == FnvHash.Constants.VARCHAR || dataTypeNameHashCode64 == FnvHash.Constants.NVARCHAR || dataTypeNameHashCode64 == FnvHash.Constants.CLOB || dataTypeNameHashCode64 == FnvHash.Constants.NCLOB || dataTypeNameHashCode64 == FnvHash.Constants.TEXT || dataTypeNameHashCode64 == FnvHash.Constants.TINYTEXT || dataTypeNameHashCode64 == FnvHash.Constants.MEDIUMTEXT || dataTypeNameHashCode64 == FnvHash.Constants.LONGTEXT || dataTypeNameHashCode64 == FnvHash.Constants.STRING || dataTypeNameHashCode64 == FnvHash.Constants.DECIMAL) {
                fieldType = DescriptorProtos.FieldDescriptorProto.Type.TYPE_STRING;
            } else {
                throw new InvalidTypeException("not support type : " + dataType.getName(), column.getColumnName(), dataType.getName());
            }
            fieldBuilder.setType(fieldType);
            fieldBuilder.setNumber(fieldNum++);
            if (column.containsNotNullConstaint()) {
                fieldBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_REQUIRED);
            } else {
                fieldBuilder.setLabel(DescriptorProtos.FieldDescriptorProto.Label.LABEL_OPTIONAL);
            }
            msgTypeBuilder.addField(fieldBuilder.build());
        }
        DescriptorProtos.FileDescriptorProto fileDescriptorProto = DescriptorProtos.FileDescriptorProto.newBuilder().addMessageType(msgTypeBuilder.build()).build();
        Descriptors.FileDescriptor fileDescriptor = null;
        try {
            fileDescriptor = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescriptorProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
        }
        catch (Descriptors.DescriptorValidationException e) {
            throw new SQLException(e.getMessage());
        }
        return fileDescriptor.findMessageTypeByName(tableName);
    }
}

