/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.opds.udf;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.ast.expr.SQLMethodInvokeExpr;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.visitor.SchemaStatVisitor;
import com.aliyun.odps.udf.UDF;
import java.util.List;

public class ExportFunctions
extends UDF {
    public String evaluate(String sql) throws Exception {
        return this.evaluate(sql, null, false);
    }

    public String evaluate(String sql, String dbTypeName) throws Exception {
        return this.evaluate(sql, dbTypeName, false);
    }

    public String evaluate(String sql, String dbTypeName, boolean throwError) throws Exception {
        DbType dbType = dbTypeName == null ? null : DbType.valueOf(dbTypeName);
        try {
            String funcName;
            SQLMethodInvokeExpr func;
            int i;
            List<SQLStatement> statementList = SQLUtils.parseStatements(sql, dbType, new SQLParserFeature[0]);
            SchemaStatVisitor visitor = SQLUtils.createSchemaStatVisitor(dbType);
            for (SQLStatement stmt : statementList) {
                stmt.accept(visitor);
            }
            StringBuffer buf = new StringBuffer();
            List<SQLMethodInvokeExpr> functions = visitor.getFunctions();
            for (i = 0; i < functions.size(); ++i) {
                if (i != 0) {
                    buf.append(",");
                }
                func = functions.get(i);
                funcName = func.getMethodName();
                buf.append(funcName);
            }
            for (i = 0; i < visitor.getAggregateFunctions().size(); ++i) {
                if (buf.length() > 0) {
                    buf.append(",");
                }
                func = visitor.getAggregateFunctions().get(i);
                funcName = func.getMethodName();
                buf.append(funcName);
            }
            return buf.toString();
        }
        catch (Exception ex) {
            System.err.println("error sql : " + sql);
            ex.printStackTrace();
            if (throwError) {
                throw ex;
            }
            return null;
        }
    }
}

