/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.support.logging;

import com.alibaba.fastsql.support.logging.Log;
import com.alibaba.fastsql.support.logging.NoLoggingImpl;
import com.alibaba.fastsql.support.logging.Resources;
import java.lang.reflect.Constructor;

public class LogFactory {
    private static Constructor logConstructor;

    private static void tryImplementation(String testClassName, String implClassName) {
        if (logConstructor != null) {
            return;
        }
        try {
            Resources.classForName(testClassName);
            Class<?> implClass = Resources.classForName(implClassName);
            logConstructor = implClass.getConstructor(String.class);
            Class declareClass = logConstructor.getDeclaringClass();
            if (!Log.class.isAssignableFrom(declareClass)) {
                logConstructor = null;
            }
            try {
                if (null != logConstructor) {
                    logConstructor.newInstance(LogFactory.class.getName());
                }
            }
            catch (Exception t) {
                logConstructor = null;
            }
            catch (ExceptionInInitializerError t) {
                logConstructor = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static Log getLog(Class clazz) {
        return LogFactory.getLog(clazz.getName());
    }

    public static Log getLog(String loggerName) {
        try {
            return (Log)logConstructor.newInstance(loggerName);
        }
        catch (ExceptionInInitializerError t) {
            throw new RuntimeException("Error creating logger for logger '" + loggerName + "'.  Cause: " + t, t);
        }
        catch (Exception t) {
            throw new RuntimeException("Error creating logger for logger '" + loggerName + "'.  Cause: " + t, t);
        }
    }

    public static synchronized void selectLog4JLogging() {
        try {
            Resources.classForName("org.apache.log4j.Logger");
            Class<?> implClass = Resources.classForName("com.alibaba.fastsql.support.logging.Log4jImpl");
            logConstructor = implClass.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static synchronized void selectJavaLogging() {
        try {
            Resources.classForName("java.util.logging.Logger");
            Class<?> implClass = Resources.classForName("com.alibaba.fastsql.support.logging.Jdk14LoggingImpl");
            logConstructor = implClass.getConstructor(String.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static {
        try {
            logConstructor = NoLoggingImpl.class.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }
}

