/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.transform;

import com.alibaba.fastsql.sql.ast.SQLExpr;
import com.alibaba.fastsql.sql.ast.SQLName;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOpExprGroup;
import com.alibaba.fastsql.sql.ast.expr.SQLBinaryOperator;
import com.alibaba.fastsql.sql.ast.expr.SQLPropertyExpr;
import com.alibaba.fastsql.sql.ast.statement.SQLExprTableSource;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectGroupByClause;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectItem;
import com.alibaba.fastsql.sql.ast.statement.SQLSelectQuery;
import com.alibaba.fastsql.sql.ast.statement.SQLUnionQuery;
import com.alibaba.fastsql.sql.dialect.mysql.ast.statement.MySqlSelectQueryBlock;
import com.alibaba.fastsql.sql.dialect.mysql.visitor.MySqlASTVisitorAdapter;
import com.alibaba.fastsql.sql.transform.SQLTableExtractorVisitor;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SQLUnifiedVisitor
extends MySqlASTVisitorAdapter {
    @Override
    public boolean visit(MySqlSelectQueryBlock x) {
        SQLTableExtractorVisitor visitor = new SQLTableExtractorVisitor();
        x.accept(visitor);
        Map<String, String> tables = visitor.getTables();
        List<SQLSelectItem> selectList = x.getSelectList();
        for (SQLSelectItem item : selectList) {
            SQLPropertyExpr expr;
            SQLExpr owner;
            String realTable;
            if (item.getExpr() instanceof SQLPropertyExpr && (realTable = tables.get((owner = (expr = (SQLPropertyExpr)item.getExpr()).getOwner()).toString().toLowerCase())) != null) {
                expr.setOwner(realTable);
            }
            item.setAlias(null);
        }
        Collections.sort(selectList, new Comparator<SQLSelectItem>(){

            @Override
            public int compare(SQLSelectItem o1, SQLSelectItem o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        if (x.getFrom() != null) {
            x.getFrom().accept(this);
        }
        if (x.getWhere() != null) {
            x.getWhere().accept(this);
        }
        if (x.getGroupBy() != null) {
            x.getGroupBy().accept(this);
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExpr x) {
        SQLBinaryOperator operator = x.getOperator();
        if (operator == SQLBinaryOperator.BooleanOr || operator == SQLBinaryOperator.BooleanAnd) {
            SQLExpr left = x.getLeft();
            left.accept(this);
            SQLExpr right = x.getRight();
            right.accept(this);
            int compareResult = left.toString().compareToIgnoreCase(right.toString());
            if (compareResult > 0) {
                x.setLeft(right);
                x.setRight(left);
            }
        }
        return false;
    }

    @Override
    public boolean visit(SQLBinaryOpExprGroup x) {
        Collections.sort(x.getItems(), new Comparator<SQLExpr>(){

            @Override
            public int compare(SQLExpr o1, SQLExpr o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        return false;
    }

    @Override
    public boolean visit(SQLUnionQuery x) {
        SQLSelectQuery left = x.getLeft();
        SQLSelectQuery right = x.getRight();
        left.accept(this);
        right.accept(this);
        int compareResult = left.toString().compareToIgnoreCase(right.toString());
        if (compareResult > 0) {
            x.setLeft(right);
            x.setRight(left);
        }
        return false;
    }

    @Override
    public boolean visit(SQLExprTableSource x) {
        String tablename = ((SQLName)x.getExpr()).getSimpleName();
        x.setAlias(tablename);
        return false;
    }

    @Override
    public boolean visit(SQLSelectGroupByClause x) {
        Collections.sort(x.getItems(), new Comparator<SQLExpr>(){

            @Override
            public int compare(SQLExpr o1, SQLExpr o2) {
                return o1.toString().compareToIgnoreCase(o2.toString());
            }
        });
        SQLExpr having = x.getHaving();
        if (having != null) {
            having.accept(this);
        }
        return false;
    }
}

