/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.fastsql.sql.transform;

import com.alibaba.fastsql.DbType;
import com.alibaba.fastsql.sql.SQLUtils;
import com.alibaba.fastsql.sql.ast.SQLStatement;
import com.alibaba.fastsql.sql.parser.SQLParserFeature;
import com.alibaba.fastsql.sql.parser.SQLParserUtils;
import com.alibaba.fastsql.sql.parser.SQLType;
import com.alibaba.fastsql.sql.transform.SQLUnifiedVisitor;
import com.alibaba.fastsql.sql.visitor.ParameterizedOutputVisitorUtils;
import com.alibaba.fastsql.util.FnvHash;
import com.alibaba.fastsql.util.StringUtils;

public class SQLUnifiedUtils {
    public static long unifyHash(String sql, DbType type) {
        String unifySQL = SQLUnifiedUtils.unifySQL(sql, DbType.mysql);
        return FnvHash.fnv1a_64_lower(unifySQL);
    }

    public static String unifySQL(String sql, DbType type) {
        if (StringUtils.isEmpty(sql)) {
            throw new IllegalArgumentException("sql is empty.");
        }
        if (SQLParserUtils.getSQLType(sql, type) != SQLType.SELECT) {
            throw new IllegalArgumentException("sql is not select statement.");
        }
        String parameterizeSQL = ParameterizedOutputVisitorUtils.parameterize(sql, DbType.mysql);
        SQLStatement stmt = SQLUtils.parseSingleStatement(parameterizeSQL, DbType.mysql, SQLParserFeature.EnableSQLBinaryOpExprGroup);
        stmt.accept(new SQLUnifiedVisitor());
        return SQLUtils.toMySqlString(stmt);
    }
}

